/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import net.sf.jasperreports.charts.ChartContext;
import net.sf.jasperreports.charts.ChartTheme;
import net.sf.jasperreports.charts.ChartThemeBundle;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.util.JRFontUtil;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleEdge;

public class DefaultChartTheme
implements ChartTheme {
    protected static final Color TRANSPARENT_PAINT = new Color(0, 0, 0, 0);
    private ChartContext chartContext = null;
    public static final ChartThemeBundle BUNDLE = new ChartThemeBundle(){
        private static final String NAME = "default";

        public String[] getChartThemeNames() {
            return new String[]{NAME};
        }

        public ChartTheme getChartTheme(String themeName) {
            if (NAME.equals(themeName)) {
                return new DefaultChartTheme();
            }
            return null;
        }
    };

    protected JRChart getChart() {
        return this.chartContext.getChart();
    }

    protected JRChartPlot getPlot() {
        return this.getChart().getPlot();
    }

    protected Dataset getDataset() {
        return this.chartContext.getDataset();
    }

    protected Object getLabelGenerator() {
        return this.chartContext.getLabelGenerator();
    }

    protected Locale getLocale() {
        return this.chartContext.getLocale();
    }

    protected final Object evaluateExpression(JRExpression expression) throws JRException {
        return this.chartContext.evaluateExpression(expression);
    }

    public JFreeChart createChart(ChartContext chartContext) throws JRException {
        this.chartContext = chartContext;
        JFreeChart jfreeChart = null;
        switch (this.getChart().getChartType()) {
            case 1: {
                jfreeChart = this.createAreaChart();
                break;
            }
            case 3: {
                jfreeChart = this.createBarChart();
                break;
            }
            case 2: {
                jfreeChart = this.createBar3DChart();
                break;
            }
            case 4: {
                jfreeChart = this.createBubbleChart();
                break;
            }
            case 5: {
                jfreeChart = this.createCandlestickChart();
                break;
            }
            case 6: {
                jfreeChart = this.createHighLowChart();
                break;
            }
            case 7: {
                jfreeChart = this.createLineChart();
                break;
            }
            case 17: {
                jfreeChart = this.createMeterChart();
                break;
            }
            case 19: {
                break;
            }
            case 9: {
                jfreeChart = this.createPieChart();
                break;
            }
            case 8: {
                jfreeChart = this.createPie3DChart();
                break;
            }
            case 10: {
                jfreeChart = this.createScatterChart();
                break;
            }
            case 12: {
                jfreeChart = this.createStackedBarChart();
                break;
            }
            case 11: {
                jfreeChart = this.createStackedBar3DChart();
                break;
            }
            case 18: {
                jfreeChart = this.createThermometerChart();
                break;
            }
            case 16: {
                jfreeChart = this.createTimeSeriesChart();
                break;
            }
            case 13: {
                jfreeChart = this.createXyAreaChart();
                break;
            }
            case 14: {
                jfreeChart = this.createXYBarChart();
                break;
            }
            case 15: {
                jfreeChart = this.createXyLineChart();
                break;
            }
            case 20: {
                jfreeChart = this.createStackedAreaChart();
                break;
            }
            case 21: {
                jfreeChart = this.createGanttChart();
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type " + this.getChart().getChartType() + " not supported.");
            }
        }
        return jfreeChart;
    }

    protected void configureChart(JFreeChart jfreeChart) throws JRException {
        LegendTitle legend;
        String subtitleText;
        if (this.getChart().getMode() == 1) {
            jfreeChart.setBackgroundPaint((Paint)this.getChart().getBackcolor());
        } else {
            jfreeChart.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        }
        RectangleEdge titleEdge = DefaultChartTheme.getEdge(this.getChart().getTitlePositionByte(), RectangleEdge.TOP);
        if (jfreeChart.getTitle() != null) {
            TextTitle title = jfreeChart.getTitle();
            title.setPaint((Paint)this.getChart().getTitleColor());
            title.setFont(JRFontUtil.getAwtFont(this.getChart().getTitleFont(), this.getLocale()));
            title.setPosition(titleEdge);
        }
        if ((subtitleText = (String)this.evaluateExpression(this.getChart().getSubtitleExpression())) != null) {
            TextTitle subtitle = new TextTitle(subtitleText);
            subtitle.setPaint((Paint)this.getChart().getSubtitleColor());
            subtitle.setFont(JRFontUtil.getAwtFont(this.getChart().getSubtitleFont(), this.getLocale()));
            subtitle.setPosition(titleEdge);
            jfreeChart.addSubtitle((Title)subtitle);
        }
        if ((legend = jfreeChart.getLegend()) != null) {
            legend.setItemPaint((Paint)this.getChart().getLegendColor());
            if (this.getChart().getOwnLegendBackgroundColor() == null) {
                legend.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
            } else {
                legend.setBackgroundPaint((Paint)this.getChart().getLegendBackgroundColor());
            }
            legend.setItemFont(JRFontUtil.getAwtFont(this.getChart().getLegendFont(), this.getLocale()));
            legend.setPosition(DefaultChartTheme.getEdge(this.getChart().getLegendPositionByte(), RectangleEdge.BOTTOM));
        }
        this.configurePlot(jfreeChart.getPlot());
    }

    protected void configurePlot(Plot plot) {
        SortedSet seriesColors;
        plot.setOutlinePaint((Paint)TRANSPARENT_PAINT);
        if (this.getPlot().getOwnBackcolor() == null) {
            plot.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        } else {
            plot.setBackgroundPaint((Paint)this.getPlot().getBackcolor());
        }
        float backgroundAlpha = this.getPlot().getBackgroundAlphaFloat() == null ? 1.0f : this.getPlot().getBackgroundAlphaFloat().floatValue();
        float foregroundAlpha = this.getPlot().getForegroundAlphaFloat() == null ? 1.0f : this.getPlot().getForegroundAlphaFloat().floatValue();
        plot.setBackgroundAlpha(backgroundAlpha);
        plot.setForegroundAlpha(foregroundAlpha);
        if (plot instanceof CategoryPlot) {
            double labelRotation;
            CategoryAxis axis = ((CategoryPlot)plot).getDomainAxis();
            double d = labelRotation = this.getPlot().getLabelRotationDouble() == null ? 0.0 : this.getPlot().getLabelRotationDouble();
            if (labelRotation == 90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            } else if (labelRotation == -90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            } else if (labelRotation < 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)(-labelRotation / 180.0 * Math.PI)));
            } else if (labelRotation > 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createDownRotationLabelPositions((double)(labelRotation / 180.0 * Math.PI)));
            }
        }
        if ((seriesColors = this.getPlot().getSeriesColors()) != null && seriesColors.size() > 0) {
            if (seriesColors.size() == 1) {
                Paint[] colors = new Paint[DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length + 1];
                colors[0] = ((JRChartPlot.JRSeriesColor)seriesColors.first()).getColor();
                for (int i = 0; i < DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length; ++i) {
                    colors[i + 1] = DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE[i];
                }
                plot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(colors, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            } else if (seriesColors.size() > 1) {
                Paint[] colors = new Color[seriesColors.size()];
                JRChartPlot.JRSeriesColor[] colorSequence = new JRChartPlot.JRSeriesColor[seriesColors.size()];
                seriesColors.toArray(colorSequence);
                for (int i = 0; i < colorSequence.length; ++i) {
                    colors[i] = colorSequence[i].getColor();
                }
                plot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(colors, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            }
        }
    }

    protected void configureAxis(Axis axis, JRFont labelFont, Color labelColor, JRFont tickLabelFont, Color tickLabelColor, String tickLabelMask, Color lineColor) {
        axis.setLabelFont(JRFontUtil.getAwtFont(labelFont, this.getLocale()));
        axis.setTickLabelFont(JRFontUtil.getAwtFont(tickLabelFont, this.getLocale()));
        if (labelColor != null) {
            axis.setLabelPaint((Paint)labelColor);
        }
        if (tickLabelColor != null) {
            axis.setTickLabelPaint((Paint)tickLabelColor);
        }
        if (lineColor != null) {
            axis.setAxisLinePaint((Paint)lineColor);
            axis.setTickMarkPaint((Paint)lineColor);
        }
        if (tickLabelMask != null) {
            if (axis instanceof NumberAxis) {
                NumberFormat fmt = NumberFormat.getInstance();
                if (fmt instanceof DecimalFormat) {
                    ((DecimalFormat)fmt).applyPattern(tickLabelMask);
                }
                ((NumberAxis)axis).setNumberFormatOverride(fmt);
            } else if (axis instanceof DateAxis) {
                DateFormat fmt = null;
                fmt = tickLabelMask.equals("SHORT") || tickLabelMask.equals("DateFormat.SHORT") ? DateFormat.getDateInstance(3) : (tickLabelMask.equals("MEDIUM") || tickLabelMask.equals("DateFormat.MEDIUM") ? DateFormat.getDateInstance(2) : (tickLabelMask.equals("LONG") || tickLabelMask.equals("DateFormat.LONG") ? DateFormat.getDateInstance(1) : (tickLabelMask.equals("FULL") || tickLabelMask.equals("DateFormat.FULL") ? DateFormat.getDateInstance(0) : new SimpleDateFormat(tickLabelMask))));
                ((DateAxis)axis).setDateFormatOverride(fmt);
            }
        }
    }

    protected JFreeChart createAreaChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createAreaChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createBar3DChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createBarChart3D((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBar3DPlot bar3DPlot = (JRBar3DPlot)this.getPlot();
        BarRenderer3D barRenderer3D = new BarRenderer3D(bar3DPlot.getXOffsetDouble() == null ? 12.0 : bar3DPlot.getXOffsetDouble(), bar3DPlot.getYOffsetDouble() == null ? 8.0 : bar3DPlot.getYOffsetDouble());
        barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        barRenderer3D.setBaseItemLabelsVisible(bar3DPlot.getShowLabels() == null ? false : bar3DPlot.getShowLabels());
        categoryPlot.setRenderer((CategoryItemRenderer)barRenderer3D);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createBarChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createBarChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor());
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setBaseItemLabelsVisible(barPlot.getShowLabels() == null ? false : barPlot.getShowLabels());
        return jfreeChart;
    }

    protected JFreeChart createBubbleChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createBubbleChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getXAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getYAxisLabelExpression())), (XYZDataset)((XYZDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRBubblePlot bubblePlot = (JRBubblePlot)this.getPlot();
        int scaleType = bubblePlot.getScaleTypeInteger() == null ? 2 : bubblePlot.getScaleTypeInteger();
        XYBubbleRenderer bubbleRenderer = new XYBubbleRenderer(scaleType);
        xyPlot.setRenderer((XYItemRenderer)bubbleRenderer);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), bubblePlot.getXAxisLabelFont(), bubblePlot.getXAxisLabelColor(), bubblePlot.getXAxisTickLabelFont(), bubblePlot.getXAxisTickLabelColor(), bubblePlot.getXAxisTickLabelMask(), bubblePlot.getXAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), bubblePlot.getYAxisLabelFont(), bubblePlot.getYAxisLabelColor(), bubblePlot.getYAxisTickLabelFont(), bubblePlot.getYAxisTickLabelColor(), bubblePlot.getYAxisTickLabelMask(), bubblePlot.getYAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createCandlestickChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createCandlestickChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getTimeAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getValueAxisLabelExpression())), (OHLCDataset)((DefaultHighLowDataset)this.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRCandlestickPlot candlestickPlot = (JRCandlestickPlot)this.getPlot();
        CandlestickRenderer candlestickRenderer = (CandlestickRenderer)xyPlot.getRenderer();
        boolean isShowVolume = candlestickPlot.getShowVolume() == null ? true : candlestickPlot.getShowVolume();
        candlestickRenderer.setDrawVolume(isShowVolume);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), candlestickPlot.getTimeAxisLabelFont(), candlestickPlot.getTimeAxisLabelColor(), candlestickPlot.getTimeAxisTickLabelFont(), candlestickPlot.getTimeAxisTickLabelColor(), candlestickPlot.getTimeAxisTickLabelMask(), candlestickPlot.getTimeAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), candlestickPlot.getValueAxisLabelFont(), candlestickPlot.getValueAxisLabelColor(), candlestickPlot.getValueAxisTickLabelFont(), candlestickPlot.getValueAxisTickLabelColor(), candlestickPlot.getValueAxisTickLabelMask(), candlestickPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createHighLowChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createHighLowChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getTimeAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getValueAxisLabelExpression())), (OHLCDataset)((DefaultHighLowDataset)this.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRHighLowPlot highLowPlot = (JRHighLowPlot)this.getPlot();
        HighLowRenderer hlRenderer = (HighLowRenderer)xyPlot.getRenderer();
        boolean isShowOpenTicks = highLowPlot.getShowOpenTicks() == null ? false : highLowPlot.getShowOpenTicks();
        boolean isShowCloseTicks = highLowPlot.getShowCloseTicks() == null ? false : highLowPlot.getShowCloseTicks();
        hlRenderer.setDrawOpenTicks(isShowOpenTicks);
        hlRenderer.setDrawCloseTicks(isShowCloseTicks);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), highLowPlot.getTimeAxisLabelFont(), highLowPlot.getTimeAxisLabelColor(), highLowPlot.getTimeAxisTickLabelFont(), highLowPlot.getTimeAxisTickLabelColor(), highLowPlot.getTimeAxisTickLabelMask(), highLowPlot.getTimeAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), highLowPlot.getValueAxisLabelFont(), highLowPlot.getValueAxisLabelColor(), highLowPlot.getValueAxisTickLabelFont(), highLowPlot.getValueAxisTickLabelColor(), highLowPlot.getValueAxisTickLabelMask(), highLowPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createLineChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createLineChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        LineAndShapeRenderer lineRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        boolean isShowShapes = linePlot.getShowShapes() == null ? true : linePlot.getShowShapes();
        boolean isShowLines = linePlot.getShowLines() == null ? true : linePlot.getShowLines();
        lineRenderer.setBaseShapesVisible(isShowShapes);
        lineRenderer.setBaseLinesVisible(isShowLines);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createPie3DChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createPieChart3D((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (PieDataset)((PieDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        PiePlot3D piePlot3D = (PiePlot3D)jfreeChart.getPlot();
        JRPie3DPlot jrPlot = (JRPie3DPlot)this.getPlot();
        double depthFactor = jrPlot.getDepthFactorDouble() == null ? 0.2 : jrPlot.getDepthFactorDouble();
        boolean isCircular = jrPlot.getCircular() == null ? false : jrPlot.getCircular();
        piePlot3D.setDepthFactor(depthFactor);
        piePlot3D.setCircular(isCircular);
        PieSectionLabelGenerator labelGenerator = (PieSectionLabelGenerator)this.getLabelGenerator();
        if (labelGenerator != null) {
            piePlot3D.setLabelGenerator(labelGenerator);
        } else if (((JRPie3DPlot)this.getPlot()).getLabelFormat() != null) {
            piePlot3D.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(((JRPie3DPlot)this.getPlot()).getLabelFormat()));
        }
        if (((JRPie3DPlot)this.getPlot()).getLegendLabelFormat() != null) {
            piePlot3D.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(((JRPie3DPlot)this.getPlot()).getLegendLabelFormat()));
        }
        piePlot3D.setLabelFont(JRFontUtil.getAwtFont(new JRBaseFont(this.getChart(), null), this.getLocale()));
        piePlot3D.setLabelPaint((Paint)this.getChart().getForecolor());
        return jfreeChart;
    }

    protected JFreeChart createPieChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createPieChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (PieDataset)((PieDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        PiePlot piePlot = (PiePlot)jfreeChart.getPlot();
        JRPiePlot jrPlot = (JRPiePlot)this.getPlot();
        boolean isCircular = jrPlot.getCircular() == null ? true : jrPlot.getCircular();
        piePlot.setCircular(isCircular);
        PieSectionLabelGenerator labelGenerator = (PieSectionLabelGenerator)this.getLabelGenerator();
        if (labelGenerator != null) {
            piePlot.setLabelGenerator(labelGenerator);
        } else if (((JRPiePlot)this.getPlot()).getLabelFormat() != null) {
            piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(((JRPiePlot)this.getPlot()).getLabelFormat()));
        }
        if (((JRPiePlot)this.getPlot()).getLegendLabelFormat() != null) {
            piePlot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(((JRPiePlot)this.getPlot()).getLegendLabelFormat()));
        }
        piePlot.setLabelFont(JRFontUtil.getAwtFont(new JRBaseFont(this.getChart(), null), this.getLocale()));
        piePlot.setLabelPaint((Paint)this.getChart().getForecolor());
        return jfreeChart;
    }

    protected JFreeChart createScatterChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createScatterPlot((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getXAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getYAxisLabelExpression())), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        XYLineAndShapeRenderer plotRenderer = (XYLineAndShapeRenderer)((XYPlot)jfreeChart.getPlot()).getRenderer();
        JRScatterPlot scatterPlot = (JRScatterPlot)this.getPlot();
        boolean isShowLines = scatterPlot.getShowLines() == null ? true : scatterPlot.getShowLines();
        boolean isShowShapes = scatterPlot.getShowShapes() == null ? true : scatterPlot.getShowShapes();
        plotRenderer.setBaseLinesVisible(isShowLines);
        plotRenderer.setBaseShapesVisible(isShowShapes);
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), scatterPlot.getXAxisLabelFont(), scatterPlot.getXAxisLabelColor(), scatterPlot.getXAxisTickLabelFont(), scatterPlot.getXAxisTickLabelColor(), scatterPlot.getXAxisTickLabelMask(), scatterPlot.getXAxisLineColor());
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), scatterPlot.getYAxisLabelFont(), scatterPlot.getYAxisLabelColor(), scatterPlot.getYAxisTickLabelFont(), scatterPlot.getYAxisTickLabelColor(), scatterPlot.getYAxisTickLabelMask(), scatterPlot.getYAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createStackedBar3DChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createStackedBarChart3D((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBar3DPlot bar3DPlot = (JRBar3DPlot)this.getPlot();
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D(bar3DPlot.getXOffsetDouble() == null ? 12.0 : bar3DPlot.getXOffsetDouble(), bar3DPlot.getYOffsetDouble() == null ? 8.0 : bar3DPlot.getYOffsetDouble());
        stackedBarRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        stackedBarRenderer3D.setBaseItemLabelsVisible(bar3DPlot.getShowLabels() == null ? false : bar3DPlot.getShowLabels());
        categoryPlot.setRenderer((CategoryItemRenderer)stackedBarRenderer3D);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createStackedBarChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createStackedBarChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setBaseItemLabelsVisible(isShowLabels);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createStackedAreaChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createStackedAreaChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getValueAxisLineColor());
        ((CategoryPlot)jfreeChart.getPlot()).getDomainAxis().setCategoryMargin(0.0);
        return jfreeChart;
    }

    protected JFreeChart createXyAreaChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createXYAreaChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression())), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createXYBarChart() throws JRException {
        IntervalXYDataset tmpDataset = (IntervalXYDataset)this.getDataset();
        boolean isDate = true;
        if (this.getChart().getDataset().getDatasetType() == 3) {
            isDate = false;
        }
        JFreeChart jfreeChart = ChartFactory.createXYBarChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression())), (boolean)isDate, (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression())), (IntervalXYDataset)tmpDataset, (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYItemRenderer itemRenderer = xyPlot.getRenderer();
        itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)this.getLabelGenerator());
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        itemRenderer.setBaseItemLabelsVisible(isShowLabels);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createXyLineChart() throws JRException {
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        JFreeChart jfreeChart = ChartFactory.createXYLineChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(linePlot.getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(linePlot.getValueAxisLabelExpression())), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)linePlot.getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisLineColor());
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)jfreeChart.getXYPlot().getRenderer();
        boolean isShowShapes = linePlot.getShowShapes() == null ? true : linePlot.getShowShapes();
        boolean isShowLines = linePlot.getShowLines() == null ? true : linePlot.getShowLines();
        lineRenderer.setBaseShapesVisible(isShowShapes);
        lineRenderer.setBaseLinesVisible(isShowLines);
        return jfreeChart;
    }

    protected JFreeChart createTimeSeriesChart() throws JRException {
        String timeAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getTimeAxisLabelExpression());
        String valueAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getValueAxisLabelExpression());
        JFreeChart jfreeChart = ChartFactory.createTimeSeriesChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)timeAxisLabel, (String)valueAxisLabel, (XYDataset)((TimeSeriesCollection)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRTimeSeriesPlot timeSeriesPlot = (JRTimeSeriesPlot)this.getPlot();
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
        boolean isShowShapes = timeSeriesPlot.getShowShapes() == null ? true : timeSeriesPlot.getShowShapes();
        boolean isShowLines = timeSeriesPlot.getShowLines() == null ? true : timeSeriesPlot.getShowLines();
        lineRenderer.setBaseLinesVisible(isShowLines);
        lineRenderer.setBaseShapesVisible(isShowShapes);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), timeSeriesPlot.getTimeAxisLabelFont(), timeSeriesPlot.getTimeAxisLabelColor(), timeSeriesPlot.getTimeAxisTickLabelFont(), timeSeriesPlot.getTimeAxisTickLabelColor(), timeSeriesPlot.getTimeAxisTickLabelMask(), timeSeriesPlot.getTimeAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), timeSeriesPlot.getValueAxisLabelFont(), timeSeriesPlot.getValueAxisLabelColor(), timeSeriesPlot.getValueAxisTickLabelFont(), timeSeriesPlot.getValueAxisTickLabelColor(), timeSeriesPlot.getValueAxisTickLabelMask(), timeSeriesPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createGanttChart() throws JRException {
        JFreeChart jfreeChart = ChartFactory.createGanttChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression())), (IntervalCategoryDataset)((GanttCategoryDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor());
        ((DateAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((DateAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor());
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setBaseItemLabelsVisible(isShowLabels);
        return jfreeChart;
    }

    protected Range convertRange(JRDataRange dataRange) throws JRException {
        if (dataRange == null) {
            return null;
        }
        Number low = (Number)this.evaluateExpression(dataRange.getLowExpression());
        Number high = (Number)this.evaluateExpression(dataRange.getHighExpression());
        return new Range(low != null ? low.doubleValue() : 0.0, high != null ? high.doubleValue() : 100.0);
    }

    protected MeterInterval convertInterval(JRMeterInterval interval) throws JRException {
        String label = interval.getLabel();
        if (label == null) {
            label = "";
        }
        Range range = this.convertRange(interval.getDataRange());
        Color color = interval.getBackgroundColor() == null ? this.getChart().getBackcolor() : interval.getBackgroundColor();
        float[] components = color.getRGBColorComponents(null);
        float alpha = interval.getAlphaDouble() == null ? 1.0f : interval.getAlphaDouble().floatValue();
        Color alphaColor = new Color(components[0], components[1], components[2], alpha);
        return new MeterInterval(label, range, (Paint)alphaColor, null, (Paint)alphaColor);
    }

    protected JFreeChart createMeterChart() throws JRException {
        List intervals;
        JRValueDisplay display;
        int shape;
        JRMeterPlot jrPlot = (JRMeterPlot)this.getPlot();
        MeterPlot chartPlot = new MeterPlot((ValueDataset)this.getDataset());
        int n = shape = jrPlot.getShapeByte() == null ? 2 : jrPlot.getShapeByte().intValue();
        if (shape == 0) {
            chartPlot.setDialShape(DialShape.CHORD);
        } else if (shape == 1) {
            chartPlot.setDialShape(DialShape.CIRCLE);
        } else {
            chartPlot.setDialShape(DialShape.PIE);
        }
        chartPlot.setRange(this.convertRange(jrPlot.getDataRange()));
        int meterAngle = jrPlot.getMeterAngleInteger() == null ? 180 : jrPlot.getMeterAngleInteger();
        chartPlot.setMeterAngle(meterAngle);
        String units = jrPlot.getUnits();
        if (units != null && units.length() > 0) {
            chartPlot.setUnits(units);
        }
        double tickInterval = jrPlot.getTickIntervalDouble() == null ? 10.0 : jrPlot.getTickIntervalDouble();
        chartPlot.setTickSize(tickInterval);
        Color color = jrPlot.getMeterBackgroundColor();
        if (color != null) {
            chartPlot.setDialBackgroundPaint((Paint)color);
        }
        if ((color = jrPlot.getNeedleColor()) != null) {
            chartPlot.setNeedlePaint((Paint)color);
        }
        if ((display = jrPlot.getValueDisplay()) != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setTickLabelFormat((NumberFormat)new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                chartPlot.setValueFont(JRFontUtil.getAwtFont(display.getFont(), this.getLocale()));
            }
        }
        if ((color = jrPlot.getTickColor()) != null) {
            chartPlot.setTickPaint((Paint)color);
        }
        if ((intervals = jrPlot.getIntervals()) != null) {
            Iterator iter = intervals.iterator();
            while (iter.hasNext()) {
                JRMeterInterval interval = (JRMeterInterval)iter.next();
                chartPlot.addInterval(this.convertInterval(interval));
            }
        }
        JFreeChart jfreeChart = new JFreeChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), null, (Plot)chartPlot, this.isShowLegend());
        this.configureChart(jfreeChart);
        return jfreeChart;
    }

    protected JFreeChart createThermometerChart() throws JRException {
        JRValueDisplay display;
        JRThermometerPlot jrPlot = (JRThermometerPlot)this.getPlot();
        ThermometerPlot chartPlot = new ThermometerPlot((ValueDataset)this.getDataset());
        Range range = this.convertRange(jrPlot.getDataRange());
        chartPlot.setLowerBound(range.getLowerBound());
        chartPlot.setUpperBound(range.getUpperBound());
        chartPlot.setUnits(0);
        Color color = jrPlot.getMercuryColor();
        if (color != null) {
            chartPlot.setMercuryPaint((Paint)color);
        }
        if ((display = jrPlot.getValueDisplay()) != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setValueFormat((NumberFormat)new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                chartPlot.setValueFont(JRFontUtil.getAwtFont(display.getFont(), this.getLocale()));
            }
        }
        int valueLocation = jrPlot.getValueLocationByte() == null ? 3 : (int)jrPlot.getValueLocationByte().byteValue();
        switch (valueLocation) {
            case 0: {
                chartPlot.setValueLocation(0);
                break;
            }
            case 1: {
                chartPlot.setValueLocation(2);
                break;
            }
            case 2: {
                chartPlot.setValueLocation(1);
                break;
            }
            default: {
                chartPlot.setValueLocation(3);
            }
        }
        range = this.convertRange(jrPlot.getLowRange());
        if (range != null) {
            chartPlot.setSubrangeInfo(2, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getMediumRange())) != null) {
            chartPlot.setSubrangeInfo(1, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getHighRange())) != null) {
            chartPlot.setSubrangeInfo(0, range.getLowerBound(), range.getUpperBound());
        }
        JFreeChart jfreeChart = new JFreeChart((Plot)chartPlot);
        this.configureChart(jfreeChart);
        return jfreeChart;
    }

    protected AxisLocation getChartAxisLocation(JRChartAxis chartAxis) {
        return chartAxis.getPositionByte() != null && chartAxis.getPositionByte() == 2 ? AxisLocation.BOTTOM_OR_RIGHT : AxisLocation.TOP_OR_LEFT;
    }

    private static RectangleEdge getEdge(Byte position, RectangleEdge defaultPosition) {
        RectangleEdge edge = defaultPosition;
        if (position != null) {
            switch (position) {
                case 1: {
                    edge = RectangleEdge.TOP;
                    break;
                }
                case 2: {
                    edge = RectangleEdge.BOTTOM;
                    break;
                }
                case 3: {
                    edge = RectangleEdge.LEFT;
                    break;
                }
                case 4: {
                    edge = RectangleEdge.RIGHT;
                }
            }
        }
        return edge;
    }

    protected boolean isShowLegend() {
        return this.getChart().getShowLegend() == null ? true : this.getChart().getShowLegend();
    }
}

