/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLStorage {
    private static final Logger LOG = Logger.getLogger(XMLStorage.class.getName());

    private XMLStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(FileObject fileObject, Document document) {
        assert (fileObject != null) : "FileObject can't be null";
        assert (document != null) : "Document can't be null";
        try {
            FileLock fileLock = fileObject.lock();
            try {
                OutputStream outputStream = fileObject.getOutputStream(fileLock);
                try {
                    XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Can't save editor settings to " + fileObject.getPath(), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object load(FileObject fileObject, Handler handler) {
        assert (fileObject != null) : "Settings file must not be null";
        handler.setProcessedFile(fileObject);
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader((boolean)true);
            xMLReader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
            xMLReader.setContentHandler(handler);
            xMLReader.setErrorHandler(handler);
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            InputStream inputStream = fileObject.getInputStream();
            try {
                xMLReader.parse(new InputSource(inputStream));
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Invalid or corrupted file: " + fileObject.getPath(), exception);
        }
        finally {
            handler.setProcessedFile(null);
        }
        return handler.getResult();
    }

    public static class Handler
    extends DefaultHandler
    implements LexicalHandler {
        private FileObject file;
        private boolean isModuleFile;
        private boolean isDefaultProfile;
        private Object result;

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.log("warning", sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.log("error", sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.log("fatal error", sAXParseException);
            throw sAXParseException;
        }

        public InputSource resolveEntity(String string, String string2) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void endEntity(String string) throws SAXException {
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
        }

        public void startEntity(String string) throws SAXException {
        }

        public void setResult(Object object) {
            this.result = object;
        }

        public Object getResult() {
            return this.result;
        }

        protected final FileObject getProcessedFile() {
            return this.file;
        }

        protected final boolean isModuleFile() {
            return this.isModuleFile;
        }

        protected final boolean isDefaultProfile() {
            return this.isDefaultProfile;
        }

        private void log(String string, SAXParseException sAXParseException) {
            if (this.file == null) {
                LOG.log(Level.FINE, "XML parser " + string, sAXParseException);
            } else {
                Level level = this.isModuleFile() ? Level.WARNING : Level.FINE;
                LOG.log(level, "XML parser " + string + " in file " + this.file.getPath(), sAXParseException);
            }
        }

        private void setProcessedFile(FileObject fileObject) {
            FileObject fileObject2;
            this.file = fileObject;
            this.isModuleFile = false;
            this.isDefaultProfile = false;
            if (this.file != null && (fileObject2 = this.file.getParent()) != null) {
                this.isModuleFile = fileObject2.getNameExt().contains("Default");
                if ((fileObject2 = fileObject2.getParent()) != null) {
                    this.isDefaultProfile = fileObject2.getNameExt().contains("NetBeans");
                }
            }
        }
    }
}

