/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.netbeans.modules.palette.DefaultSettings;
import org.netbeans.modules.palette.ui.CheckRenderer;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

class CheckListener
implements MouseListener,
KeyListener {
    DefaultSettings settings;

    public CheckListener(DefaultSettings defaultSettings) {
        this.settings = defaultSettings;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        JTree jTree = (JTree)mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        int n2 = mouseEvent.getX();
        int n3 = jTree.getRowForLocation(n2, n = mouseEvent.getY());
        TreePath treePath = jTree.getPathForRow(n3);
        if (null == treePath) {
            return;
        }
        Node node = Visualizer.findNode((Object)treePath.getLastPathComponent());
        if (null == node) {
            return;
        }
        Rectangle rectangle = CheckRenderer.getCheckBoxRectangle();
        Rectangle rectangle2 = jTree.getPathBounds(treePath);
        rectangle.setLocation(rectangle.x + rectangle2.x, rectangle.y + rectangle2.y);
        if (mouseEvent.getClickCount() == 1 && rectangle.contains(point)) {
            boolean bl = this.settings.isNodeVisible(node);
            this.settings.setNodeVisible(node, !bl);
            jTree.repaint();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == ' ') {
            JTree jTree = (JTree)keyEvent.getSource();
            TreePath treePath = jTree.getSelectionPath();
            if (null == treePath) {
                return;
            }
            Node node = Visualizer.findNode((Object)treePath.getLastPathComponent());
            if (null == node) {
                return;
            }
            boolean bl = this.settings.isNodeVisible(node);
            this.settings.setNodeVisible(node, !bl);
            jTree.repaint();
            keyEvent.consume();
        }
    }
}

