/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.guards;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.guards.GuardedSectionsImpl;
import org.openide.text.NbDocument;

public final class PositionBounds {
    private Position begin;
    private Position end;
    private final GuardedSectionsImpl guards;

    public PositionBounds(Position position, Position position2, GuardedSectionsImpl guardedSectionsImpl) {
        this.begin = position;
        this.end = position2;
        this.guards = guardedSectionsImpl;
    }

    public static PositionBounds create(int n, int n2, GuardedSectionsImpl guardedSectionsImpl) throws BadLocationException {
        StyledDocument styledDocument = guardedSectionsImpl.getDocument();
        return new PositionBounds(styledDocument.createPosition(n), styledDocument.createPosition(n2), guardedSectionsImpl);
    }

    public static PositionBounds createBodyBounds(int n, int n2, GuardedSectionsImpl guardedSectionsImpl) throws BadLocationException {
        StyledDocument styledDocument = guardedSectionsImpl.getDocument();
        return new PositionBounds(new BackwardPosition(styledDocument.createPosition(n - 1)), styledDocument.createPosition(n2), guardedSectionsImpl);
    }

    public static PositionBounds createUnresolved(int n, int n2, GuardedSectionsImpl guardedSectionsImpl) throws BadLocationException {
        StyledDocument styledDocument = guardedSectionsImpl.getDocument();
        return new PositionBounds(new UnresolvedPosition(n), new UnresolvedPosition(n2), guardedSectionsImpl);
    }

    public static PositionBounds createBodyUnresolved(int n, int n2, GuardedSectionsImpl guardedSectionsImpl) throws BadLocationException {
        return new PositionBounds(new BackwardPosition(new UnresolvedPosition(n - 1)), new UnresolvedPosition(n2), guardedSectionsImpl);
    }

    public void resolvePositions() throws BadLocationException {
        StyledDocument styledDocument = this.guards.getDocument();
        if (this.end instanceof UnresolvedPosition) {
            Position position = this.begin instanceof BackwardPosition ? (((BackwardPosition)this.begin).delegate = styledDocument.createPosition(((BackwardPosition)this.begin).delegate.getOffset())) : styledDocument.createPosition(this.begin.getOffset());
            Position position2 = styledDocument.createPosition(this.end.getOffset());
            this.begin = position;
            this.end = position2;
        }
    }

    public Position getBegin() {
        return this.begin;
    }

    public Position getEnd() {
        return this.end;
    }

    public void setText(final String string) throws BadLocationException {
        final StyledDocument styledDocument = this.guards.getDocument();
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[]{null};
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    int n = PositionBounds.this.begin.getOffset();
                    int n2 = PositionBounds.this.end.getOffset();
                    int n3 = string.length();
                    if (n3 == 0) {
                        if (n2 > n) {
                            styledDocument.remove(n, n2 - n);
                        }
                    } else {
                        int n4 = styledDocument.getLength();
                        if (n2 - n >= 1) {
                            styledDocument.insertString(n + 1, string, null);
                            n3 = styledDocument.getLength() - n4;
                            styledDocument.remove(n + 1 + n3, n2 - n - 1);
                            styledDocument.remove(n, 1);
                        } else {
                            styledDocument.insertString(n, string, null);
                            n3 = styledDocument.getLength() - n4;
                            if (n2 > n) {
                                styledDocument.remove(n + n3, n2 - n);
                            }
                            if (PositionBounds.this.begin.getOffset() != n) {
                                PositionBounds.this.begin = styledDocument.createPosition(n);
                            }
                            if (PositionBounds.this.end.getOffset() - n != n3) {
                                PositionBounds.this.end = styledDocument.createPosition(n + n3);
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        };
        NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
        if (badLocationExceptionArray[0] != null) {
            throw badLocationExceptionArray[0];
        }
    }

    public String getText() throws BadLocationException {
        StyledDocument styledDocument = this.guards.getDocument();
        int n = this.begin.getOffset();
        int n2 = this.end.getOffset();
        return styledDocument.getText(n, n2 - n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Position bounds[");
        try {
            String string = this.getText();
            stringBuilder.append(this.begin);
            stringBuilder.append(",");
            stringBuilder.append(this.end);
            stringBuilder.append(",\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        catch (BadLocationException badLocationException) {
            stringBuilder.append("Invalid: ");
            stringBuilder.append(badLocationException.getMessage());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static final class BackwardPosition
    implements Position {
        private Position delegate;

        public BackwardPosition(Position position) {
            this.delegate = position;
        }

        public int getOffset() {
            return this.delegate.getOffset() + 1;
        }
    }

    private static final class UnresolvedPosition
    implements Position {
        private int offset;

        public UnresolvedPosition(int n) {
            this.offset = n;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

