/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

import org.netbeans.lib.editor.util.GapList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlyOffsetGapList<E>
extends GapList<E> {
    private int offsetGapStart;
    private int offsetGapLength = 0x3FFFFFFF;

    protected abstract int elementRawOffset(E var1);

    protected abstract void setElementRawOffset(E var1, int var2);

    protected abstract boolean isElementFlyweight(E var1);

    protected abstract int elementLength(E var1);

    protected int startOffset() {
        return 0;
    }

    protected final int elementOffset(int n) {
        int n2;
        Object e = this.get(n);
        if (this.isElementFlyweight(e)) {
            n2 = 0;
            while (--n >= 0) {
                e = this.get(n);
                n2 += this.elementLength(e);
                if (this.isElementFlyweight(e)) continue;
                n2 += this.raw2RelOffset(this.elementRawOffset(e));
                break;
            }
        } else {
            n2 = this.raw2RelOffset(this.elementRawOffset(e));
        }
        return this.startOffset() + n2;
    }

    protected final int elementOrEndOffset(int n) {
        int n2;
        Object e;
        if (n == this.size() || this.isElementFlyweight(e = this.get(n))) {
            n2 = 0;
            while (--n >= 0) {
                e = this.get(n);
                n2 += this.elementLength(e);
                if (this.isElementFlyweight(e)) continue;
                n2 += this.raw2RelOffset(this.elementRawOffset(e));
                break;
            }
        } else {
            n2 = this.raw2RelOffset(this.elementRawOffset(e));
        }
        return this.startOffset() + n2;
    }

    public void defaultInsertUpdate(int n, int n2) {
        assert (n2 >= 0);
        if (n != this.offsetGapStart()) {
            this.moveOffsetGap(n, this.findElementIndex(n));
        }
        this.updateOffsetGapLength(-n2);
        this.updateOffsetGapStart(n2);
    }

    public void defaultRemoveUpdate(int n, int n2) {
        assert (n2 >= 0);
        int n3 = this.findElementIndex(n);
        if (n != this.offsetGapStart()) {
            this.moveOffsetGap(n, n3);
        }
        int n4 = this.size();
        int n5 = n + this.offsetGapLength + n2;
        while (n3 < n4) {
            Object e;
            if (this.isElementFlyweight(e = this.get(n3++))) continue;
            if (this.elementRawOffset(e) >= n5) break;
            this.setElementRawOffset(e, n5);
        }
        this.updateOffsetGapLength(n2);
    }

    protected final void moveOffsetGap(int n, int n2) {
        if (n < this.offsetGapStart) {
            int n3 = this.size();
            for (int i = n2; i < n3; ++i) {
                Object e = this.get(i);
                if (this.isElementFlyweight(e)) continue;
                int n4 = this.elementRawOffset(e);
                if (n4 < this.offsetGapStart) {
                    this.setElementRawOffset(e, n4 + this.offsetGapLength);
                    continue;
                }
                break;
            }
        } else {
            for (int i = n2 - 1; i >= 0; --i) {
                Object e = this.get(i);
                if (this.isElementFlyweight(e)) continue;
                int n5 = this.elementRawOffset(e);
                if (n5 >= this.offsetGapStart) {
                    this.setElementRawOffset(e, n5 - this.offsetGapLength);
                    continue;
                }
                break;
            }
        }
        this.offsetGapStart = n;
    }

    protected final int offsetGapStart() {
        return this.offsetGapStart;
    }

    protected final void updateOffsetGapStart(int n) {
        this.offsetGapStart += n;
    }

    protected final int offsetGapLength() {
        return this.offsetGapLength;
    }

    protected final void updateOffsetGapLength(int n) {
        this.offsetGapLength += n;
        assert (this.offsetGapLength >= 0);
    }

    protected final int findElementIndex(int n) {
        int n2 = 0;
        int n3 = this.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.elementOffset(n4);
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            while (n4 > 0) {
                if (this.elementOffset(--n4) >= n) continue;
                ++n4;
                break;
            }
            n2 = n4;
            break;
        }
        return n2;
    }

    protected void updateElementOffsetAdd(E e) {
        if (!this.isElementFlyweight(e)) {
            int n = this.elementRawOffset(e);
            this.setElementRawOffset(e, this.offset2Raw(n));
        }
    }

    protected void updateElementOffsetRemove(E e) {
        if (!this.isElementFlyweight(e)) {
            int n = this.raw2RelOffset(this.elementRawOffset(e));
            this.setElementRawOffset(e, n += this.startOffset());
        }
    }

    private int raw2RelOffset(int n) {
        return n < this.offsetGapStart ? n : n - this.offsetGapLength;
    }

    protected final int offset2Raw(int n) {
        if ((n -= this.startOffset()) >= this.offsetGapStart) {
            n += this.offsetGapLength;
        }
        return n;
    }

    protected void consistencyCheck(boolean bl) {
        int n;
        super.consistencyCheck();
        if (this.offsetGapLength < 0) {
            this.consistencyError("offsetGapLength < 0");
        }
        int n2 = Integer.MIN_VALUE;
        int n3 = n = Integer.MIN_VALUE;
        int n4 = this.size();
        for (int i = 0; i < n4; ++i) {
            int n5;
            Object e = this.get(i);
            if (!this.isElementFlyweight(e)) {
                n5 = this.elementRawOffset(e);
                int n6 = this.raw2RelOffset(n5);
                if (n5 < n2) {
                    this.consistencyError("Invalid rawOffset=" + n5 + " >= lastRawOffset=" + n2 + " at index=" + i);
                }
                if (n6 < n) {
                    this.consistencyError("Invalid offset=" + n6 + " >= lastOffset=" + n + " at index=" + i);
                }
                if (bl) {
                    int n7 = this.elementLength(e);
                    if (i == 0) {
                        n3 = n6;
                    }
                    if (n6 != n3) {
                        this.consistencyError("Offset=" + n6 + " differs from lastEndOffset=" + n3 + " at index=" + i);
                    }
                    n3 += n7;
                }
                n2 = n5;
                n = n6;
                continue;
            }
            if (!bl) continue;
            if (i == 0) {
                n3 = 0;
            }
            n5 = this.elementLength(e);
            n3 += n5;
        }
    }

    @Override
    protected String dumpInternals() {
        return super.dumpInternals() + ", offGap(s=" + this.offsetGapStart + ", l=" + this.offsetGapLength + ")";
    }
}

