/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.util.Observable;

public class Variable
extends Observable {
    protected String name;
    private Object value;
    private boolean isConstant = false;
    private boolean validValue = false;

    protected Variable(String name) {
        this.name = name;
        this.value = null;
        this.validValue = false;
    }

    protected Variable(String name, Object value) {
        this.name = name;
        this.value = value;
        this.validValue = value != null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public void setIsConstant(boolean b) {
        this.isConstant = b;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean hasValidValue() {
        return this.validValue;
    }

    public void setValidValue(boolean val) {
        if (this.isConstant()) {
            return;
        }
        this.validValue = val;
    }

    public boolean setValue(Object object) {
        if (!this.setValueRaw(object)) {
            return false;
        }
        this.setChanged();
        this.notifyObservers(object);
        return true;
    }

    protected boolean setValueRaw(Object object) {
        if (this.isConstant) {
            return false;
        }
        this.validValue = true;
        this.value = object;
        return true;
    }

    public String toString() {
        if (!this.validValue || this.value == null) {
            return this.name + ": null";
        }
        if (this.isConstant) {
            return this.name + ": " + this.value.toString() + " (Constant)";
        }
        return this.name + ": " + this.value.toString();
    }
}

