/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gm.settings;

import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelSettingsDialog;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.gm.GMChannelRoute;
import org.herac.tuxguitar.gm.GMChannelRouter;
import org.herac.tuxguitar.gm.GMChannelRouterConfigurator;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelParameter;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMChannelSettingsDialog
implements TGChannelSettingsDialog {
    public static final String CHANNELS_DATA = "channels";
    private TGContext context;
    private TGSong song;
    private TGChannel channel;
    private GMChannelRouter router;
    private UIWindow dialog;
    private UIDropDownSelect<Integer> gmChannel1Combo;
    private UIDropDownSelect<Integer> gmChannel2Combo;

    public GMChannelSettingsDialog(TGContext context, TGChannel channel, TGSong song) {
        this.context = context;
        this.song = song;
        this.channel = channel;
        this.router = new GMChannelRouter();
    }

    public void open(UIWindow parent) {
        this.configureRouter();
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(parent, false, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty((String)"gm.settings.dialog.title"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)this.dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty((String)"gm.settings.dialog.tip"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel gmChannel1Label = uiFactory.createLabel((UIContainer)group);
        gmChannel1Label.setText(TuxGuitar.getProperty((String)"gm.settings.channel.label-1") + ":");
        groupLayout.set((UIControl)gmChannel1Label, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.gmChannel1Combo = uiFactory.createDropDownSelect((UIContainer)group);
        this.gmChannel1Combo.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                GMChannelSettingsDialog.this.updateChannel();
            }
        });
        groupLayout.set(this.gmChannel1Combo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel gmChannel2Label = uiFactory.createLabel((UIContainer)group);
        gmChannel2Label.setText(TuxGuitar.getProperty((String)"gm.settings.channel.label-2") + ":");
        groupLayout.set((UIControl)gmChannel2Label, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.gmChannel2Combo = uiFactory.createDropDownSelect((UIContainer)group);
        this.gmChannel2Combo.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                GMChannelSettingsDialog.this.updateChannel();
            }
        });
        groupLayout.set(this.gmChannel2Combo, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.updateChannelCombos();
        TGDialogUtil.openDialog((UIWindow)this.dialog, (int)5);
    }

    public void close() {
        if (this.isOpen()) {
            this.dialog.dispose();
        }
    }

    public boolean isOpen() {
        return this.dialog != null && !this.dialog.isDisposed();
    }

    private void configureRouter() {
        GMChannelRouterConfigurator gmChannelRouterConfigurator = new GMChannelRouterConfigurator(this.router);
        gmChannelRouterConfigurator.configureRouter(this.song.getChannels());
    }

    private void updateChannelCombos() {
        GMChannelRoute route = this.router.getRoute(this.channel.getChannelId());
        List channels = this.router.getFreeChannels(route);
        this.reloadChannelCombo(this.gmChannel1Combo, channels, route.getChannel1(), "gm.settings.channel.value-1");
        this.reloadChannelCombo(this.gmChannel2Combo, channels, route.getChannel2(), "gm.settings.channel.value-2");
        boolean playerRunning = TuxGuitar.getInstance().getPlayer().isRunning();
        this.gmChannel1Combo.setEnabled(!playerRunning && !this.channel.isPercussionChannel() && this.gmChannel1Combo.getItemCount() > 0);
        this.gmChannel2Combo.setEnabled(!playerRunning && !this.channel.isPercussionChannel() && this.gmChannel2Combo.getItemCount() > 0);
    }

    private void reloadChannelCombo(UIDropDownSelect<Integer> combo, List<Integer> channels, int selected, String valueKey) {
        if (!(combo.getData(CHANNELS_DATA) instanceof List) || this.isDifferentList(channels, (List)combo.getData(CHANNELS_DATA))) {
            combo.removeItems();
            combo.setData(CHANNELS_DATA, channels);
            for (Integer channel : channels) {
                combo.addItem(new UISelectItem(TuxGuitar.getProperty((String)valueKey, (String[])new String[]{channel.toString()}), (Object)channel));
            }
        }
        combo.setSelectedValue((Object)selected);
    }

    public void updateChannel() {
        Integer channel1Selection = (Integer)this.gmChannel1Combo.getSelectedValue();
        Integer channel2Selection = (Integer)this.gmChannel2Combo.getSelectedValue();
        int channel1 = channel1Selection != null ? channel1Selection : -1;
        int channel2 = channel2Selection != null ? channel2Selection : -1;
        this.setChannelParameter(this.channel, "gm-channel-1", Integer.toString(channel1));
        this.setChannelParameter(this.channel, "gm-channel-2", Integer.toString(channel2));
        this.configureRouter();
    }

    private void setChannelParameter(TGChannel tgChannel, String key, String value) {
        TGChannelParameter tgChannelParameter = this.findOrCreateChannelParameter(tgChannel, key);
        tgChannelParameter.setValue(value);
    }

    private TGChannelParameter findChannelParameter(TGChannel tgChannel, String key) {
        Iterator it = tgChannel.getParameters();
        while (it.hasNext()) {
            TGChannelParameter parameter = (TGChannelParameter)it.next();
            if (!parameter.getKey().equals(key)) continue;
            return parameter;
        }
        return null;
    }

    private TGChannelParameter findOrCreateChannelParameter(TGChannel tgChannel, String key) {
        TGChannelParameter tgChannelParameter = this.findChannelParameter(tgChannel, key);
        if (tgChannelParameter == null) {
            tgChannelParameter = TuxGuitar.getInstance().getSongManager().getFactory().newChannelParameter();
            tgChannelParameter.setKey(key);
            tgChannel.addParameter(tgChannelParameter);
        }
        return tgChannelParameter;
    }

    private boolean isDifferentList(List<?> list1, List<?> list2) {
        if (list1.size() != list2.size()) {
            return true;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return true;
        }
        return false;
    }
}

