/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SongAdjuster {
    private TGFactory factory;
    private TGSong song;
    private long minDurationTime;

    public SongAdjuster(TGFactory factory, TGSong song) {
        this.factory = factory;
        this.song = song;
        this.minDurationTime = 40L;
    }

    public TGSong adjustSong() {
        Iterator it = this.song.getTracks();
        while (it.hasNext()) {
            TGTrack track = (TGTrack)it.next();
            this.adjustTrack(track);
        }
        return this.song;
    }

    private void adjustTrack(TGTrack track) {
        Iterator it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure measure = (TGMeasure)it.next();
            this.process(measure);
        }
    }

    public void process(TGMeasure measure) {
        this.orderBeats(measure);
        this.joinBeats(measure);
        this.adjustStrings(measure);
    }

    public void joinBeats(TGMeasure measure) {
        TGBeat previous = null;
        boolean finish = true;
        long measureStart = measure.getStart();
        long measureEnd = measureStart + measure.getLength();
        for (int i = 0; i < measure.countBeats(); ++i) {
            TGBeat beat = measure.getBeat(i);
            long beatStart = beat.getStart();
            long beatLength = beat.getVoice(0).getDuration().getTime();
            if (previous != null) {
                long previousStart = previous.getStart();
                long previousLength = previous.getVoice(0).getDuration().getTime();
                if (beatStart >= previousStart && previousStart + this.minDurationTime > beatStart) {
                    for (int n = 0; n < beat.getVoice(0).countNotes(); ++n) {
                        TGNote note = beat.getVoice(0).getNote(n);
                        previous.getVoice(0).addNote(note);
                    }
                    if (!previous.isChordBeat() && beat.isChordBeat()) {
                        previous.setChord(beat.getChord());
                    }
                    if (!previous.isTextBeat() && beat.isTextBeat()) {
                        previous.setText(beat.getText());
                    }
                    if (beatLength > previousLength && beatStart + beatLength <= measureEnd) {
                        previous.getVoice(0).getDuration().copyFrom(beat.getVoice(0).getDuration());
                    }
                    measure.removeBeat(beat);
                    finish = false;
                    break;
                }
                if (previousStart < beatStart && previousStart + previousLength > beatStart) {
                    if (beat.getVoice(0).isRestVoice()) {
                        measure.removeBeat(beat);
                        finish = false;
                        break;
                    }
                    TGDuration duration = TGDuration.fromTime((TGFactory)this.factory, (long)(beatStart - previousStart));
                    previous.getVoice(0).getDuration().copyFrom(duration);
                }
            }
            if (beatStart + beatLength > measureEnd) {
                if (beat.getVoice(0).isRestVoice()) {
                    measure.removeBeat(beat);
                    finish = false;
                    break;
                }
                TGDuration duration = TGDuration.fromTime((TGFactory)this.factory, (long)(measureEnd - beatStart));
                beat.getVoice(0).getDuration().copyFrom(duration);
            }
            previous = beat;
        }
        if (!finish) {
            this.joinBeats(measure);
        }
    }

    public void orderBeats(TGMeasure measure) {
        for (int i = 0; i < measure.countBeats(); ++i) {
            TGBeat minBeat = null;
            for (int j = i; j < measure.countBeats(); ++j) {
                TGBeat beat = measure.getBeat(j);
                if (minBeat != null && beat.getStart() >= minBeat.getStart()) continue;
                minBeat = beat;
            }
            measure.moveBeat(i, minBeat);
        }
    }

    private void adjustStrings(TGMeasure measure) {
        for (int i = 0; i < measure.countBeats(); ++i) {
            TGBeat beat = measure.getBeat(i);
            this.adjustStrings(beat);
        }
    }

    private void adjustStrings(TGBeat beat) {
        TGTrack track = beat.getMeasure().getTrack();
        ArrayList<TGString> freeStrings = new ArrayList<TGString>(track.getStrings());
        ArrayList<TGNote> notesToRemove = new ArrayList<TGNote>();
        for (TGNote note : beat.getVoice(0).getNotes()) {
            int string = this.getStringForValue(freeStrings, note.getValue());
            for (int j = 0; j < freeStrings.size(); ++j) {
                TGString tempString = (TGString)freeStrings.get(j);
                if (tempString.getNumber() != string) continue;
                note.setValue(note.getValue() - tempString.getValue());
                note.setString(tempString.getNumber());
                freeStrings.remove(j);
                break;
            }
            if (note.getString() >= 1) continue;
            notesToRemove.add(note);
        }
        while (notesToRemove.size() > 0) {
            beat.getVoice(0).removeNote((TGNote)notesToRemove.get(0));
            notesToRemove.remove(0);
        }
    }

    private int getStringForValue(List<TGString> strings, int value) {
        int minFret = -1;
        int stringForValue = 0;
        for (int i = 0; i < strings.size(); ++i) {
            TGString string = strings.get(i);
            int fret = value - string.getValue();
            if (minFret >= 0 && (fret < 0 || fret >= minFret)) continue;
            stringForValue = string.getNumber();
            minFret = fret;
        }
        return stringForValue;
    }
}

