/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.utils;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.herac.tuxguitar.community.TGCommunitySingleton;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.configuration.TGConfigManager;

public class TGCommunityWeb {
    public static String getHomeUrl(TGContext context) {
        return TGCommunitySingleton.getInstance(context).getConfig().getStringValue("community.url");
    }

    public static void open(TGContext context, String suffix) {
        try {
            String homeUrl = TGCommunityWeb.getHomeUrl(context);
            TGCommunityWeb.open(context, new URL(homeUrl + "/" + suffix));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static boolean open(TGContext context, URL url) {
        if (TGCommunityWeb.openDesktopBrowser(url)) {
            return true;
        }
        return TGCommunityWeb.openCommandLineBrowser(context, url);
    }

    private static boolean openDesktopBrowser(URL url) {
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            if (desktopClass != null) {
                Object desktopObject;
                Method desktop_getDesktop = desktopClass.getDeclaredMethod("getDesktop", new Class[0]);
                Method desktop_browse = desktopClass.getDeclaredMethod("browse", URI.class);
                if (desktop_getDesktop != null && desktop_browse != null && (desktopObject = desktop_getDesktop.invoke(null, new Object[0])) != null) {
                    desktop_browse.invoke(desktopObject, new URI(url.toExternalForm()));
                }
            }
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private static boolean openCommandLineBrowser(TGContext context, URL url) {
        TGConfigManager config = TGCommunitySingleton.getInstance(context).getConfig();
        String[] browserCmds = config.getStringValue("community.browser", "").split(";");
        for (int i = 0; i < browserCmds.length; ++i) {
            try {
                String pattern;
                int indexOfPattern;
                String browserCmd = browserCmds[i];
                if (browserCmd == null || browserCmd.length() <= 0 || (indexOfPattern = browserCmd.indexOf(pattern = "%s")) < 0) continue;
                String commandLine = new String();
                commandLine = commandLine + browserCmd.substring(0, indexOfPattern);
                commandLine = commandLine + url.toExternalForm();
                if (browserCmd.length() > indexOfPattern + pattern.length()) {
                    commandLine = commandLine + browserCmd.substring(indexOfPattern + pattern.length(), browserCmd.length());
                }
                Runtime.getRuntime().exec(commandLine);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }
}

