/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.qt.toolbar;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.herac.tuxguitar.ui.UIComponent;
import org.herac.tuxguitar.ui.layout.UILayoutAttributes;
import org.herac.tuxguitar.ui.qt.event.QTEventHandler;
import org.herac.tuxguitar.ui.qt.toolbar.QTToolActionItem;
import org.herac.tuxguitar.ui.qt.toolbar.QTToolActionMenuItem;
import org.herac.tuxguitar.ui.qt.toolbar.QTToolCheckableItem;
import org.herac.tuxguitar.ui.qt.toolbar.QTToolCustomItem;
import org.herac.tuxguitar.ui.qt.toolbar.QTToolMenuItem;
import org.herac.tuxguitar.ui.qt.toolbar.QTToolSeparatorItem;
import org.herac.tuxguitar.ui.qt.widget.QTAbstractContainer;
import org.herac.tuxguitar.ui.qt.widget.QTContainer;
import org.herac.tuxguitar.ui.qt.widget.QTWidget;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.toolbar.UIToolActionItem;
import org.herac.tuxguitar.ui.toolbar.UIToolActionMenuItem;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.toolbar.UIToolCheckableItem;
import org.herac.tuxguitar.ui.toolbar.UIToolCustomItem;
import org.herac.tuxguitar.ui.toolbar.UIToolMenuItem;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.qtjambi.qt.core.QEvent;
import org.qtjambi.qt.core.QRect;
import org.qtjambi.qt.core.Qt;
import org.qtjambi.qt.widgets.QAction;
import org.qtjambi.qt.widgets.QToolBar;
import org.qtjambi.qt.widgets.QWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTToolBar
extends QTAbstractContainer<QToolBar>
implements QTContainer,
UIToolBar {
    public static final int ITEM_MARGIN = 1;
    public static final String MANAGED = "managed";
    private Map<UIControl, UILayoutAttributes> controlAttributes = new HashMap<UIControl, UILayoutAttributes>();

    public QTToolBar(QTContainer container, Qt.Orientation orientation) {
        super(new QToolBar(container.getContainerControl()), container);
        ((QToolBar)this.getControl()).setOrientation(orientation);
        ((QToolBar)this.getControl()).setMovable(false);
        ((QToolBar)this.getControl()).setFloatable(false);
        this.getEventFilter().connect(QEvent.Type.LayoutRequest, new QTEventHandler(){

            public void handle(QEvent event) {
                QTToolBar.this.layout();
            }
        });
    }

    @Override
    public QWidget getContainerControl() {
        return (QWidget)this.getControl();
    }

    public UIComponent createSeparator() {
        return new QTToolSeparatorItem(this);
    }

    public UIToolActionItem createActionItem() {
        return new QTToolActionItem(this);
    }

    public UIToolCheckableItem createCheckItem() {
        return new QTToolCheckableItem(this);
    }

    public UIToolMenuItem createMenuItem() {
        return new QTToolMenuItem(this);
    }

    public UIToolActionMenuItem createActionMenuItem() {
        return new QTToolActionMenuItem(this);
    }

    public UIToolCustomItem createCustomItem() {
        return new QTToolCustomItem(this);
    }

    public boolean hasWidget(QWidget widget) {
        for (QAction action : ((QToolBar)this.getControl()).actions()) {
            QWidget widgetForAction = ((QToolBar)this.getControl()).widgetForAction(action);
            if (widgetForAction == null || !widgetForAction.equals((Object)widget)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addChild(QTWidget<? extends QWidget> uiControl) {
        super.addChild(uiControl);
        if (!this.hasWidget((QWidget)uiControl.getControl())) {
            ((QToolBar)this.getControl()).addWidget((QWidget)uiControl.getControl());
        }
    }

    public UILayoutAttributes getControlAttributes(UIControl control) {
        if (this.controlAttributes.containsKey(control)) {
            return this.controlAttributes.get(control);
        }
        this.controlAttributes.put(control, new UILayoutAttributes());
        return this.getControlAttributes(control);
    }

    public <T> void set(UIControl control, String key, T value) {
        this.getControlAttributes(control).set(key, value);
    }

    public <T> T get(UIControl control, String key) {
        return (T)this.getControlAttributes(control).get(key);
    }

    public <T> T get(UIControl control, String key, T defaultValue) {
        T value = this.get(control, key);
        return value != null ? value : defaultValue;
    }

    public void layout() {
        this.layout(this.getBounds());
    }

    public void layout(UIRectangle bounds) {
        this.computePackedSize();
        this.setBounds(bounds);
    }

    @Override
    public void computePackedSize() {
        super.computePackedSize();
        for (UIControl uiControl : this.getChildren()) {
            uiControl.computePackedSize();
        }
    }

    @Override
    public void setBounds(UIRectangle bounds) {
        super.setBounds(bounds);
        List<UIControl> children = this.getChildren();
        int itemsToFill = 0;
        float availableWidth = this.findSize(((QToolBar)this.getControl()).contentsRect()) - 1 * (children.size() - 1);
        float itemsWidth = 0.0f;
        float itemsHeight = 0.0f;
        for (UIControl control : this.getChildren()) {
            UISize packedSize = control.getPackedSize();
            itemsWidth += this.findSize(packedSize);
            itemsHeight = Math.max(itemsHeight, this.findHeight(packedSize));
            if (!Boolean.TRUE.equals(this.get(control, MANAGED)) || !Boolean.TRUE.equals(this.get(control, "fill"))) continue;
            ++itemsToFill;
        }
        float position = 0.0f;
        float widthToFill = itemsToFill > 0 && availableWidth > itemsWidth ? (availableWidth - itemsWidth) / (float)itemsToFill : 0.0f;
        for (UIControl control : this.getChildren()) {
            UIRectangle controlBounds = control.getBounds();
            if (Boolean.TRUE.equals(this.get(control, MANAGED))) {
                float controlWidth = this.findSize(control.getPackedSize());
                if (Boolean.TRUE.equals(this.get(control, "fill"))) {
                    controlWidth += widthToFill;
                }
                controlBounds.getSize().setWidth(this.isHorizontal() ? (float)Math.round(controlWidth) : itemsHeight);
                controlBounds.getSize().setHeight(this.isHorizontal() ? itemsHeight : (float)Math.round(controlWidth));
                control.setBounds(controlBounds);
            }
            controlBounds.getPosition().setX(this.isHorizontal() ? position : controlBounds.getPosition().getX());
            controlBounds.getPosition().setY(this.isHorizontal() ? controlBounds.getPosition().getY() : position);
            control.setBounds(controlBounds);
            position += this.findSize(controlBounds.getSize()) + 1.0f;
        }
    }

    public boolean isHorizontal() {
        return Qt.Orientation.Horizontal.equals((Object)((QToolBar)this.getControl()).orientation());
    }

    private int findSize(QRect r) {
        return this.isHorizontal() ? r.width() : r.height();
    }

    private float findSize(UISize r) {
        return this.isHorizontal() ? r.getWidth() : r.getHeight();
    }

    private float findHeight(UISize r) {
        return this.isHorizontal() ? r.getHeight() : r.getWidth();
    }
}

