/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.qt.widget;

import org.herac.tuxguitar.ui.event.UICloseListener;
import org.herac.tuxguitar.ui.event.UIResizeEvent;
import org.herac.tuxguitar.ui.event.UIResizeListener;
import org.herac.tuxguitar.ui.menu.UIMenuBar;
import org.herac.tuxguitar.ui.qt.event.QTCloseListenerManager;
import org.herac.tuxguitar.ui.qt.menu.QTMenuBar;
import org.herac.tuxguitar.ui.qt.resource.QTImage;
import org.herac.tuxguitar.ui.qt.widget.QTContainer;
import org.herac.tuxguitar.ui.qt.widget.QTLayoutContainer;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.qtjambi.qt.core.QEvent;
import org.qtjambi.qt.core.QMargins;
import org.qtjambi.qt.widgets.QMenuBar;
import org.qtjambi.qt.widgets.QWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QTAbstractWindow<T extends QWidget>
extends QTLayoutContainer<T>
implements UIWindow {
    private UIImage image;
    private UIMenuBar menuBar;
    private QTWindowCloseListener closeListener = new QTWindowCloseListener(this);
    private QTWindowResizeListener resizeListener = new QTWindowResizeListener(this);

    public QTAbstractWindow(T widget, QTContainer parent) {
        super(widget, parent, false);
        this.addResizeListener(this.resizeListener);
        this.connectCloseListener();
    }

    public String getText() {
        return ((QWidget)this.getControl()).windowTitle();
    }

    public void setText(String text) {
        ((QWidget)this.getControl()).setWindowTitle(text);
    }

    public UIImage getImage() {
        return this.image;
    }

    public void setImage(UIImage image) {
        this.image = image;
        ((QWidget)this.getControl()).setWindowIcon(this.image != null ? ((QTImage)this.image).createIcon() : null);
    }

    public UIMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBar(UIMenuBar menuBar) {
        this.menuBar = menuBar;
        if (this.isVisible()) {
            this.layout();
        }
    }

    public void open() {
        ((QWidget)this.getControl()).show();
    }

    public void close() {
        ((QWidget)this.getControl()).close();
    }

    @Override
    public void computeMargins() {
        super.computeMargins();
        if (this.menuBar != null) {
            QMargins margins = this.getContainerChildMargins();
            margins.setTop(margins.top() + ((QMenuBar)((QTMenuBar)this.menuBar).getControl()).sizeHint().height());
            this.setContainerChildMargins(margins);
        }
    }

    @Override
    public void setBounds(UIRectangle bounds) {
        this.resizeListener.setBounds(bounds);
        super.setBounds(bounds);
    }

    public void minimize() {
        ((QWidget)this.getControl()).showMinimized();
    }

    public void maximize() {
        ((QWidget)this.getControl()).showMaximized();
    }

    public boolean isMaximized() {
        return ((QWidget)this.getControl()).isMaximized();
    }

    public void moveToTop() {
        ((QWidget)this.getControl()).raise();
        ((QWidget)this.getControl()).activateWindow();
    }

    public void connectCloseListener() {
        this.getEventFilter().connect(QEvent.Type.Close, this.closeListener);
    }

    public void addCloseListener(UICloseListener listener) {
        this.closeListener.addListener(listener);
    }

    public void removeCloseListener(UICloseListener listener) {
        this.closeListener.removeListener(listener);
    }

    @Override
    public void dispose() {
        if (this.menuBar != null && !this.menuBar.isDisposed()) {
            this.menuBar.dispose();
        }
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QTWindowCloseListener
    extends QTCloseListenerManager {
        public QTWindowCloseListener(QTAbstractWindow<?> window) {
            super(window);
        }

        @Override
        public void handle(QEvent event) {
            if (!this.getControl().isDisposed()) {
                if (!this.isEmpty()) {
                    super.handle(event);
                } else {
                    this.getControl().dispose();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QTWindowResizeListener
    implements UIResizeListener {
        private UIRectangle bounds;
        private QTAbstractWindow<?> window;

        public QTWindowResizeListener(QTAbstractWindow<?> window) {
            this.window = window;
        }

        public void onResize(UIResizeEvent event) {
            if (!this.window.isDisposed()) {
                UIRectangle bounds = this.window.getBounds();
                int frameY = ((QWidget)this.window.getControl()).frameGeometry().y();
                if (frameY < 0) {
                    bounds.getPosition().setY(bounds.getPosition().getY() - (float)frameY);
                    this.bounds = null;
                }
                if (this.bounds == null || !this.bounds.equals((Object)bounds)) {
                    this.bounds = bounds;
                    this.window.layout(bounds);
                }
            }
        }

        public void setBounds(UIRectangle bounds) {
            this.bounds = bounds;
        }
    }
}

