/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.track;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableRemoveTrack
extends TGUndoableTrackBase {
    private int doAction;
    private TGTrack undoableTrack;

    private TGUndoableRemoveTrack(TGContext context) {
        super(context);
    }

    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.removeTrack(actionContext, this.getSong(), this.undoableTrack.clone(this.getSongManager().getFactory(), this.getSong()));
        this.doAction = 1;
    }

    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.addTrack(actionContext, this.getSong(), this.undoableTrack.clone(this.getSongManager().getFactory(), this.getSong()));
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableRemoveTrack startUndo(TGContext context, TGTrack track) {
        TGUndoableRemoveTrack undoable = new TGUndoableRemoveTrack(context);
        undoable.doAction = 1;
        undoable.undoableTrack = track.clone(new TGFactory(), TGUndoableRemoveTrack.getSong(context));
        return undoable;
    }

    public TGUndoableRemoveTrack endUndo() {
        return this;
    }
}

