/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gpx;

import java.io.InputStream;
import java.math.BigDecimal;
import javax.xml.parsers.DocumentBuilderFactory;
import org.herac.tuxguitar.io.gpx.score.GPXAutomation;
import org.herac.tuxguitar.io.gpx.score.GPXBar;
import org.herac.tuxguitar.io.gpx.score.GPXBeat;
import org.herac.tuxguitar.io.gpx.score.GPXDocument;
import org.herac.tuxguitar.io.gpx.score.GPXMasterBar;
import org.herac.tuxguitar.io.gpx.score.GPXNote;
import org.herac.tuxguitar.io.gpx.score.GPXRhythm;
import org.herac.tuxguitar.io.gpx.score.GPXTrack;
import org.herac.tuxguitar.io.gpx.score.GPXVoice;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GPXDocumentReader {
    private Document xmlDocument;
    private GPXDocument gpxDocument;

    public GPXDocumentReader(InputStream stream) {
        this.xmlDocument = this.getDocument(stream);
        this.gpxDocument = new GPXDocument();
    }

    private Document getDocument(InputStream stream) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public GPXDocument read() {
        if (this.xmlDocument != null) {
            this.readScore();
            this.readAutomations();
            this.readTracks();
            this.readMasterBars();
            this.readBars();
            this.readVoices();
            this.readBeats();
            this.readNotes();
            this.readRhythms();
        }
        return this.gpxDocument;
    }

    public void readScore() {
        Node scoreNode;
        if (this.xmlDocument != null && (scoreNode = this.getChildNode(this.xmlDocument.getFirstChild(), "Score")) != null) {
            this.gpxDocument.getScore().setTitle(this.getChildNodeContent(scoreNode, "Title"));
            this.gpxDocument.getScore().setSubTitle(this.getChildNodeContent(scoreNode, "SubTitle"));
            this.gpxDocument.getScore().setArtist(this.getChildNodeContent(scoreNode, "Artist"));
            this.gpxDocument.getScore().setAlbum(this.getChildNodeContent(scoreNode, "Album"));
            this.gpxDocument.getScore().setWords(this.getChildNodeContent(scoreNode, "Words"));
            this.gpxDocument.getScore().setMusic(this.getChildNodeContent(scoreNode, "Music"));
            this.gpxDocument.getScore().setWordsAndMusic(this.getChildNodeContent(scoreNode, "WordsAndMusic"));
            this.gpxDocument.getScore().setCopyright(this.getChildNodeContent(scoreNode, "Copyright"));
            this.gpxDocument.getScore().setTabber(this.getChildNodeContent(scoreNode, "Tabber"));
            this.gpxDocument.getScore().setInstructions(this.getChildNodeContent(scoreNode, "Instructions"));
            this.gpxDocument.getScore().setNotices(this.getChildNodeContent(scoreNode, "Notices"));
        }
    }

    public void readAutomations() {
        Node masterTrackNode;
        if (this.xmlDocument != null && (masterTrackNode = this.getChildNode(this.xmlDocument.getFirstChild(), "MasterTrack")) != null) {
            NodeList automationNodes = this.getChildNodeList(masterTrackNode, "Automations");
            for (int i = 0; i < automationNodes.getLength(); ++i) {
                Node automationNode = automationNodes.item(i);
                if (!automationNode.getNodeName().equals("Automation")) continue;
                GPXAutomation automation = new GPXAutomation();
                automation.setType(this.getChildNodeContent(automationNode, "Type"));
                automation.setBarId(this.getChildNodeIntegerContent(automationNode, "Bar"));
                automation.setValue(this.getChildNodeIntegerContentArray(automationNode, "Value"));
                automation.setLinear(this.getChildNodeBooleanContent(automationNode, "Linear"));
                automation.setPosition(this.getChildNodeIntegerContent(automationNode, "Position"));
                automation.setVisible(this.getChildNodeBooleanContent(automationNode, "Visible"));
                this.gpxDocument.getAutomations().add(automation);
            }
        }
    }

    public void readTracks() {
        if (this.xmlDocument != null) {
            NodeList trackNodes = this.getChildNodeList(this.xmlDocument.getFirstChild(), "Tracks");
            for (int i = 0; i < trackNodes.getLength(); ++i) {
                NodeList propertyNodes;
                Node trackNode = trackNodes.item(i);
                if (!trackNode.getNodeName().equals("Track")) continue;
                GPXTrack track = new GPXTrack();
                track.setId(this.getAttributeIntegerValue(trackNode, "id"));
                track.setName(this.getChildNodeContent(trackNode, "Name"));
                track.setColor(this.getChildNodeIntegerContentArray(trackNode, "Color"));
                Node gmNode = this.getChildNode(trackNode, "GeneralMidi");
                if (gmNode != null) {
                    track.setGmProgram(this.getChildNodeIntegerContent(gmNode, "Program"));
                    track.setGmChannel1(this.getChildNodeIntegerContent(gmNode, "PrimaryChannel"));
                    track.setGmChannel2(this.getChildNodeIntegerContent(gmNode, "SecondaryChannel"));
                }
                if ((propertyNodes = this.getChildNodeList(trackNode, "Properties")) != null) {
                    for (int p = 0; p < propertyNodes.getLength(); ++p) {
                        Node propertyNode = propertyNodes.item(p);
                        if (!propertyNode.getNodeName().equals("Property") || !this.getAttributeValue(propertyNode, "name").equals("Tuning")) continue;
                        track.setTunningPitches(this.getChildNodeIntegerContentArray(propertyNode, "Pitches"));
                    }
                }
                this.gpxDocument.getTracks().add(track);
            }
        }
    }

    public void readMasterBars() {
        if (this.xmlDocument != null) {
            NodeList masterBarNodes = this.getChildNodeList(this.xmlDocument.getFirstChild(), "MasterBars");
            for (int i = 0; i < masterBarNodes.getLength(); ++i) {
                Node keyNode;
                Node masterBarNode = masterBarNodes.item(i);
                if (!masterBarNode.getNodeName().equals("MasterBar")) continue;
                GPXMasterBar masterBar = new GPXMasterBar();
                masterBar.setBarIds(this.getChildNodeIntegerContentArray(masterBarNode, "Bars"));
                masterBar.setTime(this.getChildNodeIntegerContentArray(masterBarNode, "Time", "/"));
                masterBar.setTripletFeel(this.getChildNodeContent(masterBarNode, "TripletFeel"));
                Node repeatNode = this.getChildNode(masterBarNode, "Repeat");
                if (repeatNode != null) {
                    masterBar.setRepeatStart(this.getAttributeBooleanValue(repeatNode, "start"));
                    if (this.getAttributeBooleanValue(repeatNode, "end")) {
                        masterBar.setRepeatCount(this.getAttributeIntegerValue(repeatNode, "count"));
                    }
                }
                if ((keyNode = this.getChildNode(masterBarNode, "Key")) != null) {
                    masterBar.setAccidentalCount(this.getChildNodeIntegerContent(keyNode, "AccidentalCount"));
                    masterBar.setMode(this.getChildNodeContent(keyNode, "Mode"));
                }
                this.gpxDocument.getMasterBars().add(masterBar);
            }
        }
    }

    public void readBars() {
        if (this.xmlDocument != null) {
            NodeList barNodes = this.getChildNodeList(this.xmlDocument.getFirstChild(), "Bars");
            for (int i = 0; i < barNodes.getLength(); ++i) {
                Node barNode = barNodes.item(i);
                if (!barNode.getNodeName().equals("Bar")) continue;
                GPXBar bar = new GPXBar();
                bar.setId(this.getAttributeIntegerValue(barNode, "id"));
                bar.setVoiceIds(this.getChildNodeIntegerContentArray(barNode, "Voices"));
                bar.setClef(this.getChildNodeContent(barNode, "Clef"));
                bar.setSimileMark(this.getChildNodeContent(barNode, "SimileMark"));
                this.gpxDocument.getBars().add(bar);
            }
        }
    }

    public void readVoices() {
        if (this.xmlDocument != null) {
            NodeList voiceNodes = this.getChildNodeList(this.xmlDocument.getFirstChild(), "Voices");
            for (int i = 0; i < voiceNodes.getLength(); ++i) {
                Node voiceNode = voiceNodes.item(i);
                if (!voiceNode.getNodeName().equals("Voice")) continue;
                GPXVoice voice = new GPXVoice();
                voice.setId(this.getAttributeIntegerValue(voiceNode, "id"));
                voice.setBeatIds(this.getChildNodeIntegerContentArray(voiceNode, "Beats"));
                this.gpxDocument.getVoices().add(voice);
            }
        }
    }

    public void readBeats() {
        if (this.xmlDocument != null) {
            NodeList beatNodes = this.getChildNodeList(this.xmlDocument.getFirstChild(), "Beats");
            for (int i = 0; i < beatNodes.getLength(); ++i) {
                Node beatNode = beatNodes.item(i);
                if (!beatNode.getNodeName().equals("Beat")) continue;
                GPXBeat beat = new GPXBeat();
                beat.setId(this.getAttributeIntegerValue(beatNode, "id"));
                beat.setDynamic(this.getChildNodeContent(beatNode, "Dynamic"));
                beat.setRhythmId(this.getAttributeIntegerValue(this.getChildNode(beatNode, "Rhythm"), "ref"));
                beat.setTremolo(this.getChildNodeIntegerContentArray(beatNode, "Tremolo", "/"));
                beat.setNoteIds(this.getChildNodeIntegerContentArray(beatNode, "Notes"));
                NodeList propertyNodes = this.getChildNodeList(beatNode, "Properties");
                if (propertyNodes != null) {
                    for (int p = 0; p < propertyNodes.getLength(); ++p) {
                        Node propertyNode = propertyNodes.item(p);
                        if (!propertyNode.getNodeName().equals("Property")) continue;
                        String propertyName = this.getAttributeValue(propertyNode, "name");
                        if (propertyName.equals("WhammyBar")) {
                            beat.setWhammyBarEnabled(this.getChildNode(propertyNode, "Enable") != null);
                        }
                        if (propertyName.equals("WhammyBarOriginValue")) {
                            beat.setWhammyBarOriginValue(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                        }
                        if (propertyName.equals("WhammyBarMiddleValue")) {
                            beat.setWhammyBarMiddleValue(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                        }
                        if (propertyName.equals("WhammyBarDestinationValue")) {
                            beat.setWhammyBarDestinationValue(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                        }
                        if (propertyName.equals("WhammyBarOriginOffset")) {
                            beat.setWhammyBarOriginOffset(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                        }
                        if (propertyName.equals("WhammyBarMiddleOffset1")) {
                            beat.setWhammyBarMiddleOffset1(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                        }
                        if (propertyName.equals("WhammyBarMiddleOffset2")) {
                            beat.setWhammyBarMiddleOffset2(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                        }
                        if (!propertyName.equals("WhammyBarDestinationOffset")) continue;
                        beat.setWhammyBarDestinationOffset(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                    }
                }
                this.gpxDocument.getBeats().add(beat);
            }
        }
    }

    public void readNotes() {
        if (this.xmlDocument != null) {
            NodeList noteNodes = this.getChildNodeList(this.xmlDocument.getFirstChild(), "Notes");
            for (int i = 0; i < noteNodes.getLength(); ++i) {
                Node noteNode = noteNodes.item(i);
                if (!noteNode.getNodeName().equals("Note")) continue;
                GPXNote note = new GPXNote();
                note.setId(this.getAttributeIntegerValue(noteNode, "id"));
                Node tieNode = this.getChildNode(noteNode, "Tie");
                note.setTieDestination(tieNode != null ? this.getAttributeValue(tieNode, "destination").equals("true") : false);
                String ghostNodeContent = this.getChildNodeContent(noteNode, "AntiAccent");
                if (ghostNodeContent != null) {
                    note.setGhost(ghostNodeContent.equals("Normal"));
                }
                note.setAccent(this.getChildNodeIntegerContent(noteNode, "Accent"));
                note.setTrill(this.getChildNodeIntegerContent(noteNode, "Trill"));
                note.setVibrato(this.getChildNode(noteNode, "Vibrato") != null);
                NodeList propertyNodes = this.getChildNodeList(noteNode, "Properties");
                if (propertyNodes != null) {
                    for (int p = 0; p < propertyNodes.getLength(); ++p) {
                        Node propertyNode = propertyNodes.item(p);
                        if (!propertyNode.getNodeName().equals("Property")) continue;
                        String propertyName = this.getAttributeValue(propertyNode, "name");
                        if (propertyName.equals("String")) {
                            note.setString(this.getChildNodeIntegerContent(propertyNode, "String"));
                        }
                        if (propertyName.equals("Fret")) {
                            note.setFret(this.getChildNodeIntegerContent(propertyNode, "Fret"));
                        }
                        if (propertyName.equals("Midi")) {
                            note.setMidiNumber(this.getChildNodeIntegerContent(propertyNode, "Number"));
                        }
                        if (propertyName.equals("Tone")) {
                            note.setTone(this.getChildNodeIntegerContent(propertyNode, "Step"));
                        }
                        if (propertyName.equals("Octave")) {
                            note.setOctave(this.getChildNodeIntegerContent(propertyNode, "Number"));
                        }
                        if (propertyName.equals("Element")) {
                            note.setElement(this.getChildNodeIntegerContent(propertyNode, "Element"));
                        }
                        if (propertyName.equals("Variation")) {
                            note.setVariation(this.getChildNodeIntegerContent(propertyNode, "Variation"));
                        }
                        if (propertyName.equals("Muted")) {
                            note.setMutedEnabled(this.getChildNode(propertyNode, "Enable") != null);
                        }
                        if (propertyName.equals("PalmMuted")) {
                            note.setPalmMutedEnabled(this.getChildNode(propertyNode, "Enable") != null);
                        }
                        if (propertyName.equals("Slide")) {
                            note.setSlide(true);
                            note.setSlideFlags(this.getChildNodeIntegerContent(propertyNode, "Flags"));
                        }
                        if (propertyName.equals("Tapped")) {
                            note.setTapped(this.getChildNode(propertyNode, "Enable") != null);
                        }
                        if (propertyName.equals("Bended")) {
                            note.setBendEnabled(this.getChildNode(propertyNode, "Enable") != null);
                        }
                        if (propertyName.equals("BendOriginValue")) {
                            note.setBendOriginValue(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                        }
                        if (propertyName.equals("BendMiddleValue")) {
                            note.setBendMiddleValue(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                        }
                        if (propertyName.equals("BendDestinationValue")) {
                            note.setBendDestinationValue(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                        }
                        if (propertyName.equals("BendOriginOffset")) {
                            note.setBendOriginOffset(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                        }
                        if (propertyName.equals("BendMiddleOffset1")) {
                            note.setBendMiddleOffset1(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                        }
                        if (propertyName.equals("BendMiddleOffset2")) {
                            note.setBendMiddleOffset2(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                        }
                        if (propertyName.equals("BendDestinationOffset")) {
                            note.setBendDestinationOffset(new Integer(this.getChildNodeIntegerContent(propertyNode, "Float")));
                        }
                        if (propertyName.equals("HopoOrigin")) {
                            note.setHammer(true);
                        }
                        if (propertyName.equals("HopoDestination")) {
                            // empty if block
                        }
                        if (propertyName.equals("HarmonicFret")) {
                            note.setHarmonicFret(this.getChildNodeIntegerContent(propertyNode, "HFret"));
                        }
                        if (!propertyName.equals("HarmonicType")) continue;
                        note.setHarmonicType(this.getChildNodeContent(propertyNode, "HType"));
                    }
                }
                this.gpxDocument.getNotes().add(note);
            }
        }
    }

    public void readRhythms() {
        if (this.xmlDocument != null) {
            NodeList rhythmNodes = this.getChildNodeList(this.xmlDocument.getFirstChild(), "Rhythms");
            for (int i = 0; i < rhythmNodes.getLength(); ++i) {
                Node rhythmNode = rhythmNodes.item(i);
                if (!rhythmNode.getNodeName().equals("Rhythm")) continue;
                Node primaryTupletNode = this.getChildNode(rhythmNode, "PrimaryTuplet");
                Node augmentationDotNode = this.getChildNode(rhythmNode, "AugmentationDot");
                GPXRhythm rhythm = new GPXRhythm();
                rhythm.setId(this.getAttributeIntegerValue(rhythmNode, "id"));
                rhythm.setNoteValue(this.getChildNodeContent(rhythmNode, "NoteValue"));
                rhythm.setPrimaryTupletDen(primaryTupletNode != null ? this.getAttributeIntegerValue(primaryTupletNode, "den") : 1);
                rhythm.setPrimaryTupletNum(primaryTupletNode != null ? this.getAttributeIntegerValue(primaryTupletNode, "num") : 1);
                rhythm.setAugmentationDotCount(augmentationDotNode != null ? this.getAttributeIntegerValue(augmentationDotNode, "count") : 0);
                this.gpxDocument.getRhythms().add(rhythm);
            }
        }
    }

    private String getAttributeValue(Node node, String attribute) {
        if (node != null) {
            return node.getAttributes().getNamedItem(attribute).getNodeValue();
        }
        return null;
    }

    private int getAttributeIntegerValue(Node node, String attribute) {
        try {
            return new BigDecimal(this.getAttributeValue(node, attribute)).intValue();
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private boolean getAttributeBooleanValue(Node node, String attribute) {
        String value = this.getAttributeValue(node, attribute);
        if (value != null) {
            return value.equals("true");
        }
        return false;
    }

    private Node getChildNode(Node node, String name) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals(name)) continue;
            return childNode;
        }
        return null;
    }

    private NodeList getChildNodeList(Node node, String name) {
        Node childNode = this.getChildNode(node, name);
        if (childNode != null) {
            return childNode.getChildNodes();
        }
        return null;
    }

    private String getChildNodeContent(Node node, String name) {
        Node childNode = this.getChildNode(node, name);
        if (childNode != null) {
            return childNode.getTextContent();
        }
        return null;
    }

    private boolean getChildNodeBooleanContent(Node node, String name) {
        String value = this.getChildNodeContent(node, name);
        if (value != null) {
            return value.equals("true");
        }
        return false;
    }

    private int getChildNodeIntegerContent(Node node, String name) {
        try {
            return new BigDecimal(this.getChildNodeContent(node, name)).intValue();
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private int[] getChildNodeIntegerContentArray(Node node, String name, String regex) {
        String rawContents = this.getChildNodeContent(node, name);
        if (rawContents != null) {
            String[] contents = rawContents.trim().split(regex);
            int[] intContents = new int[contents.length];
            for (int i = 0; i < intContents.length; ++i) {
                try {
                    intContents[i] = new BigDecimal(contents[i].trim()).intValue();
                    continue;
                }
                catch (Throwable throwable) {
                    intContents[i] = 0;
                }
            }
            return intContents;
        }
        return null;
    }

    private int[] getChildNodeIntegerContentArray(Node node, String name) {
        return this.getChildNodeIntegerContentArray(node, name, " ");
    }
}

