/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action;

import org.herac.tuxguitar.action.TGActionContextFactory;
import org.herac.tuxguitar.action.TGActionInterceptor;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.app.action.TGActionContextFactoryImpl;
import org.herac.tuxguitar.app.action.TGActionIdList;
import org.herac.tuxguitar.app.action.installer.TGActionInstaller;
import org.herac.tuxguitar.app.action.listener.cache.TGUpdateListener;
import org.herac.tuxguitar.app.action.listener.error.TGActionErrorHandler;
import org.herac.tuxguitar.app.action.listener.gui.TGActionProcessingListener;
import org.herac.tuxguitar.app.action.listener.lock.TGLockableActionListener;
import org.herac.tuxguitar.app.action.listener.save.TGDocumentModifierListener;
import org.herac.tuxguitar.app.action.listener.save.TGUnsavedDocumentInterceptor;
import org.herac.tuxguitar.app.action.listener.thread.TGSyncThreadInterceptor;
import org.herac.tuxguitar.app.action.listener.transport.TGDisableOnPlayInterceptor;
import org.herac.tuxguitar.app.action.listener.transport.TGStopTransportInterceptor;
import org.herac.tuxguitar.app.action.listener.undoable.TGUndoableActionListener;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGActionAdapterManager {
    private TGContext context;
    private TGActionContextFactory actionContextFactory;
    private TGDisableOnPlayInterceptor disableOnPlayInterceptor;
    private TGStopTransportInterceptor stopTransportInterceptor;
    private TGActionIdList keyBindingActionIds;
    private TGSyncThreadInterceptor syncThreadInterceptor;
    private TGUnsavedDocumentInterceptor unsavedDocumentInterceptor;
    private TGLockableActionListener lockableActionListener;
    private TGUndoableActionListener undoableActionListener;
    private TGUpdateListener updatableActionListener;
    private TGDocumentModifierListener documentModifierListener;
    private TGActionErrorHandler errorHandler;

    private TGActionAdapterManager(TGContext context) {
        this.context = context;
        this.actionContextFactory = new TGActionContextFactoryImpl();
        this.keyBindingActionIds = new TGActionIdList();
        this.disableOnPlayInterceptor = new TGDisableOnPlayInterceptor(context);
        this.stopTransportInterceptor = new TGStopTransportInterceptor(context);
        this.syncThreadInterceptor = new TGSyncThreadInterceptor(context);
        this.unsavedDocumentInterceptor = new TGUnsavedDocumentInterceptor(context);
        this.lockableActionListener = new TGLockableActionListener(context);
        this.undoableActionListener = new TGUndoableActionListener(context);
        this.updatableActionListener = new TGUpdateListener(this);
        this.documentModifierListener = new TGDocumentModifierListener(context);
        this.errorHandler = new TGActionErrorHandler(context);
    }

    public void initialize() {
        this.initializeHandlers();
        this.initializeDefaultActions();
    }

    private void initializeHandlers() {
        TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.context);
        tgActionManager.setActionContextFactory(this.actionContextFactory);
        tgActionManager.addInterceptor((TGActionInterceptor)this.stopTransportInterceptor);
        tgActionManager.addInterceptor((TGActionInterceptor)this.disableOnPlayInterceptor);
        tgActionManager.addInterceptor((TGActionInterceptor)this.syncThreadInterceptor);
        tgActionManager.addInterceptor((TGActionInterceptor)this.unsavedDocumentInterceptor);
        tgActionManager.addInterceptor((TGActionInterceptor)this.lockableActionListener);
        TGActionProcessingListener processingListener = new TGActionProcessingListener(this.context);
        tgActionManager.addPreExecutionListener((TGEventListener)processingListener);
        tgActionManager.addPreExecutionListener((TGEventListener)this.errorHandler);
        tgActionManager.addPreExecutionListener((TGEventListener)this.lockableActionListener);
        tgActionManager.addPreExecutionListener((TGEventListener)this.undoableActionListener);
        tgActionManager.addPreExecutionListener((TGEventListener)this.updatableActionListener);
        tgActionManager.addPostExecutionListener((TGEventListener)this.updatableActionListener);
        tgActionManager.addPostExecutionListener((TGEventListener)this.undoableActionListener);
        tgActionManager.addPostExecutionListener((TGEventListener)this.unsavedDocumentInterceptor);
        tgActionManager.addPostExecutionListener((TGEventListener)this.documentModifierListener);
        tgActionManager.addPostExecutionListener((TGEventListener)this.lockableActionListener);
        tgActionManager.addPostExecutionListener((TGEventListener)this.errorHandler);
        tgActionManager.addPostExecutionListener((TGEventListener)processingListener);
        tgActionManager.addErrorListener((TGEventListener)processingListener);
        tgActionManager.addErrorListener((TGEventListener)this.lockableActionListener);
        tgActionManager.addErrorListener((TGEventListener)this.errorHandler);
    }

    private void initializeDefaultActions() {
        TGActionInstaller tgActionInstaller = new TGActionInstaller(this);
        tgActionInstaller.installDefaultActions();
    }

    public TGActionIdList getKeyBindingActionIds() {
        return this.keyBindingActionIds;
    }

    public TGDisableOnPlayInterceptor getDisableOnPlayInterceptor() {
        return this.disableOnPlayInterceptor;
    }

    public TGStopTransportInterceptor getStopTransportInterceptor() {
        return this.stopTransportInterceptor;
    }

    public TGSyncThreadInterceptor getSyncThreadInterceptor() {
        return this.syncThreadInterceptor;
    }

    public TGUnsavedDocumentInterceptor getUnsavedDocumentInterceptor() {
        return this.unsavedDocumentInterceptor;
    }

    public TGDocumentModifierListener getDocumentModifierListener() {
        return this.documentModifierListener;
    }

    public TGLockableActionListener getLockableActionListener() {
        return this.lockableActionListener;
    }

    public TGUndoableActionListener getUndoableActionListener() {
        return this.undoableActionListener;
    }

    public TGUpdateListener getUpdatableActionListener() {
        return this.updatableActionListener;
    }

    public TGContext getContext() {
        return this.context;
    }

    public static TGActionAdapterManager getInstance(TGContext context) {
        return (TGActionAdapterManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGActionAdapterManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGActionAdapterManager>(){

            public TGActionAdapterManager createInstance(TGContext context) {
                return new TGActionAdapterManager(context);
            }
        });
    }
}

