/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.impl.file;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.app.action.impl.view.TGOpenViewAction;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.app.graphics.TGResourceFactoryImpl;
import org.herac.tuxguitar.app.printer.PrintController;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrintPreviewDialog;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrintPreviewDialogController;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrintSettingsDialog;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrintSettingsDialogController;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrintSettingsHandler;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.graphics.TGDimension;
import org.herac.tuxguitar.graphics.TGMargins;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.control.TGController;
import org.herac.tuxguitar.graphics.control.TGFactoryImpl;
import org.herac.tuxguitar.graphics.control.print.TGPrintDocument;
import org.herac.tuxguitar.graphics.control.print.TGPrintLayout;
import org.herac.tuxguitar.graphics.control.print.TGPrintSettings;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.resource.UIResourceFactory;
import org.herac.tuxguitar.util.TGContext;

public class TGPrintPreviewAction
extends TGActionBase {
    public static final String NAME = "action.file.print-preview";
    public static final String ATTRIBUTE_STYLES = TGPrintSettings.class.getName();
    private static final int PAGE_WIDTH = 850;
    private static final int PAGE_HEIGHT = 1050;
    private static final int MARGIN_TOP = 20;
    private static final int MARGIN_BOTTOM = 40;
    private static final int MARGIN_LEFT = 50;
    private static final int MARGIN_RIGHT = 20;

    public TGPrintPreviewAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        TGPrintSettings styles = (TGPrintSettings)context.getAttribute(ATTRIBUTE_STYLES);
        if (styles == null) {
            this.configureStyles(context);
            return;
        }
        TGSongManager manager = new TGSongManager((TGFactory)new TGFactoryImpl());
        TGSong sourceSong = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        TGSong targetSong = sourceSong.clone(manager.getFactory());
        TGDimension pageSize = new TGDimension(850.0f, 1050.0f);
        TGMargins pageMargins = new TGMargins(20.0f, 50.0f, 20.0f, 40.0f);
        TGResourceFactoryImpl factory = new TGResourceFactoryImpl((UIResourceFactory)this.getUIFactory());
        PrintController controller = new PrintController(this.getContext(), targetSong, manager, factory);
        TGPrintLayout printLayout = new TGPrintLayout((TGController)controller, styles);
        printLayout.loadStyles(1.0f);
        printLayout.updateSong();
        printLayout.makeDocument((TGPrintDocument)new PrintDocumentImpl(pageSize, pageMargins));
        printLayout.getResourceBuffer().disposeAllResources();
    }

    public void configureStyles(final TGActionContext context) {
        context.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGPrintSettingsDialogController());
        context.setAttribute(TGPrintSettingsDialog.ATTRIBUTE_HANDLER, (Object)new TGPrintSettingsHandler(){

            public void updatePrintSettings(TGPrintSettings styles) {
                context.setAttribute(ATTRIBUTE_STYLES, (Object)styles);
                TGPrintPreviewAction.this.executeActionInNewThread(TGPrintPreviewAction.NAME, context);
            }
        });
        this.executeActionInNewThread("action.gui.open-view", context);
    }

    public void executeActionInNewThread(final String id, final TGActionContext context) {
        new Thread(new Runnable(){

            public void run() {
                TGActionManager.getInstance((TGContext)TGPrintPreviewAction.this.getContext()).execute(id, context);
            }
        }).start();
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.getContext()).getFactory();
    }

    private class PrintDocumentImpl
    implements TGPrintDocument {
        private TGPainterImpl painter;
        private TGDimension size;
        private TGMargins margins;
        private List<UIImage> pages;

        public PrintDocumentImpl(TGDimension size, TGMargins margins) {
            this.size = size;
            this.margins = margins;
            this.painter = new TGPainterImpl((UIResourceFactory)TGPrintPreviewAction.this.getUIFactory());
            this.pages = new ArrayList<UIImage>();
        }

        public TGPainter getPainter() {
            return this.painter;
        }

        public TGDimension getSize() {
            return this.size;
        }

        public TGMargins getMargins() {
            return this.margins;
        }

        public void pageStart() {
            UIFactory factory = TGPrintPreviewAction.this.getUIFactory();
            UIImage page = factory.createImage(this.size.getWidth(), this.size.getHeight());
            this.painter.setHandle(page.createPainter());
            this.pages.add(page);
        }

        public void pageFinish() {
            this.painter.dispose();
        }

        public void start() {
        }

        public void finish() {
            TGDimension size = this.size;
            final List<UIImage> pages = this.pages;
            TGActionProcessor tgActionProcessor = new TGActionProcessor(TGPrintPreviewAction.this.getContext(), "action.gui.open-view");
            tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGPrintPreviewDialogController());
            tgActionProcessor.setAttribute(TGPrintPreviewDialog.ATTRIBUTE_PAGES, pages);
            tgActionProcessor.setAttribute(TGPrintPreviewDialog.ATTRIBUTE_SIZE, (Object)size);
            tgActionProcessor.setAttribute(TGViewContext.ATTRIBUTE_DISPOSE_LISTENER, (Object)new UIDisposeListener(){

                public void onDispose(UIDisposeEvent event) {
                    for (UIImage uiImage : pages) {
                        uiImage.dispose();
                    }
                }
            });
            tgActionProcessor.process();
        }

        public boolean isTransparentBackground() {
            return false;
        }

        public boolean isPaintable(int page) {
            return true;
        }
    }
}

