/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.system.config;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.util.properties.TGProperties;
import org.herac.tuxguitar.util.properties.TGPropertiesManager;
import org.herac.tuxguitar.util.properties.TGPropertiesUtil;

public class TGConfigDefaults {
    public static final String RESOURCE = "config-defaults";
    public static final String MODULE = "tuxguitar";
    private static final String DEFAULT_FONT_NAME = "Default";

    public static TGProperties createDefaults() {
        TGPropertiesManager propertiesManager = TuxGuitar.getInstance().getPropertiesManager();
        TGProperties properties = propertiesManager.createProperties();
        TGConfigDefaults.loadProperties(properties);
        propertiesManager.readProperties(properties, RESOURCE, MODULE);
        return properties;
    }

    public static void loadProperties(TGProperties properties) {
        TGConfigDefaults.loadProperty(properties, "skin", "Lavender");
        TGConfigDefaults.loadProperty(properties, "window.title", "${appname} - ${filename}");
        TGConfigDefaults.loadProperty(properties, "show.splash", true);
        TGConfigDefaults.loadProperty(properties, "window.maximized", false);
        TGConfigDefaults.loadProperty(properties, "window.width", 960);
        TGConfigDefaults.loadProperty(properties, "window.height", 600);
        TGConfigDefaults.loadProperty(properties, "show.main-toolbar", true);
        TGConfigDefaults.loadProperty(properties, "show.edit-toolbar", true);
        TGConfigDefaults.loadProperty(properties, "show.instruments", false);
        TGConfigDefaults.loadProperty(properties, "show.transport", false);
        TGConfigDefaults.loadProperty(properties, "show.fretboard", false);
        TGConfigDefaults.loadProperty(properties, "show.piano", false);
        TGConfigDefaults.loadProperty(properties, "show.markers", false);
        TGConfigDefaults.loadProperty(properties, "layout.mode", 1);
        TGConfigDefaults.loadProperty(properties, "layout.style", 45);
        TGConfigDefaults.loadProperty(properties, "editor.mouse.mode", 1);
        TGConfigDefaults.loadProperty(properties, "editor.natural.key.mode", true);
        TGConfigDefaults.loadProperty(properties, "font.default", "Default,6,false,false");
        TGConfigDefaults.loadProperty(properties, "font.note", "Default,7,false,false");
        TGConfigDefaults.loadProperty(properties, "font.time-signature", "Default,13,true,false");
        TGConfigDefaults.loadProperty(properties, "font.lyric", "Default,7,false,false");
        TGConfigDefaults.loadProperty(properties, "font.text", "Default,8,false,false");
        TGConfigDefaults.loadProperty(properties, "font.chord", "Default,7,false,false");
        TGConfigDefaults.loadProperty(properties, "font.chord-fret", "Default,5,false,false");
        TGConfigDefaults.loadProperty(properties, "font.grace", "Default,6,false,false");
        TGConfigDefaults.loadProperty(properties, "font.marker", "Default,7,false,false");
        TGConfigDefaults.loadProperty(properties, "font.printer.default", "Default,6,false,false");
        TGConfigDefaults.loadProperty(properties, "font.printer.note", "Default,6,false,false");
        TGConfigDefaults.loadProperty(properties, "font.printer.time-signature", "Default,10,true,false");
        TGConfigDefaults.loadProperty(properties, "font.printer.lyric", "Default,7,false,false");
        TGConfigDefaults.loadProperty(properties, "font.printer.text", "Default,8,false,false");
        TGConfigDefaults.loadProperty(properties, "font.printer.chord", "Default,7,false,false");
        TGConfigDefaults.loadProperty(properties, "font.printer.grace", "Default,6,false,false");
        TGConfigDefaults.loadProperty(properties, "font.about.dialog.title", "Default,36,true,true");
        TGConfigDefaults.loadProperty(properties, "color.background", "255,255,255");
        TGConfigDefaults.loadProperty(properties, "color.line", "214,214,214");
        TGConfigDefaults.loadProperty(properties, "color.score.note", "64,64,64");
        TGConfigDefaults.loadProperty(properties, "color.tab.note", "64,64,64");
        TGConfigDefaults.loadProperty(properties, "color.play.note", "255,0,0");
        TGConfigDefaults.loadProperty(properties, "color.caret.1", "127,127,127");
        TGConfigDefaults.loadProperty(properties, "color.caret.2", "165,42,42");
        TGConfigDefaults.loadProperty(properties, "color.loop.s.marker", "42,165,42");
        TGConfigDefaults.loadProperty(properties, "color.loop.e.marker", "165,42,42");
        TGConfigDefaults.loadProperty(properties, "history.max-files", 10);
        TGConfigDefaults.loadProperty(properties, "language", "");
        TGConfigDefaults.loadProperty(properties, "fretboard.string-spacing", 20);
        TGConfigDefaults.loadProperty(properties, "fretboard.style", 2);
        TGConfigDefaults.loadProperty(properties, "fretboard.direction", 0);
        TGConfigDefaults.loadProperty(properties, "fretboard.font", "Default,8,true,false");
        TGConfigDefaults.loadProperty(properties, "fretboard.color.background", "0,0,0");
        TGConfigDefaults.loadProperty(properties, "fretboard.color.string", "227,217,217");
        TGConfigDefaults.loadProperty(properties, "fretboard.color.fret-point", "192,192,192");
        TGConfigDefaults.loadProperty(properties, "fretboard.color.note", "42,85,128");
        TGConfigDefaults.loadProperty(properties, "fretboard.color.scale", "128,32,32");
        TGConfigDefaults.loadProperty(properties, "piano.color.natural-key", "255,255,255");
        TGConfigDefaults.loadProperty(properties, "piano.color.not-natural-key", "0,0,0");
        TGConfigDefaults.loadProperty(properties, "piano.color.note", "42,85,128");
        TGConfigDefaults.loadProperty(properties, "piano.color.scale", "128,32,32");
        TGConfigDefaults.loadProperty(properties, "matrix.font", "Default,8,true,false");
        TGConfigDefaults.loadProperty(properties, "matrix.color.foreground", "190,190,190");
        TGConfigDefaults.loadProperty(properties, "matrix.color.border", "25,25,25");
        TGConfigDefaults.loadProperty(properties, "matrix.color.position", "190,190,190");
        TGConfigDefaults.loadProperty(properties, "matrix.color.note", "42,85,128");
        TGConfigDefaults.loadProperty(properties, "matrix.color.play-note", "128,32,32");
        TGConfigDefaults.loadProperty(properties, "matrix.color.line-1", "255,255,255");
        TGConfigDefaults.loadProperty(properties, "matrix.color.line-2", "230,230,250");
        TGConfigDefaults.loadProperty(properties, "matrix.color.line-3", "173,216,230");
        TGConfigDefaults.loadProperty(properties, "table.auto-size", true);
        TGConfigDefaults.loadProperty(properties, "browser.lines-visible", true);
        TGConfigDefaults.loadProperty(properties, "style.minBufferSeparator", 20);
        TGConfigDefaults.loadProperty(properties, "style.minTopSpacing", 30);
        TGConfigDefaults.loadProperty(properties, "style.minScoreTabSpacing", 20);
        TGConfigDefaults.loadProperty(properties, "style.stringSpacing", 10);
        TGConfigDefaults.loadProperty(properties, "style.scoreLineSpacing", 8);
        TGConfigDefaults.loadProperty(properties, "style.trackSpacing", 10);
        TGConfigDefaults.loadProperty(properties, "style.firstTrackSpacing", 20);
        TGConfigDefaults.loadProperty(properties, "style.firstMeasureSpacing", 20);
        TGConfigDefaults.loadProperty(properties, "style.firstNoteSpacing", 10);
        TGConfigDefaults.loadProperty(properties, "style.measureLeftSpacing", 15);
        TGConfigDefaults.loadProperty(properties, "style.measureRightSpacing", 15);
        TGConfigDefaults.loadProperty(properties, "style.clefSpacing", 30);
        TGConfigDefaults.loadProperty(properties, "style.keySignatureSpacing", 15);
        TGConfigDefaults.loadProperty(properties, "style.timeSignatureSpacing", 15);
        TGConfigDefaults.loadProperty(properties, "style.chordFretIndexSpacing", 8);
        TGConfigDefaults.loadProperty(properties, "style.chordStringSpacing", 5);
        TGConfigDefaults.loadProperty(properties, "style.chordFretSpacing", 6);
        TGConfigDefaults.loadProperty(properties, "style.chordNoteSize", 4);
        TGConfigDefaults.loadProperty(properties, "style.chordLineWidth", 0);
        TGConfigDefaults.loadProperty(properties, "style.repeatEndingSpacing", 20);
        TGConfigDefaults.loadProperty(properties, "style.effectSpacing", 8);
        TGConfigDefaults.loadProperty(properties, "style.divisionTypeSpacing", 10);
        TGConfigDefaults.loadProperty(properties, "style.textSpacing", 15);
        TGConfigDefaults.loadProperty(properties, "style.markerSpacing", 15);
        TGConfigDefaults.loadProperty(properties, "style.loopMarkerSpacing", 5);
        TGConfigDefaults.loadProperty(properties, "style.lineWidths", new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f});
        TGConfigDefaults.loadProperty(properties, "style.durationWidths", new float[]{30.0f, 25.0f, 21.0f, 20.0f, 19.0f, 18.0f});
    }

    private static void loadProperty(TGProperties properties, String key, String value) {
        properties.setValue(key, value);
    }

    private static void loadProperty(TGProperties properties, String key, int value) {
        properties.setValue(key, Integer.toString(value));
    }

    private static void loadProperty(TGProperties properties, String key, boolean value) {
        properties.setValue(key, Boolean.toString(value));
    }

    private static void loadProperty(TGProperties properties, String key, float[] value) {
        TGPropertiesUtil.setValue((TGProperties)properties, (String)key, (float[])value);
    }
}

