/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.tab;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.graphics.TGResourceFactoryImpl;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.component.tab.Caret;
import org.herac.tuxguitar.app.view.component.tab.TablatureStyles;
import org.herac.tuxguitar.app.view.component.tab.edit.EditorKit;
import org.herac.tuxguitar.app.view.util.TGSyncProcess;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.TGRectangle;
import org.herac.tuxguitar.graphics.TGResourceFactory;
import org.herac.tuxguitar.graphics.control.TGController;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGLayoutHorizontal;
import org.herac.tuxguitar.graphics.control.TGLayoutStyles;
import org.herac.tuxguitar.graphics.control.TGLayoutVertical;
import org.herac.tuxguitar.graphics.control.TGResourceBuffer;
import org.herac.tuxguitar.player.base.MidiPlayerMode;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.ui.resource.UIResourceFactory;
import org.herac.tuxguitar.util.TGContext;

public class Tablature
implements TGController {
    private TGContext context;
    private TGResourceFactory resourceFactory;
    private TGDocumentManager documentManager;
    private TGResourceBuffer resourceBuffer;
    private TGSyncProcess disposeUnregisteredResources;
    private Caret caret;
    private TGLayout viewLayout;
    private EditorKit editorKit;

    public Tablature(TGContext context, TGDocumentManager documentManager) {
        this.context = context;
        this.documentManager = documentManager;
        this.caret = new Caret(this);
        this.editorKit = new EditorKit(this);
        this.createSyncProcesses();
    }

    public void createSyncProcesses() {
        this.disposeUnregisteredResources = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                Tablature.this.getResourceBuffer().disposeUnregisteredResources();
            }
        });
    }

    public void updateTablature() {
        this.getViewLayout().updateSong();
        this.getCaret().update();
        this.disposeUnregisteredResources.process();
    }

    public void updateMeasure(int number) {
        this.getViewLayout().updateMeasureNumber(number);
        this.getCaret().update();
        this.disposeUnregisteredResources.process();
    }

    public void resetCaret() {
        this.caret.update(1, 960L, 1);
    }

    public void paintTablature(TGPainter painter, TGRectangle area, float fromX, float fromY) {
        this.fillBackground(painter, area);
        this.getViewLayout().paint(painter, area, fromX, fromY);
        this.getCaret().paintCaret(this.getViewLayout(), painter);
        this.getEditorKit().paintSelection(this.getViewLayout(), painter);
    }

    public void fillBackground(TGPainter painter, TGRectangle area) {
        painter.setBackground(this.getViewLayout().getResources().getBackgroundColor());
        painter.initPath(2);
        painter.addRectangle(0.0f, 0.0f, area.getWidth(), area.getHeight());
        painter.closePath();
    }

    public Caret getCaret() {
        return this.caret;
    }

    public EditorKit getEditorKit() {
        return this.editorKit;
    }

    public TGContext getContext() {
        return this.context;
    }

    public TGSongManager getSongManager() {
        return this.documentManager.getSongManager();
    }

    public TGSong getSong() {
        return this.documentManager.getSong();
    }

    public TGLayout getViewLayout() {
        return this.viewLayout;
    }

    public void setViewLayout(TGLayout viewLayout) {
        if (this.getViewLayout() != null) {
            this.getViewLayout().disposeLayout();
        }
        this.viewLayout = viewLayout;
        this.reloadStyles();
    }

    public void reloadStyles() {
        if (this.getViewLayout() != null) {
            this.getViewLayout().loadStyles(1.0f);
        }
        this.loadCaretStyles();
    }

    public void reloadViewLayout() {
        TGConfigManager config = TGConfigManager.getInstance(this.context);
        this.loadViewLayout(config.getIntegerValue("layout.style"), config.getIntegerValue("layout.mode"));
    }

    private void loadViewLayout(int style, int mode) {
        switch (mode) {
            case 1: {
                this.setViewLayout((TGLayout)new TGLayoutVertical((TGController)this, style));
                break;
            }
            case 2: {
                this.setViewLayout((TGLayout)new TGLayoutHorizontal((TGController)this, style));
                break;
            }
            default: {
                if (mode == 2) break;
                this.loadViewLayout(style, 2);
            }
        }
    }

    public void loadCaretStyles() {
        TGConfigManager config = TGConfigManager.getInstance(this.context);
        this.getCaret().setColor1(config.getColorModelConfigValue("color.caret.1"));
        this.getCaret().setColor2(config.getColorModelConfigValue("color.caret.2"));
    }

    public void dispose() {
        this.getCaret().dispose();
        this.getViewLayout().disposeLayout();
        this.getResourceBuffer().disposeAllResources();
    }

    public TGResourceFactory getResourceFactory() {
        if (this.resourceFactory == null) {
            this.resourceFactory = new TGResourceFactoryImpl((UIResourceFactory)TGApplication.getInstance(this.context).getFactory());
        }
        return this.resourceFactory;
    }

    public TGResourceBuffer getResourceBuffer() {
        if (this.resourceBuffer == null) {
            this.resourceBuffer = new TGResourceBuffer();
        }
        return this.resourceBuffer;
    }

    public int getTrackSelection() {
        if ((this.getViewLayout().getStyle() & 2) == 0) {
            return this.getCaret().getTrack().getNumber();
        }
        return -1;
    }

    public boolean isRunning(TGBeat beat) {
        return this.isRunning(beat.getMeasure()) && TuxGuitar.getInstance().getEditorCache().isPlaying(beat.getMeasure(), beat);
    }

    public boolean isRunning(TGMeasure measure) {
        return measure.getTrack().equals(this.getCaret().getTrack()) && TuxGuitar.getInstance().getEditorCache().isPlaying(measure);
    }

    public boolean isLoopSHeader(TGMeasureHeader measureHeader) {
        MidiPlayerMode pm = TuxGuitar.getInstance().getPlayer().getMode();
        return pm.isLoop() && pm.getLoopSHeader() == measureHeader.getNumber();
    }

    public boolean isLoopEHeader(TGMeasureHeader measureHeader) {
        MidiPlayerMode pm = TuxGuitar.getInstance().getPlayer().getMode();
        return pm.isLoop() && pm.getLoopEHeader() == measureHeader.getNumber();
    }

    public TGLayoutStyles getStyles() {
        return new TablatureStyles(TGConfigManager.getInstance(this.context));
    }
}

