/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.browser.main;

import java.util.Iterator;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.browser.TGBrowserCollection;
import org.herac.tuxguitar.app.tools.browser.TGBrowserManager;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserFactory;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserBar;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserDialog;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.toolbar.UIToolActionItem;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.toolbar.UIToolCustomItem;
import org.herac.tuxguitar.ui.toolbar.UIToolMenuItem;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UISelectItem;

public class TGBrowserToolBar
extends TGBrowserBar {
    private UIToolBar toolBar;
    private UIToolActionItem root;
    private UIToolActionItem back;
    private UIToolActionItem refresh;
    private UIToolMenuItem newBrowser;
    private UIToolCustomItem collectionsItem;
    private UIDropDownSelect<TGBrowserCollection> collections;
    private TGBrowserCollection currentCollection;

    public TGBrowserToolBar(TGBrowserDialog browser) {
        super(browser);
    }

    public void createToolBar(UIContainer parent) {
        this.toolBar = this.getBrowser().getUIFactory().createHorizontalToolBar(parent);
        this.newBrowser = this.toolBar.createMenuItem();
        this.newBrowser.setImage(TuxGuitar.getInstance().getIconManager().getBrowserNew());
        Iterator<TGBrowserFactory> bookTypes = TGBrowserManager.getInstance(this.getBrowser().getContext()).getFactories();
        while (bookTypes.hasNext()) {
            final TGBrowserFactory bookType = bookTypes.next();
            UIMenuActionItem item = this.newBrowser.getMenu().createActionItem();
            item.setText(bookType.getName());
            item.setData(TGBrowserFactory.class.getName(), (Object)bookType);
            item.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGBrowserToolBar.this.newCollection(bookType.getType());
                }
            });
        }
        this.toolBar.createSeparator();
        this.root = this.toolBar.createActionItem();
        this.root.setImage(TuxGuitar.getInstance().getIconManager().getBrowserRoot());
        this.root.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGBrowserToolBar.this.getBrowser().cdRoot();
            }
        });
        this.back = this.toolBar.createActionItem();
        this.back.setImage(TuxGuitar.getInstance().getIconManager().getBrowserBack());
        this.back.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGBrowserToolBar.this.getBrowser().cdUp();
            }
        });
        this.refresh = this.toolBar.createActionItem();
        this.refresh.setImage(TuxGuitar.getInstance().getIconManager().getBrowserRefresh());
        this.refresh.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGBrowserToolBar.this.getBrowser().listElements();
            }
        });
        this.toolBar.createSeparator();
        this.collectionsItem = this.toolBar.createCustomItem();
        this.collectionsItem.setLayoutAttribute("fill", (Object)true);
        this.collectionsItem.setLayoutAttribute("packed_width", (Object)Float.valueOf(0.0f));
        this.collections = this.getBrowser().getUIFactory().createDropDownSelect((UIContainer)this.collectionsItem);
        this.collections.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGBrowserToolBar.this.updateCollection();
            }
        });
    }

    public void updateItems() {
        this.newBrowser.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.collections.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.root.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.back.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.refresh.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
    }

    public void updateCollections(TGBrowserCollection selection) {
        this.currentCollection = selection;
        this.collections.setIgnoreEvents(true);
        this.collections.removeItems();
        this.collections.addItem(new UISelectItem(TuxGuitar.getProperty("browser.collection.select"), null));
        Iterator<TGBrowserCollection> it = TGBrowserManager.getInstance(this.getBrowser().getContext()).getCollections();
        while (it.hasNext()) {
            TGBrowserCollection collection = it.next();
            if (collection.getData() == null) continue;
            this.collections.addItem(new UISelectItem(collection.getData().getTitle(), (Object)collection));
        }
        this.collections.setSelectedValue((Object)this.currentCollection);
        this.collections.setIgnoreEvents(false);
    }

    public void reload() {
        if (!this.toolBar.isDisposed()) {
            UIContainer parent = (UIContainer)this.toolBar.getParent();
            this.dispose();
            this.createToolBar(parent);
            this.loadProperties();
            this.updateItems();
        }
    }

    public void loadProperties() {
        this.newBrowser.setToolTipText(TuxGuitar.getProperty("browser.collection.new"));
        this.root.setToolTipText(TuxGuitar.getProperty("browser.go-root"));
        this.back.setToolTipText(TuxGuitar.getProperty("browser.go-back"));
        this.refresh.setToolTipText(TuxGuitar.getProperty("browser.refresh"));
        this.updateCollections(this.getBrowser().getCollection());
    }

    public void updateCollection() {
        TGBrowserCollection collection = (TGBrowserCollection)this.collections.getSelectedValue();
        if (this.currentCollection != collection) {
            this.currentCollection = collection;
            if (this.currentCollection == null) {
                this.closeCollection();
            } else {
                this.openCollection(this.currentCollection);
            }
        }
    }

    private void dispose() {
        this.toolBar.dispose();
    }

    public UIToolBar getControl() {
        return this.toolBar;
    }
}

