/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.harmonic;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.action.effect.TGChangeHarmonicNoteAction;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIRadioButton;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class TGHarmonicDialog {
    private static final String TYPE_DATA = "type";
    public static final float WIDTH = 400.0f;
    protected UIDropDownSelect<Integer> harmonicType;
    protected UIDropDownSelect<Integer> harmonicDataCombo;
    protected UIRadioButton[] typeButtons;

    public void show(final TGViewContext context) {
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        final TGString string = (TGString)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING);
        final TGNote note = (TGNote)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE);
        if (measure != null && beat != null && note != null && string != null) {
            UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
            UIWindow uiParent = (UIWindow)context.getAttribute("parent2");
            UITableLayout dialogLayout = new UITableLayout();
            final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
            dialog.setLayout((UILayout)dialogLayout);
            dialog.setText(TuxGuitar.getProperty("effects.harmonic-editor"));
            UITableLayout groupLayout = new UITableLayout();
            UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
            group.setLayout((UILayout)groupLayout);
            group.setText(TuxGuitar.getProperty("effects.harmonic.type-of-harmonic"));
            dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), null, null, Float.valueOf(400.0f), null, null);
            this.typeButtons = new UIRadioButton[5];
            UISelectionListener listener = new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGHarmonicDialog.this.update(note, TGHarmonicDialog.this.getSelectedType());
                }
            };
            String label = "[N.H] " + TuxGuitar.getProperty("effects.harmonic.natural");
            this.initButton(uiFactory, (UILayoutContainer)group, listener, 0, 1, label);
            label = "[A.H] " + TuxGuitar.getProperty("effects.harmonic.artificial");
            this.initButton(uiFactory, (UILayoutContainer)group, listener, 1, 2, label);
            label = "[T.H] " + TuxGuitar.getProperty("effects.harmonic.tapped");
            this.initButton(uiFactory, (UILayoutContainer)group, listener, 2, 3, label);
            label = "[P.H] " + TuxGuitar.getProperty("effects.harmonic.pinch");
            this.initButton(uiFactory, (UILayoutContainer)group, listener, 3, 4, label);
            label = "[S.H] " + TuxGuitar.getProperty("effects.harmonic.semi");
            this.initButton(uiFactory, (UILayoutContainer)group, listener, 4, 5, label);
            this.harmonicDataCombo = uiFactory.createDropDownSelect((UIContainer)group);
            groupLayout.set(this.harmonicDataCombo, Integer.valueOf(6), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
            UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
            buttons.setLayout((UILayout)buttonsLayout);
            dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true));
            UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
            buttonOK.setDefaultButton();
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGHarmonicDialog.this.changeHarmonic(context.getContext(), measure, beat, string, TGHarmonicDialog.this.getHarmonic());
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonClean = uiFactory.createButton((UIContainer)buttons);
            buttonClean.setText(TuxGuitar.getProperty("clean"));
            buttonClean.setEnabled(note.getEffect().isHarmonic());
            buttonClean.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGHarmonicDialog.this.changeHarmonic(context.getContext(), measure, beat, string, null);
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonClean, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
            this.initDefaults(note);
            TGDialogUtil.openDialog(dialog, 5);
        }
    }

    private void initButton(UIFactory uiFactory, UILayoutContainer parent, UISelectionListener listener, int index, int type, String label) {
        this.typeButtons[index] = uiFactory.createRadioButton((UIContainer)parent);
        this.typeButtons[index].setText(label);
        this.typeButtons[index].setData(TYPE_DATA, (Object)type);
        this.typeButtons[index].addSelectionListener(listener);
        UITableLayout uiLayout = (UITableLayout)parent.getLayout();
        uiLayout.set((UIControl)this.typeButtons[index], Integer.valueOf(index + 1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
    }

    protected void initDefaults(TGNote note) {
        int type = 1;
        if (note.getEffect().isHarmonic()) {
            type = note.getEffect().getHarmonic().getType();
        } else {
            boolean naturalValid = false;
            for (int i = 0; i < TGEffectHarmonic.NATURAL_FREQUENCIES.length; ++i) {
                if (note.getValue() % 12 != TGEffectHarmonic.NATURAL_FREQUENCIES[i][0] % 12) continue;
                naturalValid = true;
                break;
            }
            if (!naturalValid) {
                this.typeButtons[0].setEnabled(false);
                type = 2;
            }
        }
        for (int i = 0; i < this.typeButtons.length; ++i) {
            int data = (Integer)this.typeButtons[i].getData(TYPE_DATA);
            this.typeButtons[i].setSelected(data == type);
        }
        this.update(note, type);
    }

    protected int getSelectedType() {
        for (int i = 0; i < this.typeButtons.length; ++i) {
            if (!this.typeButtons[i].isSelected()) continue;
            return (Integer)this.typeButtons[i].getData(TYPE_DATA);
        }
        return 0;
    }

    protected void update(TGNote note, int type) {
        TGEffectHarmonic h = note.getEffect().getHarmonic();
        this.harmonicDataCombo.removeItems();
        this.harmonicDataCombo.setEnabled(type != 1);
        if (type != 1) {
            String label = this.getTypeLabel(type);
            for (int i = 0; i < TGEffectHarmonic.NATURAL_FREQUENCIES.length; ++i) {
                this.harmonicDataCombo.addItem(new UISelectItem(label + "(" + Integer.toString(TGEffectHarmonic.NATURAL_FREQUENCIES[i][0]) + ")", (Object)i));
            }
            this.harmonicDataCombo.setSelectedValue((Object)(h != null && h.getType() == type ? h.getData() : 0));
        }
    }

    private String getTypeLabel(int type) {
        if (type == 1) {
            return "N.H";
        }
        if (type == 2) {
            return "A.H";
        }
        if (type == 3) {
            return "T.H";
        }
        if (type == 4) {
            return "P.H";
        }
        if (type == 5) {
            return "S.H";
        }
        return new String();
    }

    public TGEffectHarmonic getHarmonic() {
        int type = this.getSelectedType();
        if (type > 0) {
            Integer data = (Integer)this.harmonicDataCombo.getSelectedValue();
            TGEffectHarmonic effect = TuxGuitar.getInstance().getSongManager().getFactory().newEffectHarmonic();
            effect.setType(type);
            effect.setData(data != null ? data : 0);
            return effect;
        }
        return null;
    }

    public void changeHarmonic(TGContext context, TGMeasure measure, TGBeat beat, TGString string, TGEffectHarmonic effect) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.note.effect.change-harmonic");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
        tgActionProcessor.setAttribute(TGChangeHarmonicNoteAction.ATTRIBUTE_EFFECT, (Object)effect);
        tgActionProcessor.process();
    }
}

