/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.keybindings;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingAction;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingActionDefaults;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.keybindings.TGKeyBindingSelector;
import org.herac.tuxguitar.app.view.dialog.keybindings.TGKeyBindingSelectorHandler;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UIMouseDoubleClickListener;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIKeyConvination;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UITable;
import org.herac.tuxguitar.ui.widget.UITableItem;
import org.herac.tuxguitar.ui.widget.UIWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGKeyBindingEditor {
    private TGViewContext context;
    private UIWindow dialog;
    private UITable<KeyBindingAction> table;
    private List<KeyBindingAction> kbActions;

    public TGKeyBindingEditor(TGViewContext context) {
        this.context = context;
        this.kbActions = new ArrayList<KeyBindingAction>();
    }

    public void show() {
        UIFactory uiFactory = TGApplication.getInstance(this.context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)this.context.getAttribute("parent2");
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(uiParent, true, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty("key-bindings-editor"));
        this.table = uiFactory.createTable((UIContainer)this.dialog, true);
        this.table.setColumns(2);
        this.table.setColumnName(0, TuxGuitar.getProperty("key-bindings-editor-action-column"));
        this.table.setColumnName(1, TuxGuitar.getProperty("key-bindings-editor-shortcut-column"));
        this.table.addMouseDoubleClickListener(new UIMouseDoubleClickListener(){

            public void onMouseDoubleClick(UIMouseEvent event) {
                final KeyBindingAction kbAction = (KeyBindingAction)TGKeyBindingEditor.this.table.getSelectedValue();
                if (kbAction != null) {
                    TGKeyBindingSelector keyBindingSelector = new TGKeyBindingSelector(TGKeyBindingEditor.this, kbAction, new TGKeyBindingSelectorHandler(){

                        public void handleSelection(UIKeyConvination kb) {
                            TGKeyBindingEditor.this.removeKeyBindingAction(kb);
                            kbAction.setConvination(kb);
                            TGKeyBindingEditor.this.updateTableItems();
                        }
                    });
                    keyBindingSelector.select(TGKeyBindingEditor.this.dialog);
                }
            }
        });
        dialogLayout.set(this.table, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        dialogLayout.set(this.table, "maximum_packed_width", (Object)Float.valueOf(500.0f));
        dialogLayout.set(this.table, "packed_height", (Object)Float.valueOf(250.0f));
        this.loadCurrentKeyBindingActions();
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton defaults = uiFactory.createButton((UIContainer)buttons);
        defaults.setText(TuxGuitar.getProperty("defaults"));
        defaults.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGKeyBindingEditor.this.loadDefaultKeyBindingActions();
            }
        });
        buttonsLayout.set((UIControl)defaults, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton close = uiFactory.createButton((UIContainer)buttons);
        close.setText(TuxGuitar.getProperty("close"));
        close.setDefaultButton();
        close.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGKeyBindingEditor.this.dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)close, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)close, "margin_right", (Object)Float.valueOf(0.0f));
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGKeyBindingEditor.this.save();
            }
        });
        TGDialogUtil.openDialog(this.dialog, 5);
    }

    public void createKeyBindingActions(List<KeyBindingAction> keyBindingActions) {
        this.kbActions.clear();
        List<String> actionIds = TuxGuitar.getInstance().getActionAdapterManager().getKeyBindingActionIds().getActionIds();
        for (String actionId : actionIds) {
            this.kbActions.add(new KeyBindingAction(actionId, this.findKeyBinding(keyBindingActions, actionId)));
        }
    }

    public UIKeyConvination findKeyBinding(List<KeyBindingAction> keyBindingActions, String actionId) {
        for (KeyBindingAction keyBindingAction : keyBindingActions) {
            if (!keyBindingAction.getAction().equals(actionId)) continue;
            return (UIKeyConvination)keyBindingAction.getConvination().clone();
        }
        return null;
    }

    public void loadCurrentKeyBindingActions() {
        this.createKeyBindingActions(TuxGuitar.getInstance().getKeyBindingManager().getKeyBindingActions());
        this.updateTableItems();
    }

    public void loadDefaultKeyBindingActions() {
        this.createKeyBindingActions(KeyBindingActionDefaults.getDefaultKeyBindings(this.getContext().getContext()));
        this.updateTableItems();
    }

    public void updateTableItems() {
        KeyBindingAction selection = (KeyBindingAction)this.table.getSelectedValue();
        this.table.removeItems();
        for (KeyBindingAction kbAction : this.kbActions) {
            UITableItem item = new UITableItem((Object)kbAction);
            item.setText(0, TuxGuitar.getProperty(kbAction.getAction()));
            item.setText(1, kbAction.getConvination() != null ? kbAction.getConvination().toString() : "");
            this.table.addItem(item);
        }
        this.table.setSelectedValue((Object)selection);
    }

    public KeyBindingAction findKeyBindingAction(UIKeyConvination kb) {
        if (kb != null) {
            for (KeyBindingAction kbAction : this.kbActions) {
                if (!kb.equals((Object)kbAction.getConvination())) continue;
                return kbAction;
            }
        }
        return null;
    }

    public void removeKeyBindingAction(UIKeyConvination kb) {
        KeyBindingAction kbAction = this.findKeyBindingAction(kb);
        if (kbAction != null) {
            kbAction.setConvination(null);
        }
    }

    public boolean exists(UIKeyConvination kb) {
        KeyBindingAction kbAction = this.findKeyBindingAction(kb);
        return kbAction != null;
    }

    public void save() {
        ArrayList<KeyBindingAction> list = new ArrayList<KeyBindingAction>();
        for (KeyBindingAction kbAction : this.kbActions) {
            if (kbAction.getAction() == null || kbAction.getConvination() == null) continue;
            list.add(kbAction);
        }
        TuxGuitar.getInstance().getKeyBindingManager().reset(list);
        TuxGuitar.getInstance().getKeyBindingManager().saveKeyBindings();
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.system.reload-language");
        tgActionProcessor.setAttribute("force", (Object)true);
        tgActionProcessor.process();
    }

    public TGViewContext getContext() {
        return this.context;
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }
}

