/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.measure;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISpinner;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class TGMeasureCleanDialog {
    public void show(final TGViewContext context) {
        TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        TGMeasureHeader header = (TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent2");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("measure.clean"));
        UITableLayout rangeLayout = new UITableLayout();
        UILegendPanel range = uiFactory.createLegendPanel((UIContainer)dialog);
        range.setLayout((UILayout)rangeLayout);
        range.setText(TuxGuitar.getProperty("measure.clean"));
        dialogLayout.set((UIControl)range, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        int measureCount = song.countMeasureHeaders();
        UILabel fromLabel = uiFactory.createLabel((UIContainer)range);
        fromLabel.setText(TuxGuitar.getProperty("edit.from"));
        rangeLayout.set((UIControl)fromLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UISpinner fromSpinner = uiFactory.createSpinner((UIContainer)range);
        fromSpinner.setMinimum(1);
        fromSpinner.setMaximum(measureCount);
        fromSpinner.setValue(header.getNumber());
        rangeLayout.set((UIControl)fromSpinner, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        UILabel toLabel = uiFactory.createLabel((UIContainer)range);
        toLabel.setText(TuxGuitar.getProperty("edit.to"));
        rangeLayout.set((UIControl)toLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UISpinner toSpinner = uiFactory.createSpinner((UIContainer)range);
        toSpinner.setMinimum(1);
        toSpinner.setMaximum(measureCount);
        toSpinner.setValue(header.getNumber());
        rangeLayout.set((UIControl)toSpinner, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        boolean minSelection = true;
        final int maxSelection = track.countMeasures();
        fromSpinner.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                int fromSelection = fromSpinner.getValue();
                int toSelection = toSpinner.getValue();
                if (fromSelection < 1) {
                    fromSpinner.setValue(1);
                } else if (fromSelection > toSelection) {
                    fromSpinner.setValue(toSelection);
                }
            }
        });
        toSpinner.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                int fromSelection;
                int toSelection = toSpinner.getValue();
                if (toSelection < (fromSelection = fromSpinner.getValue())) {
                    toSpinner.setValue(fromSelection);
                } else if (toSelection > maxSelection) {
                    toSpinner.setValue(maxSelection);
                }
            }
        });
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMeasureCleanDialog.this.processAction(context.getContext(), track, fromSpinner.getValue(), toSpinner.getValue());
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public void processAction(TGContext context, TGTrack track, Integer measure1, Integer measure2) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.measure.clean-list");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
        tgActionProcessor.setAttribute("measureNumber1", (Object)measure1);
        tgActionProcessor.setAttribute("measureNumber2", (Object)measure2);
        tgActionProcessor.process();
    }
}

