/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.stroke;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIRadioButton;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class TGStrokeDialog {
    public static final int WIDTH = 400;
    public static final int HEIGHT = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_CLEAN = 2;
    public static final int STATUS_CANCEL = 3;
    private UIRadioButton duration4;
    private UIRadioButton duration8;
    private UIRadioButton duration16;
    private UIRadioButton duration32;
    private UIRadioButton duration64;

    public void show(final TGViewContext context) {
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        final Integer direction = (Integer)context.getAttribute("strokeDirection");
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent2");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("beat.stroke"));
        int duration = 16;
        if (beat.getStroke().getDirection() != 0) {
            duration = beat.getStroke().getValue();
        }
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty("duration"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.duration64 = uiFactory.createRadioButton((UIContainer)group);
        this.duration64.setImage(TuxGuitar.getInstance().getIconManager().getDuration(64));
        this.duration64.setSelected(duration == 64);
        groupLayout.set((UIControl)this.duration64, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.duration32 = uiFactory.createRadioButton((UIContainer)group);
        this.duration32.setImage(TuxGuitar.getInstance().getIconManager().getDuration(32));
        this.duration32.setSelected(duration == 32);
        groupLayout.set((UIControl)this.duration32, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.duration16 = uiFactory.createRadioButton((UIContainer)group);
        this.duration16.setImage(TuxGuitar.getInstance().getIconManager().getDuration(16));
        this.duration16.setSelected(duration == 16);
        groupLayout.set((UIControl)this.duration16, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.duration8 = uiFactory.createRadioButton((UIContainer)group);
        this.duration8.setImage(TuxGuitar.getInstance().getIconManager().getDuration(8));
        this.duration8.setSelected(duration == 8);
        groupLayout.set((UIControl)this.duration8, Integer.valueOf(1), Integer.valueOf(4), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.duration4 = uiFactory.createRadioButton((UIContainer)group);
        this.duration4.setImage(TuxGuitar.getInstance().getIconManager().getDuration(4));
        this.duration4.setSelected(duration == 4);
        groupLayout.set((UIControl)this.duration4, Integer.valueOf(1), Integer.valueOf(5), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGStrokeDialog.this.changeStroke(context.getContext(), measure, beat, direction, TGStrokeDialog.this.getSelection());
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonClean = uiFactory.createButton((UIContainer)buttons);
        buttonClean.setText(TuxGuitar.getProperty("clean"));
        buttonClean.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGStrokeDialog.this.changeStroke(context.getContext(), measure, beat, 0, 0);
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonClean, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public int getSelection() {
        if (this.duration4.isSelected()) {
            return 4;
        }
        if (this.duration8.isSelected()) {
            return 8;
        }
        if (this.duration16.isSelected()) {
            return 16;
        }
        if (this.duration32.isSelected()) {
            return 32;
        }
        if (this.duration64.isSelected()) {
            return 64;
        }
        return 0;
    }

    public void changeStroke(TGContext context, TGMeasure measure, TGBeat beat, int direction, int value) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.beat.general.change-stroke");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute("strokeDirection", (Object)direction);
        tgActionProcessor.setAttribute("strokeValue", (Object)value);
        tgActionProcessor.process();
    }
}

