/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.track;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.util.TGMusicKeyUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.app.view.util.TGProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.chooser.UIColorChooser;
import org.herac.tuxguitar.ui.chooser.UIColorChooserHandler;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIColorModel;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UISpinner;
import org.herac.tuxguitar.ui.widget.UITextField;
import org.herac.tuxguitar.ui.widget.UIWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGTrackPropertiesDialog
implements TGEventListener {
    private static final String[] NOTE_NAMES = TGMusicKeyUtils.getSharpKeyNames("tuning");
    private static final float MINIMUM_LEFT_CONTROLS_WIDTH = 180.0f;
    private static final float MINIMUM_BUTTON_WIDTH = 80.0f;
    private static final float MINIMUM_BUTTON_HEIGHT = 25.0f;
    private static final int MAX_STRINGS = 7;
    private static final int MIN_STRINGS = 4;
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    private TGViewContext context;
    private UIWindow dialog;
    private UITextField nameText;
    private TGColor trackColor;
    private List<TGString> tempStrings;
    private UICheckBox stringTransposition;
    private UICheckBox stringTranspositionTryKeepString;
    private UICheckBox stringTranspositionApplyToChords;
    private UISpinner stringCountSpinner;
    private UIDropDownSelect<Integer>[] stringCombos;
    private UIDropDownSelect<Integer> offsetCombo;
    private int stringCount;
    private UIDropDownSelect<Integer> instrumentCombo;
    private UIColor colorButtonValue;
    private boolean percussionChannel;
    private TGProcess updateItemsProcess;

    public TGTrackPropertiesDialog(TGViewContext context) {
        this.context = context;
        this.stringCombos = new UIDropDownSelect[7];
        this.createSyncProcesses();
    }

    public void show() {
        TGSongManager songManager = this.findSongManager();
        TGTrack track = this.findTrack();
        this.stringCount = track.getStrings().size();
        this.trackColor = track.getColor().clone(songManager.getFactory());
        this.percussionChannel = songManager.isPercussionChannel(track.getSong(), track.getChannelId());
        this.initTempStrings(track.getStrings());
        UIFactory factory = this.getUIFactory();
        UIWindow parent = (UIWindow)this.context.getAttribute("parent2");
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = factory.createWindow(parent, true, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty("track.properties"));
        this.initTrackInfo(track);
        this.initInstrumentFields(track);
        this.initTuningInfo(track);
        this.initButtons();
        this.initListeners();
        this.updateTuningGroup(!this.percussionChannel);
        TGDialogUtil.openDialog(this.dialog, 5);
    }

    private void initListeners() {
        this.addListeners();
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGTrackPropertiesDialog.this.removeListeners();
            }
        });
    }

    private void initTrackInfo(TGTrack track) {
        final UIFactory factory = this.getUIFactory();
        UITableLayout dialogLayout = (UITableLayout)this.dialog.getLayout();
        UITableLayout legendLayout = new UITableLayout();
        UILegendPanel legendPanel = factory.createLegendPanel((UIContainer)this.dialog);
        legendPanel.setLayout((UILayout)legendLayout);
        legendPanel.setText(TuxGuitar.getProperty("track.properties.general"));
        dialogLayout.set((UIControl)legendPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout topLayout = new UITableLayout();
        UIPanel top = factory.createPanel((UIContainer)legendPanel, false);
        top.setLayout((UILayout)topLayout);
        legendLayout.set((UIControl)top, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout bottomLayout = new UITableLayout();
        UIPanel bottom = factory.createPanel((UIContainer)legendPanel, false);
        bottom.setLayout((UILayout)bottomLayout);
        legendLayout.set((UIControl)bottom, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel nameLabel = factory.createLabel((UIContainer)top);
        nameLabel.setText(TuxGuitar.getProperty("track.name") + ":");
        topLayout.set((UIControl)nameLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.nameText = factory.createTextField((UIContainer)top);
        this.nameText.setText(track.getName());
        topLayout.set((UIControl)this.nameText, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        UILabel colorLabel = factory.createLabel((UIContainer)bottom);
        colorLabel.setText(TuxGuitar.getProperty("track.color") + ":");
        bottomLayout.set((UIControl)colorLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIButton colorButton = factory.createButton((UIContainer)bottom);
        colorButton.setText(TuxGuitar.getProperty("choose"));
        colorButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                UIColorModel colorModel = new UIColorModel();
                colorModel.setRed(TGTrackPropertiesDialog.this.trackColor.getR());
                colorModel.setGreen(TGTrackPropertiesDialog.this.trackColor.getG());
                colorModel.setBlue(TGTrackPropertiesDialog.this.trackColor.getB());
                UIColorChooser colorChooser = factory.createColorChooser(TGTrackPropertiesDialog.this.dialog);
                colorChooser.setDefaultModel(colorModel);
                colorChooser.setText(TuxGuitar.getProperty("choose-color"));
                colorChooser.choose(new UIColorChooserHandler(){

                    public void onSelectColor(UIColorModel selection) {
                        if (selection != null) {
                            TGTrackPropertiesDialog.this.trackColor.setR(selection.getRed());
                            TGTrackPropertiesDialog.this.trackColor.setG(selection.getGreen());
                            TGTrackPropertiesDialog.this.trackColor.setB(selection.getBlue());
                            TGTrackPropertiesDialog.this.setButtonColor(colorButton);
                        }
                    }
                });
            }
        });
        colorButton.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGTrackPropertiesDialog.this.disposeButtonColor();
            }
        });
        bottomLayout.set((UIControl)colorButton, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        this.setButtonColor(colorButton);
    }

    private void initTuningInfo(TGTrack track) {
        UIFactory factory = this.getUIFactory();
        UITableLayout dialogLayout = (UITableLayout)this.dialog.getLayout();
        UILegendPanel legendPanel = factory.createLegendPanel((UIContainer)this.dialog);
        legendPanel.setLayout((UILayout)new UITableLayout());
        legendPanel.setText(TuxGuitar.getProperty("tuning"));
        dialogLayout.set((UIControl)legendPanel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(2), Integer.valueOf(1));
        this.initTuningData((UILayoutContainer)legendPanel, track);
        this.initTuningCombos((UILayoutContainer)legendPanel);
    }

    private void initTuningCombos(UILayoutContainer parent) {
        UIFactory factory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UITableLayout panelLayout = new UITableLayout();
        UIPanel panel = factory.createPanel((UIContainer)parent, false);
        panel.setLayout((UILayout)panelLayout);
        parentLayout.set((UIControl)panel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true));
        String[] tuningTexts = this.getAllValueNames();
        for (int i = 0; i < 7; ++i) {
            this.stringCombos[i] = factory.createDropDownSelect((UIContainer)panel);
            for (int value = 0; value < tuningTexts.length; ++value) {
                this.stringCombos[i].addItem(new UISelectItem(tuningTexts[value], (Object)value));
            }
            panelLayout.set(this.stringCombos[i], Integer.valueOf(i + 1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        }
    }

    private void initTuningData(UILayoutContainer parent, TGTrack track) {
        UIFactory factory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UITableLayout panelLayout = new UITableLayout();
        UIPanel panel = factory.createPanel((UIContainer)parent, false);
        panel.setLayout((UILayout)panelLayout);
        parentLayout.set((UIControl)panel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout topLayout = new UITableLayout();
        UIPanel top = factory.createPanel((UIContainer)panel, false);
        top.setLayout((UILayout)topLayout);
        panelLayout.set((UIControl)top, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout middleLayout = new UITableLayout();
        UIPanel middle = factory.createPanel((UIContainer)panel, false);
        middle.setLayout((UILayout)middleLayout);
        panelLayout.set((UIControl)middle, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout bottomLayout = new UITableLayout();
        UIPanel bottom = factory.createPanel((UIContainer)panel, false);
        bottom.setLayout((UILayout)bottomLayout);
        panelLayout.set((UIControl)bottom, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel stringCountLabel = factory.createLabel((UIContainer)top);
        stringCountLabel.setText(TuxGuitar.getProperty("tuning.strings") + ":");
        topLayout.set((UIControl)stringCountLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.stringCountSpinner = factory.createSpinner((UIContainer)top);
        this.stringCountSpinner.setMinimum(4);
        this.stringCountSpinner.setMaximum(7);
        this.stringCountSpinner.setValue(this.stringCount);
        this.stringCountSpinner.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackPropertiesDialog.this.stringCount = TGTrackPropertiesDialog.this.stringCountSpinner.getValue();
                TGTrackPropertiesDialog.this.setDefaultTuning(TGTrackPropertiesDialog.this.percussionChannel);
                TGTrackPropertiesDialog.this.updateTuningGroup(!TGTrackPropertiesDialog.this.percussionChannel);
            }
        });
        topLayout.set((UIControl)this.stringCountSpinner, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel offsetLabel = factory.createLabel((UIContainer)middle);
        offsetLabel.setText(TuxGuitar.getProperty("tuning.offset") + ":");
        middleLayout.set((UIControl)offsetLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.offsetCombo = factory.createDropDownSelect((UIContainer)middle);
        for (int i = -24; i <= 24; ++i) {
            this.offsetCombo.addItem(new UISelectItem(Integer.toString(i), (Object)i));
        }
        this.offsetCombo.setSelectedValue((Object)track.getOffset());
        middleLayout.set(this.offsetCombo, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.stringTransposition = factory.createCheckBox((UIContainer)bottom);
        this.stringTransposition.setText(TuxGuitar.getProperty("tuning.strings.transpose"));
        this.stringTransposition.setSelected(true);
        bottomLayout.set((UIControl)this.stringTransposition, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.stringTranspositionApplyToChords = factory.createCheckBox((UIContainer)bottom);
        this.stringTranspositionApplyToChords.setText(TuxGuitar.getProperty("tuning.strings.transpose.apply-to-chords"));
        this.stringTranspositionApplyToChords.setSelected(true);
        bottomLayout.set((UIControl)this.stringTranspositionApplyToChords, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.stringTranspositionTryKeepString = factory.createCheckBox((UIContainer)bottom);
        this.stringTranspositionTryKeepString.setText(TuxGuitar.getProperty("tuning.strings.transpose.try-keep-strings"));
        this.stringTranspositionTryKeepString.setSelected(true);
        bottomLayout.set((UIControl)this.stringTranspositionTryKeepString, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.stringTransposition.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                UICheckBox stringTransposition = TGTrackPropertiesDialog.this.stringTransposition;
                UICheckBox stringTranspositionApplyToChords = TGTrackPropertiesDialog.this.stringTranspositionApplyToChords;
                UICheckBox stringTranspositionTryKeepString = TGTrackPropertiesDialog.this.stringTranspositionTryKeepString;
                stringTranspositionApplyToChords.setEnabled(stringTransposition.isEnabled() && stringTransposition.isSelected());
                stringTranspositionTryKeepString.setEnabled(stringTransposition.isEnabled() && stringTransposition.isSelected());
            }
        });
    }

    private void initButtons() {
        UIFactory factory = this.getUIFactory();
        UITableLayout dialogLayout = (UITableLayout)this.dialog.getLayout();
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = factory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(2));
        UIButton buttonOK = factory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackPropertiesDialog.this.updateTrackProperties();
                TGTrackPropertiesDialog.this.dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = factory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackPropertiesDialog.this.dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
    }

    private void initInstrumentFields(TGTrack track) {
        UIFactory factory = this.getUIFactory();
        UITableLayout dialogLayout = (UITableLayout)this.dialog.getLayout();
        UITableLayout legendLayout = new UITableLayout();
        UILegendPanel legendPanel = factory.createLegendPanel((UIContainer)this.dialog);
        legendPanel.setLayout((UILayout)legendLayout);
        legendPanel.setText(TuxGuitar.getProperty("instrument"));
        dialogLayout.set((UIControl)legendPanel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout topLayout = new UITableLayout();
        UIPanel top = factory.createPanel((UIContainer)legendPanel, false);
        top.setLayout((UILayout)topLayout);
        legendLayout.set((UIControl)top, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel instrumentLabel = factory.createLabel((UIContainer)top);
        instrumentLabel.setText(TuxGuitar.getProperty("instrument") + ":");
        topLayout.set((UIControl)instrumentLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.instrumentCombo = factory.createDropDownSelect((UIContainer)top);
        this.instrumentCombo.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackPropertiesDialog.this.checkPercussionChannel();
            }
        });
        topLayout.set(this.instrumentCombo, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.loadChannels(track.getChannelId());
        TGActionProcessorListener settingsListener = new TGActionProcessorListener(this.context.getContext(), "action.gui.toggle-channels-dialog");
        settingsListener.setAttribute("parent2", this.dialog);
        UIButton settings = factory.createButton((UIContainer)top);
        settings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        settings.setToolTipText(TuxGuitar.getProperty("settings"));
        settings.addSelectionListener((UISelectionListener)settingsListener);
        topLayout.set((UIControl)settings, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
    }

    protected void loadChannels(Integer selectedChannelId) {
        this.instrumentCombo.removeItems();
        this.instrumentCombo.addItem(new UISelectItem(TuxGuitar.getProperty("track.instrument.default-select-option"), null));
        List channels = this.findSongManager().getChannels(this.findSong());
        for (TGChannel channel : channels) {
            this.instrumentCombo.addItem(new UISelectItem(channel.getName(), (Object)channel.getChannelId()));
        }
        this.instrumentCombo.setSelectedValue((Object)selectedChannelId);
    }

    protected void reloadChannels() {
        this.loadChannels(this.getSelectedChannelId());
    }

    protected void checkPercussionChannel() {
        boolean percussionChannel = this.findSongManager().isPercussionChannel(this.findSong(), this.getSelectedChannelId());
        if (this.percussionChannel != percussionChannel) {
            this.setDefaultTuning(percussionChannel);
            this.updateTuningGroup(!percussionChannel);
        }
        this.percussionChannel = percussionChannel;
    }

    protected int getSelectedChannelId() {
        Integer selectedValue = (Integer)this.instrumentCombo.getSelectedValue();
        return selectedValue != null ? selectedValue : -1;
    }

    protected void updateTrackProperties() {
        boolean transposeTryKeepString;
        TGSongManager songManager = this.findSongManager();
        TGSong song = this.findSong();
        TGTrack track = this.findTrack();
        String trackName = this.nameText.getText();
        ArrayList<TGString> strings = new ArrayList<TGString>();
        for (int i = 0; i < this.stringCount; ++i) {
            strings.add(TGSongManager.newString((TGFactory)this.findSongManager().getFactory(), (int)(i + 1), (int)((Integer)this.stringCombos[i].getSelectedValue())));
        }
        Integer channelId = this.getSelectedChannelId();
        TGChannel channel = songManager.getChannel(song, channelId.intValue());
        Integer offset = songManager.isPercussionChannel(song, channelId.intValue()) ? 0 : (Integer)this.offsetCombo.getSelectedValue();
        TGColor trackColor = this.trackColor;
        boolean infoChanges = this.hasInfoChanges(track, trackName, trackColor, offset);
        boolean tuningChanges = this.hasTuningChanges(track, strings);
        boolean channelChanges = this.hasChannelChanges(track, channelId);
        boolean transposeStrings = this.shouldTransposeStrings(track, channelId);
        boolean transposeApplyToChords = transposeStrings && this.stringTranspositionApplyToChords.isSelected();
        boolean bl = transposeTryKeepString = transposeStrings && this.stringTranspositionTryKeepString.isSelected();
        if (infoChanges || tuningChanges || channelChanges) {
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.track.change-properties");
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
            if (infoChanges) {
                tgActionProcessor.setAttribute("updateInfo", (Object)Boolean.TRUE);
                tgActionProcessor.setAttribute("name", (Object)trackName);
                tgActionProcessor.setAttribute("color", (Object)trackColor);
                tgActionProcessor.setAttribute("offset", (Object)offset);
            }
            if (tuningChanges) {
                tgActionProcessor.setAttribute("updateTuning", (Object)Boolean.TRUE);
                tgActionProcessor.setAttribute("strings", strings);
                tgActionProcessor.setAttribute("transposeStrings", (Object)transposeStrings);
                tgActionProcessor.setAttribute("transposeTryKeepString", (Object)transposeTryKeepString);
                tgActionProcessor.setAttribute("transposeApplyToChords", (Object)transposeApplyToChords);
            }
            if (channelChanges) {
                tgActionProcessor.setAttribute("updateChannel", (Object)Boolean.TRUE);
                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHANNEL, (Object)channel);
            }
            tgActionProcessor.process();
        }
    }

    protected boolean shouldTransposeStrings(TGTrack track, int selectedChannelId) {
        if (this.stringTransposition.isSelected()) {
            boolean percussionChannelNew = this.findSongManager().isPercussionChannel(track.getSong(), selectedChannelId);
            boolean percussionChannelOld = this.findSongManager().isPercussionChannel(track.getSong(), track.getChannelId());
            return !percussionChannelNew && !percussionChannelOld;
        }
        return false;
    }

    protected boolean hasInfoChanges(TGTrack track, String name, TGColor color, int offset) {
        if (!name.equals(track.getName())) {
            return true;
        }
        if (!color.isEqual(track.getColor())) {
            return true;
        }
        return offset != track.getOffset();
    }

    protected boolean hasChannelChanges(TGTrack track, int channelId) {
        return track.getChannelId() != channelId;
    }

    protected boolean hasTuningChanges(TGTrack track, List<TGString> newStrings) {
        List oldStrings = track.getStrings();
        if (oldStrings.size() != newStrings.size()) {
            return true;
        }
        for (int i = 0; i < oldStrings.size(); ++i) {
            TGString oldString = (TGString)oldStrings.get(i);
            boolean stringExists = false;
            for (int j = 0; j < newStrings.size(); ++j) {
                TGString newString = newStrings.get(j);
                if (!newString.isEqual(oldString)) continue;
                stringExists = true;
            }
            if (stringExists) continue;
            return true;
        }
        return false;
    }

    protected void setButtonColor(UIButton button) {
        button.setFgColor(null);
        this.disposeButtonColor();
        this.colorButtonValue = this.getUIFactory().createColor(this.trackColor.getR(), this.trackColor.getG(), this.trackColor.getB());
        button.setFgColor(this.colorButtonValue);
    }

    protected void disposeButtonColor() {
        if (this.colorButtonValue != null && !this.colorButtonValue.isDisposed()) {
            this.colorButtonValue.dispose();
            this.colorButtonValue = null;
        }
    }

    protected void updateTuningGroup(boolean enabled) {
        int i;
        for (i = 0; i < this.tempStrings.size(); ++i) {
            TGString string = this.tempStrings.get(i);
            this.stringCombos[i].setSelectedValue((Object)string.getValue());
            this.stringCombos[i].setVisible(true);
            this.stringCombos[i].setEnabled(enabled);
        }
        for (i = this.tempStrings.size(); i < 7; ++i) {
            this.stringCombos[i].setSelectedValue((Object)0);
            this.stringCombos[i].setVisible(false);
        }
        this.offsetCombo.setEnabled(enabled);
        this.stringTransposition.setEnabled(enabled);
        this.stringTranspositionApplyToChords.setEnabled(enabled && this.stringTransposition.isSelected());
        this.stringTranspositionTryKeepString.setEnabled(enabled && this.stringTransposition.isSelected());
    }

    protected void initTempStrings(List<TGString> realStrings) {
        this.tempStrings = new ArrayList<TGString>();
        for (int i = 0; i < realStrings.size(); ++i) {
            TGString realString = realStrings.get(i);
            this.tempStrings.add(realString.clone(this.findSongManager().getFactory()));
        }
    }

    protected void setDefaultTuning(boolean percussionChannel) {
        this.tempStrings.clear();
        if (percussionChannel) {
            this.tempStrings.addAll(this.findSongManager().createPercussionStrings(this.stringCount));
        } else {
            this.tempStrings.addAll(this.findSongManager().createDefaultInstrumentStrings(this.stringCount));
        }
    }

    protected String[] getAllValueNames() {
        String[] valueNames = new String[120];
        for (int i = 0; i < valueNames.length; ++i) {
            valueNames[i] = NOTE_NAMES[i - i / 12 * 12] + i / 12;
        }
        return valueNames;
    }

    public void addListeners() {
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    public TGSongManager findSongManager() {
        return (TGSongManager)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER);
    }

    public TGSong findSong() {
        return (TGSong)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
    }

    public TGTrack findTrack() {
        return (TGTrack)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context.getContext()).getFactory();
    }

    public void updateItems() {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.reloadChannels();
        }
    }

    public void createSyncProcesses() {
        this.updateItemsProcess = new TGSyncProcessLocked(this.context.getContext(), new Runnable(){

            public void run() {
                TGTrackPropertiesDialog.this.updateItems();
            }
        });
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateItemsProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }
}

