/*
 * Decompiled with CFR 0.152.
 */
package org.qtjambi.qt.designer;

import java.util.HashMap;
import org.qtjambi.qt.designer.AbstractPropertyHandler;
import org.qtjambi.qt.designer.ColorPropertyHandler;
import org.qtjambi.qt.designer.QUiLoaderException;
import org.qtjambi.qt.gui.QBrush;
import org.qtjambi.qt.gui.QColor;
import org.qtjambi.qt.gui.QPalette;
import org.qtjambi.qt.widgets.QApplication;
import org.qtjambi.qt.xml.QDomElement;
import org.qtjambi.qt.xml.QDomNode;
import org.qtjambi.qt.xml.QDomNodeList;

class PalettePropertyHandler
extends AbstractPropertyHandler {
    private ColorPropertyHandler colorHandler = new ColorPropertyHandler();
    static HashMap<String, QPalette.ColorRole> colorRoles = new HashMap();

    PalettePropertyHandler() {
    }

    @Override
    public Object create(QDomElement e) throws QUiLoaderException {
        QPalette p = QApplication.palette();
        this.parse(e.namedItem("active").toElement(), p, QPalette.ColorGroup.Active);
        this.parse(e.namedItem("inactive").toElement(), p, QPalette.ColorGroup.Inactive);
        this.parse(e.namedItem("disabled").toElement(), p, QPalette.ColorGroup.Disabled);
        return p;
    }

    private void parse(QDomElement groupElement, QPalette p, QPalette.ColorGroup group) throws QUiLoaderException {
        QDomNodeList list = groupElement.childNodes();
        for (int i = 0; i < list.count(); ++i) {
            QDomNode node = list.at(i);
            if (!node.nodeName().equals("colorrole")) continue;
            QDomElement roleElement = node.toElement();
            QPalette.ColorRole role = colorRoles.get(roleElement.attribute("role"));
            QDomElement brushElement = roleElement.namedItem("brush").toElement();
            if (!brushElement.attribute("brushstyle").equals("SolidPattern")) {
                throw new QUiLoaderException("Unhandled brush style: " + brushElement.attribute("brushstyle"));
            }
            QColor color = (QColor)this.colorHandler.create(brushElement.namedItem("color").toElement());
            QBrush brush = new QBrush(color);
            p.setBrush(group, role, brush);
        }
    }

    static {
        for (QPalette.ColorRole role : QPalette.ColorRole.values()) {
            colorRoles.put(role.name(), role);
        }
    }
}

