/*
 * Decompiled with CFR 0.152.
 */
package org.qtjambi.qt.osinfo;

public class OSInfo {
    public static final String K_SUNOS32 = "sunos32";
    public static final String K_SUNOS64 = "sunos64";
    public static final String K_WIN32 = "win32";
    public static final String K_WIN64 = "win64";
    public static final String K_LINUX32 = "linux32";
    public static final String K_LINUX64 = "linux64";
    public static final String K_FREEBSD32 = "freebsd32";
    public static final String K_FREEBSD64 = "freebsd64";
    public static final String K_SUNOS = "sunos";
    public static final String K_WINDOWS = "windows";
    public static final String K_LINUX = "linux";
    public static final String K_FREEBSD = "freebsd";
    public static final String K_MACOSX = "macosx";
    private static OS os;
    private static String osArchName;

    public static OS os() {
        if (os == null) {
            String osname = System.getProperty("os.name").toLowerCase();
            os = osname.contains(K_LINUX) ? OS.Linux : (osname.contains(K_WINDOWS) ? OS.Windows : (osname.contains("mac os x") ? OS.MacOS : (osname.contains(K_SUNOS) ? OS.Solaris : (osname.contains(K_FREEBSD) ? OS.FreeBSD : OS.Unknown))));
        }
        return os;
    }

    public static String osArchName() {
        if (osArchName == null) {
            switch (OSInfo.os()) {
                case Windows: {
                    osArchName = System.getProperty("os.arch").equalsIgnoreCase("amd64") ? K_WIN64 : K_WIN32;
                    break;
                }
                case Linux: {
                    osArchName = System.getProperty("os.arch").equalsIgnoreCase("amd64") ? K_LINUX64 : K_LINUX32;
                    break;
                }
                case FreeBSD: {
                    osArchName = System.getProperty("os.arch").equalsIgnoreCase("amd64") ? K_FREEBSD64 : K_FREEBSD32;
                    break;
                }
                case MacOS: {
                    osArchName = K_MACOSX;
                    break;
                }
                case Solaris: {
                    osArchName = System.getProperty("os.arch").equalsIgnoreCase("sparcv9") ? K_SUNOS32 : K_SUNOS64;
                    break;
                }
                case Unknown: {
                    osArchName = "unknown";
                }
            }
        }
        return osArchName;
    }

    public static boolean isWindows() {
        return OSInfo.os() == OS.Windows;
    }

    public static boolean isLinux() {
        return OSInfo.os() == OS.Linux;
    }

    public static boolean isMacOS() {
        return OSInfo.os() == OS.MacOS;
    }

    public static boolean isFreeBSD() {
        return OSInfo.os() == OS.FreeBSD;
    }

    public static boolean isSolaris() {
        return OSInfo.os() == OS.Solaris;
    }

    public static Boolean is64bit() {
        String s = OSInfo.osArchName();
        if (K_LINUX64.equals(s)) {
            return Boolean.TRUE;
        }
        if (K_WIN64.equals(s)) {
            return Boolean.TRUE;
        }
        if (K_MACOSX.equals(s)) {
            return Boolean.TRUE;
        }
        if (K_FREEBSD64.equals(s)) {
            return Boolean.TRUE;
        }
        if (K_SUNOS64.equals(s)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static enum OS {
        Unknown("unkwnown"),
        Windows("windows"),
        Linux("linux"),
        MacOS("macosx"),
        Solaris("sunos"),
        FreeBSD("freebsd");

        private String name;

        private OS(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

