/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.control.TGBeatGroup;
import org.herac.tuxguitar.graphics.control.TGBeatSpacing;
import org.herac.tuxguitar.graphics.control.TGChordImpl;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGNoteImpl;
import org.herac.tuxguitar.graphics.control.TGResourceBuffer;
import org.herac.tuxguitar.graphics.control.TGVoiceImpl;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGVoice;

public class TGBeatImpl
extends TGBeat {
    public static final int JOINED_TYPE_NONE_LEFT = 1;
    public static final int JOINED_TYPE_NONE_RIGHT = 2;
    public static final int JOINED_TYPE_LEFT = 3;
    public static final int JOINED_TYPE_RIGHT = 4;
    private float posX;
    private float width;
    private TGNoteImpl maxNote;
    private TGNoteImpl minNote;
    private boolean[] usedStrings;
    private int joinedType;
    private boolean joinedGreaterThanQuarter;
    private TGBeatImpl join1;
    private TGBeatImpl join2;
    private TGBeatImpl previous;
    private TGBeatImpl next;
    private TGBeatGroup group;
    private TGBeatSpacing bs;
    private boolean accentuated;
    private boolean heavyAccentuated;
    private boolean harmonic;
    private boolean tapping;
    private boolean slapping;
    private boolean popping;
    private boolean palmMute;
    private boolean letRing;
    private boolean vibrato;
    private boolean trill;
    private boolean fadeIn;

    public TGBeatImpl(TGFactory factory) {
        super(factory);
    }

    public float getPosX() {
        return this.posX;
    }

    public void setPosX(float posX) {
        this.posX = posX;
    }

    public float getMinimumWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public TGNoteImpl getMinNote() {
        return this.minNote;
    }

    public TGNoteImpl getMaxNote() {
        return this.maxNote;
    }

    public TGMeasureImpl getMeasureImpl() {
        return (TGMeasureImpl)this.getMeasure();
    }

    public boolean[] getUsedStrings() {
        if (this.usedStrings == null) {
            this.usedStrings = new boolean[this.getMeasure().getTrack().stringCount()];
        }
        return this.usedStrings;
    }

    public TGBeatImpl getJoin1() {
        return this.join1;
    }

    public void setJoin1(TGBeatImpl join1) {
        this.join1 = join1;
    }

    public TGBeatImpl getJoin2() {
        return this.join2;
    }

    public void setJoin2(TGBeatImpl join2) {
        this.join2 = join2;
    }

    public boolean isJoinedGreaterThanQuarter() {
        return this.joinedGreaterThanQuarter;
    }

    public void setJoinedGreaterThanQuarter(boolean joinedGreaterThanQuarter) {
        this.joinedGreaterThanQuarter = joinedGreaterThanQuarter;
    }

    public int getJoinedType() {
        return this.joinedType;
    }

    public void setJoinedType(int joinedType) {
        this.joinedType = joinedType;
    }

    public TGBeatImpl getPreviousBeat() {
        return this.previous;
    }

    public void setPreviousBeat(TGBeatImpl previous) {
        this.previous = previous;
    }

    public TGBeatImpl getNextBeat() {
        return this.next;
    }

    public void setNextBeat(TGBeatImpl next) {
        this.next = next;
    }

    public TGBeatGroup getBeatGroup() {
        return this.group;
    }

    public void setBeatGroup(TGBeatGroup group) {
        this.group = group;
    }

    public float getSpacing(TGLayout layout) {
        return this.getMeasureImpl().getBeatSpacing(layout, this);
    }

    public boolean isPlaying(TGLayout layout) {
        return layout.getComponent().isRunning(this);
    }

    public TGVoiceImpl getVoiceImpl(int index) {
        TGVoice voice = super.getVoice(index);
        if (voice instanceof TGVoiceImpl) {
            return (TGVoiceImpl)voice;
        }
        return null;
    }

    public void reset() {
        this.maxNote = null;
        this.minNote = null;
        this.usedStrings = new boolean[this.getMeasure().getTrack().stringCount()];
    }

    public void check(TGLayout layout, TGNoteImpl note) {
        int value = note.getRealValue();
        if (this.maxNote == null || value > this.maxNote.getRealValue()) {
            this.maxNote = note;
        }
        if (this.minNote == null || value < this.minNote.getRealValue()) {
            this.minNote = note;
        }
        this.getUsedStrings();
        this.usedStrings[note.getString() - 1] = true;
    }

    public void resetEffectsSpacing(TGLayout layout) {
        this.bs = new TGBeatSpacing(layout);
        this.accentuated = false;
        this.heavyAccentuated = false;
        this.harmonic = false;
        this.tapping = false;
        this.slapping = false;
        this.popping = false;
        this.palmMute = false;
        this.letRing = false;
        this.fadeIn = false;
        this.vibrato = false;
        this.trill = false;
    }

    public void updateEffectsSpacing(TGLayout layout, TGNoteEffect effect) {
        if (effect.isAccentuatedNote()) {
            this.accentuated = true;
        }
        if (effect.isHeavyAccentuatedNote()) {
            this.heavyAccentuated = true;
        }
        if (effect.isHarmonic() && (layout.getStyle() & 4) == 0) {
            this.harmonic = true;
        }
        if (effect.isTapping()) {
            this.tapping = true;
        }
        if (effect.isSlapping()) {
            this.slapping = true;
        }
        if (effect.isPopping()) {
            this.popping = true;
        }
        if (effect.isPalmMute()) {
            this.palmMute = true;
        }
        if (effect.isLetRing()) {
            this.letRing = true;
        }
        if (effect.isFadeIn()) {
            this.fadeIn = true;
        }
        if (effect.isVibrato()) {
            this.vibrato = true;
        }
        if (effect.isTrill()) {
            this.trill = true;
        }
    }

    public float getEffectsSpacing(TGLayout layout) {
        if (this.accentuated) {
            this.bs.setSize(0, layout.getEffectSpacing());
        }
        if (this.heavyAccentuated) {
            this.bs.setSize(1, layout.getEffectSpacing());
        }
        if (this.harmonic) {
            this.bs.setSize(2, layout.getEffectSpacing());
        }
        if (this.tapping) {
            this.bs.setSize(3, layout.getEffectSpacing());
        }
        if (this.slapping) {
            this.bs.setSize(4, layout.getEffectSpacing());
        }
        if (this.popping) {
            this.bs.setSize(5, layout.getEffectSpacing());
        }
        if (this.palmMute) {
            this.bs.setSize(6, layout.getEffectSpacing());
        }
        if (this.letRing) {
            this.bs.setSize(7, layout.getEffectSpacing());
        }
        if (this.fadeIn) {
            this.bs.setSize(10, layout.getEffectSpacing());
        }
        if (this.vibrato) {
            this.bs.setSize(8, layout.getEffectSpacing());
        }
        if (this.trill) {
            this.bs.setSize(9, layout.getEffectSpacing());
        }
        return this.bs.getSize();
    }

    public void registerBuffer(TGLayout layout) {
        String chordRegistryKey = TGChord.class.getName() + "-" + this.hashCode();
        TGResourceBuffer buffer = layout.getResourceBuffer();
        if (this.isChordBeat()) {
            TGChordImpl tgChord = (TGChordImpl)this.getChord();
            tgChord.registerBuffer(buffer, chordRegistryKey);
        } else if (buffer.isRegistered(chordRegistryKey)) {
            buffer.unregister(chordRegistryKey);
        }
    }

    public void paint(TGLayout layout, TGPainter painter, float fromX, float fromY) {
        if (!layout.isPlayModeEnabled() && (layout.getStyle() & 4) != 0) {
            this.paintExtraLines(painter, layout, fromX, fromY);
        }
        for (int v = 0; v < 2; ++v) {
            this.getVoiceImpl(v).paint(layout, painter, fromX, fromY);
        }
        if (!layout.isPlayModeEnabled()) {
            if (this.isChordBeat()) {
                TGChordImpl chord = (TGChordImpl)this.getChord();
                chord.paint(layout, painter, fromX, fromY);
            }
            if (this.getStroke().getDirection() != 0) {
                this.paintStroke(layout, painter, fromX, fromY);
            }
        }
    }

    public void paintExtraLines(TGPainter painter, TGLayout layout, float fromX, float fromY) {
        if (!this.isRestBeat()) {
            float scoreY = fromY + this.getMeasureImpl().getTs().getPosition(8);
            this.paintExtraLines(painter, layout, this.getMinNote(), fromX, scoreY);
            this.paintExtraLines(painter, layout, this.getMaxNote(), fromX, scoreY);
        }
    }

    private void paintExtraLines(TGPainter painter, TGLayout layout, TGNoteImpl note, float fromX, float fromY) {
        float scale = layout.getScale();
        float scoreLineSpacing = layout.getScoreLineSpacing();
        float spacing = layout.getScoreLineSpacing() / 2.0f;
        float noteY = fromY + note.getScorePosY() + spacing;
        float lineY = fromY > noteY ? fromY : fromY + scoreLineSpacing * 4.0f;
        float x = fromX + this.getPosX() + this.getSpacing(layout);
        float x1 = x - 4.0f * scale;
        float x2 = x + 12.0f * scale;
        int direction = fromY > noteY ? -1 : 1;
        int requiredExtraLines = this.findRequiredExtraLines(layout, lineY, noteY, direction);
        if (requiredExtraLines > 0) {
            layout.setLineStyle(painter);
            for (int i = 0; i < requiredExtraLines; ++i) {
                painter.initPath();
                painter.setAntialias(false);
                painter.moveTo(x1, lineY + scoreLineSpacing * (float)(i + 1) * (float)direction);
                painter.lineTo(x2, lineY + scoreLineSpacing * (float)(i + 1) * (float)direction);
                painter.closePath();
            }
        }
    }

    private int findRequiredExtraLines(TGLayout layout, float lineY, float noteY, int direction) {
        int counter = 0;
        float spacing = layout.getScoreLineSpacing() / 2.0f;
        float previousPosition = lineY;
        float position = lineY + spacing * (float)direction;
        float distance2;
        float distance1;
        while (Math.min(distance1 = Math.abs(previousPosition - noteY), distance2 = Math.abs(position - noteY)) != distance1) {
            previousPosition = position;
            position += spacing * (float)direction;
            ++counter;
        }
        return counter > 0 ? counter / 2 : 0;
    }

    public void paintStroke(TGLayout layout, TGPainter painter, float fromX, float fromY) {
        float y;
        int style = layout.getStyle();
        float scale = layout.getScale();
        float x = fromX + this.getPosX() + this.getSpacing(layout) + 12.0f * scale;
        float y1 = 0.0f;
        float y2 = 0.0f;
        if ((style & 4) != 0) {
            y = fromY + this.getPaintPosition(8);
            y1 = y + layout.getScoreLineSpacing();
            y2 = y + (this.getMeasureImpl().getTrackImpl().getScoreHeight() - layout.getScoreLineSpacing());
        }
        if ((style & 8) != 0) {
            y = fromY + this.getPaintPosition(14);
            y1 = y + layout.getStringSpacing();
            y2 = y + (this.getMeasureImpl().getTrackImpl().getTabHeight() - layout.getStringSpacing());
        } else if ((style & 4) != 0) {
            y = fromY + this.getPaintPosition(8);
            y1 = y + layout.getScoreLineSpacing();
            y2 = y + (this.getMeasureImpl().getTrackImpl().getScoreHeight() - layout.getScoreLineSpacing());
        } else {
            return;
        }
        if (this.getStroke().getDirection() == 1) {
            painter.setLineWidth(layout.getLineWidth(0));
            painter.initPath();
            painter.moveTo(x, y1);
            painter.lineTo(x, y2);
            painter.moveTo(x - 2.0f * scale, y2 - 5.0f * scale);
            painter.lineTo(x, y2);
            painter.moveTo(x + 2.0f * scale, y2 - 5.0f * scale);
            painter.lineTo(x, y2);
            painter.closePath();
        } else if (this.getStroke().getDirection() == -1) {
            painter.setLineWidth(layout.getLineWidth(0));
            painter.initPath();
            painter.moveTo(x, y2);
            painter.lineTo(x, y1);
            painter.moveTo(x - 2.0f * scale, y1 + 5.0f * scale);
            painter.lineTo(x, y1);
            painter.moveTo(x + 2.0f * scale, y1 + 5.0f * scale);
            painter.lineTo(x, y1);
            painter.closePath();
        }
    }

    public float getPaintPosition(int index) {
        return this.getMeasureImpl().getTs().getPosition(index);
    }

    public TGBeatSpacing getBs() {
        return this.bs;
    }
}

