/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGTrackImpl
extends TGTrack {
    private float tabHeight;
    private float scoreHeight;

    public TGTrackImpl(TGFactory factory) {
        super(factory);
    }

    public void update(TGLayout layout) {
        this.calculateTabHeight(layout);
        this.calculateScoreHeight(layout);
    }

    public void calculateTabHeight(TGLayout layout) {
        this.tabHeight = (layout.getStyle() & 8) != 0 ? (float)(this.stringCount() - 1) * layout.getStringSpacing() : 0.0f;
    }

    public void calculateScoreHeight(TGLayout layout) {
        this.scoreHeight = (layout.getStyle() & 4) != 0 ? layout.getScoreLineSpacing() * 4.0f : 0.0f;
    }

    public float getTabHeight() {
        return this.tabHeight;
    }

    public float getScoreHeight() {
        return this.scoreHeight;
    }

    public void setTabHeight(float tabHeight) {
        this.tabHeight = tabHeight;
    }
}

