/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control.print;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.graphics.TGFont;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.TGRectangle;
import org.herac.tuxguitar.graphics.TGResourceFactory;
import org.herac.tuxguitar.graphics.control.TGController;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGLyricImpl;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.graphics.control.TGTrackSpacing;
import org.herac.tuxguitar.graphics.control.print.TGPrintDocument;
import org.herac.tuxguitar.graphics.control.print.TGPrintSettings;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGPrintLayout
extends TGLayout {
    private TGPrintSettings settings;
    private TGPrintDocument document;
    private int page;
    private TGFont songNameFont;
    private TGFont trackNameFont;
    private TGFont songAuthorFont;

    public TGPrintLayout(TGController controller, TGPrintSettings settings) {
        super(controller, settings.getStyle() | 1);
        this.settings = settings;
    }

    public int getMode() {
        return 0;
    }

    public void makeDocument(TGPrintDocument document) {
        this.page = 0;
        this.document = document;
        this.makeDocument();
    }

    private void makeDocument() {
        this.document.start();
        this.paint(this.document.getPainter(), null, this.document.getMargins().getLeft(), this.document.getMargins().getTop());
        this.document.finish();
    }

    public void paintSong(TGPainter painter, TGRectangle clientArea, float fromX, float fromY) {
        this.setWidth(0.0f);
        this.setHeight(0.0f);
        int style = this.getStyle();
        float posY = 0.0f;
        float height = this.getFirstTrackSpacing();
        float lineHeight = 0.0f;
        Iterator<TGTrack> tracks = this.getSong().getTracks();
        while (tracks.hasNext()) {
            TGTrackImpl track = (TGTrackImpl)tracks.next();
            if (this.settings.getTrackNumber() >= 0 && track.getNumber() != this.settings.getTrackNumber()) continue;
            this.openPage();
            posY = Math.round(fromY + this.getFirstTrackSpacing());
            posY += this.paintHeader(painter, track);
            ((TGLyricImpl)track.getLyrics()).start(this.getSkippedBeats(track));
            TGTrackSpacing ts = new TGTrackSpacing(this);
            TempLine line = this.getTempLines(track, this.settings.getFromMeasure() - 1, ts);
            while (!line.measures.isEmpty()) {
                ts.setSize(8, (style & 4) != 0 ? this.getScoreLineSpacing() * 5.0f : 0.0f);
                if ((style & 4) != 0) {
                    ts.setSize(7, Math.abs(line.minY));
                    if (line.maxY > track.getScoreHeight()) {
                        ts.setSize(9, line.maxY - track.getScoreHeight());
                    }
                }
                if ((style & 8) != 0) {
                    ts.setSize(13, (style & 4) != 0 ? this.getMinScoreTabSpacing() : Math.max(Math.abs(line.minY), this.getStringSpacing()));
                    ts.setSize(14, (style & 4) != 0 ? track.getTabHeight() + this.getStringSpacing() + 1.0f : Math.max(line.maxY, track.getTabHeight() + this.getStringSpacing() + 1.0f));
                }
                ts.setSize(15, 10.0f);
                this.checkDefaultSpacing(ts);
                lineHeight = ts.getSize();
                if (posY + lineHeight + this.getTrackSpacing() > this.document.getMargins().getTop() + this.getMaxHeight()) {
                    this.paintFooter(painter);
                    this.closePage();
                    this.openPage();
                    posY = Math.round(this.document.getMargins().getTop() + this.getFirstTrackSpacing());
                }
                this.paintLine(track, line, painter, fromX, posY, ts);
                float lineHeightWithSpacing = Math.round(lineHeight + this.getTrackSpacing() + 0.5f);
                posY += lineHeightWithSpacing;
                height += lineHeightWithSpacing;
                ts = new TGTrackSpacing(this);
                line = this.getTempLines(track, line.lastIndex + 1, ts);
            }
            this.paintFooter(painter);
            this.closePage();
        }
        this.setHeight(height);
    }

    public float paintHeader(TGPainter painter, TGTrack track) {
        float headerOffset = 0.0f;
        if (this.document.isPaintable(this.page)) {
            float x = this.document.getMargins().getLeft();
            float y = this.document.getMargins().getTop();
            float fmTopLine = painter.getFMTopLine();
            String songName = this.getSong().getName();
            String songAuthor = this.getSong().getAuthor();
            String trackName = track.getName();
            if (songName != null && songName.length() > 0) {
                painter.setFont(this.getSongNameFont(painter));
                painter.drawString(songName, x + this.getCenter(painter, songName), fmTopLine + y);
                headerOffset += 30.0f * this.getScale();
            }
            if (trackName != null && trackName.length() > 0) {
                trackName = "(" + trackName + ")";
                painter.setFont(this.getTrackNameFont(painter));
                painter.drawString(trackName, x + this.getCenter(painter, trackName), fmTopLine + y + (float)Math.round(headerOffset));
                headerOffset += 20.0f * this.getScale();
            }
            if (songAuthor != null && songAuthor.length() > 0) {
                painter.setFont(this.getSongAuthorFont(painter));
                painter.drawString(songAuthor, x + this.getRight(painter, songAuthor), fmTopLine + y + (float)Math.round(headerOffset));
                headerOffset += 20.0f * this.getScale();
            }
        }
        return headerOffset;
    }

    private void paintFooter(TGPainter painter) {
        if (this.document.isPaintable(this.page)) {
            float x = this.document.getMargins().getLeft();
            float y = this.document.getMargins().getTop();
            float fmTopLine = painter.getFMTopLine();
            String pageNumber = Integer.toString(this.page);
            painter.setBackground(this.getResources().getColorWhite());
            painter.setForeground(this.getResources().getColorBlack());
            painter.drawString(pageNumber, x + this.getRight(painter, pageNumber), fmTopLine + y + this.getBottom(painter, pageNumber));
        }
    }

    public void paintLine(TGTrackImpl track, TempLine line, TGPainter painter, float fromX, float fromY, TGTrackSpacing ts) {
        if (this.document.isPaintable(this.page)) {
            float diff;
            float posX = fromX;
            float posY = fromY;
            float width = 0.0f;
            float defaultMeasureSpacing = 0.0f;
            if (line.fullLine && (diff = this.getMaxWidth() - line.tempWith) != 0.0f && line.measures.size() > 0) {
                defaultMeasureSpacing = diff / (float)line.measures.size();
            }
            float measureSpacing = defaultMeasureSpacing;
            for (int i = 0; i < line.measures.size(); ++i) {
                int index = line.measures.get(i);
                TGMeasureImpl currMeasure = (TGMeasureImpl)track.getMeasure(index);
                currMeasure.setPosX(posX);
                currMeasure.setPosY(posY);
                currMeasure.setTs(ts);
                ((TGLyricImpl)track.getLyrics()).setCurrentMeasure(currMeasure);
                currMeasure.setFirstOfLine(i == 0);
                float measureWidth = currMeasure.getWidth(this);
                float measureWidthWithSpacing = this.isBufferEnabled() ? (float)Math.round(measureWidth + measureSpacing) : measureWidth + measureSpacing;
                float measureSpacingAfterRound = measureWidthWithSpacing - measureWidth;
                this.paintMeasure(currMeasure, painter, measureSpacingAfterRound);
                ((TGLyricImpl)track.getLyrics()).paintCurrentNoteBeats(painter, this, currMeasure, posX, posY);
                posX += measureWidthWithSpacing;
                width += measureWidthWithSpacing;
                measureSpacing = defaultMeasureSpacing + (measureSpacing - measureSpacingAfterRound);
            }
            this.setWidth(Math.max(this.getWidth(), width));
        }
    }

    public void fillBackground(TGPainter painter) {
        if (!this.document.isTransparentBackground()) {
            painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
            painter.initPath(2);
            painter.addRectangle(0.0f, 0.0f, this.document.getSize().getWidth(), this.document.getSize().getHeight());
            painter.closePath();
        }
    }

    private void openPage() {
        ++this.page;
        if (this.document.isPaintable(this.page)) {
            this.document.pageStart();
            this.fillBackground(this.document.getPainter());
        }
    }

    private void closePage() {
        if (this.document.isPaintable(this.page)) {
            this.document.pageFinish();
        }
    }

    private float getCenter(TGPainter painter, String text) {
        return (this.getMaxWidth() - painter.getFMWidth(text)) / 2.0f;
    }

    private float getRight(TGPainter painter, String text) {
        return this.getMaxWidth() - painter.getFMWidth(text);
    }

    private float getBottom(TGPainter painter, String text) {
        return this.getMaxHeight() - painter.getFMHeight();
    }

    private TempLine getTempLines(TGTrack track, int fromIndex, TGTrackSpacing ts) {
        TempLine line = new TempLine();
        int measureCount = track.countMeasures();
        for (int measureIdx = fromIndex; measureIdx < measureCount; ++measureIdx) {
            TGMeasureImpl measure = (TGMeasureImpl)track.getMeasure(measureIdx);
            if (measure.getNumber() < this.settings.getFromMeasure() || measure.getNumber() > this.settings.getToMeasure()) continue;
            if (line.tempWith + measure.getWidth(this) >= this.getMaxWidth()) {
                if (line.measures.isEmpty()) {
                    this.addToTempLine(line, ts, measure, measureIdx);
                }
                line.fullLine = true;
                return line;
            }
            this.addToTempLine(line, ts, measure, measureIdx);
        }
        return line;
    }

    private void addToTempLine(TempLine line, TGTrackSpacing ts, TGMeasureImpl measure, int measureIdx) {
        line.tempWith += measure.getWidth(this);
        line.maxY = measure.getMaxY() > line.maxY ? measure.getMaxY() : line.maxY;
        line.minY = measure.getMinY() < line.minY ? measure.getMinY() : line.minY;
        line.addMeasure(measureIdx);
        measure.registerSpacing(this, ts);
    }

    private int getSkippedBeats(TGTrack track) {
        int beats = 0;
        for (int i = 0; i < this.settings.getFromMeasure() - 1; ++i) {
            TGMeasureImpl measure = (TGMeasureImpl)track.getMeasure(i);
            beats += measure.getNotEmptyBeats();
        }
        return beats;
    }

    public boolean isPlayModeEnabled() {
        return false;
    }

    public float getMaxWidth() {
        return this.document.getSize().getWidth() - this.document.getMargins().getLeft() - this.document.getMargins().getRight() - this.getScale();
    }

    public float getMaxHeight() {
        return this.document.getSize().getHeight() - this.document.getMargins().getTop() - this.document.getMargins().getBottom() - this.getScale();
    }

    public boolean isFirstMeasure(TGMeasureHeader mh) {
        return mh.getNumber() == this.settings.getFromMeasure();
    }

    public boolean isLastMeasure(TGMeasureHeader mh) {
        return mh.getNumber() == this.settings.getToMeasure();
    }

    public TGFont getSongNameFont(TGResourceFactory factory) {
        if (factory != null && (this.songNameFont == null || this.songNameFont.isDisposed())) {
            this.songNameFont = factory.createFont(this.getResources().getDefaultFont().getName(), 16.0f * this.getFontScale(), true, false);
        }
        return this.songNameFont;
    }

    public TGFont getSongAuthorFont(TGResourceFactory factory) {
        if (factory != null && (this.songAuthorFont == null || this.songAuthorFont.isDisposed())) {
            this.songAuthorFont = factory.createFont(this.getResources().getDefaultFont().getName(), 8.0f * this.getFontScale(), true, false);
        }
        return this.songAuthorFont;
    }

    public TGFont getTrackNameFont(TGResourceFactory factory) {
        if (factory != null && (this.trackNameFont == null || this.trackNameFont.isDisposed())) {
            this.trackNameFont = factory.createFont(this.getResources().getDefaultFont().getName(), 8.0f * this.getFontScale(), true, false);
        }
        return this.trackNameFont;
    }

    public void disposeLayout() {
        super.disposeLayout();
        if (this.songNameFont != null && !this.songNameFont.isDisposed()) {
            this.songNameFont.dispose();
        }
        if (this.songAuthorFont != null && !this.songAuthorFont.isDisposed()) {
            this.songAuthorFont.dispose();
        }
        if (this.trackNameFont != null && !this.trackNameFont.isDisposed()) {
            this.trackNameFont.dispose();
        }
    }

    private class TempLine {
        protected float tempWith;
        protected int lastIndex;
        protected boolean fullLine;
        protected float maxY = 0.0f;
        protected float minY = 50.0f;
        protected List<Integer> measures = new ArrayList<Integer>();

        public void addMeasure(int index) {
            this.measures.add(new Integer(index));
            this.lastIndex = index;
        }
    }
}

