/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.base;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.List;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatDetector;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGSongPersistenceHelper;
import org.herac.tuxguitar.io.base.TGSongReader;
import org.herac.tuxguitar.io.base.TGSongReaderHandle;
import org.herac.tuxguitar.util.TGContext;

public class TGSongReaderHelper
extends TGSongPersistenceHelper {
    public TGSongReaderHelper(TGContext context) {
        super(context);
    }

    public void read(TGSongReaderHandle handle) throws TGFileFormatException {
        try {
            TGSongReader reader;
            boolean success = false;
            handle.setInputStream(new BufferedInputStream(handle.getInputStream()));
            if (handle.getFormat() == null) {
                handle.setFormat(this.detectFileFormat(handle));
            }
            if (handle.getFormat() != null && (reader = TGFileFormatManager.getInstance(this.getContext()).findSongReader(handle.getFormat())) != null) {
                reader.read(handle);
                success = true;
            }
            if (!success) {
                throw new TGFileFormatException("Unsupported file format");
            }
        }
        catch (TGFileFormatException tgFileFormatException) {
            throw tgFileFormatException;
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
        finally {
            try {
                handle.getInputStream().close();
            }
            catch (IOException e) {
                throw new TGFileFormatException(e);
            }
        }
    }

    public TGFileFormat detectFileFormat(TGSongReaderHandle handle) throws IOException {
        TGFileFormat fileFormat;
        TGFileFormat fileFormat2;
        handle.getInputStream().mark(1);
        TGFileFormatManager fileFormatManager = TGFileFormatManager.getInstance(this.getContext());
        List<TGFileFormatDetector> detectors = fileFormatManager.getFileFormatDetectors();
        for (TGFileFormatDetector detector : detectors) {
            fileFormat2 = detector.getFileFormat(handle.getInputStream());
            handle.getInputStream().reset();
            if (fileFormat2 == null) continue;
            return fileFormat2;
        }
        String mimeType = (String)handle.getContext().getAttribute("mimeType");
        if (mimeType != null && (fileFormat = fileFormatManager.findReaderFileFormatByMimeType(mimeType)) != null) {
            return fileFormat;
        }
        String formatCode = (String)handle.getContext().getAttribute("formatCode");
        if (formatCode != null && (fileFormat2 = fileFormatManager.findReaderFileFormatByCode(formatCode)) != null) {
            return fileFormat2;
        }
        return null;
    }
}

