/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.event.TGEventManager;
import org.herac.tuxguitar.player.base.MidiChannel;
import org.herac.tuxguitar.player.base.MidiChannelRouter;
import org.herac.tuxguitar.player.base.MidiInstrument;
import org.herac.tuxguitar.player.base.MidiOutputPort;
import org.herac.tuxguitar.player.base.MidiOutputPortProvider;
import org.herac.tuxguitar.player.base.MidiPercussionKey;
import org.herac.tuxguitar.player.base.MidiPlayerCountDown;
import org.herac.tuxguitar.player.base.MidiPlayerEvent;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiPlayerMode;
import org.herac.tuxguitar.player.base.MidiSequenceParser;
import org.herac.tuxguitar.player.base.MidiSequencer;
import org.herac.tuxguitar.player.base.MidiSequencerEmpty;
import org.herac.tuxguitar.player.base.MidiSequencerProvider;
import org.herac.tuxguitar.player.base.MidiSynthesizerProxy;
import org.herac.tuxguitar.player.base.MidiTransmitter;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelParameter;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.thread.TGThreadLoop;
import org.herac.tuxguitar.thread.TGThreadManager;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGLock;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiPlayer {
    public static final int MAX_VOLUME = 10;
    private static final long TIMER_DELAY = 10L;
    private TGContext context;
    private TGDocumentManager documentManager;
    private MidiSequencer sequencer;
    private MidiSynthesizerProxy synthesizerProxy;
    private MidiChannelRouter channelRouter;
    private MidiTransmitter outputTransmitter;
    private MidiOutputPort outputPort;
    private MidiPlayerMode mode;
    private MidiPlayerCountDown countDown;
    private String sequencerKey;
    private String outputPortKey;
    private List<MidiOutputPortProvider> outputPortProviders;
    private List<MidiSequencerProvider> sequencerProviders;
    private int volume;
    private boolean running;
    private boolean paused;
    private boolean changeTickPosition;
    private boolean metronomeEnabled;
    private int metronomeTrack;
    private int infoTrack;
    private int loopSHeader;
    private int loopEHeader;
    private long loopSPosition;
    private boolean anySolo;
    protected long tickLength;
    protected long tickPosition;
    private boolean tryOpenFistDevice;
    protected TGLock lock;

    private MidiPlayer(TGContext context) {
        this.context = context;
        this.lock = new TGLock(context);
        this.volume = 10;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void init(TGDocumentManager documentManager) {
        try {
            this.lock();
            this.documentManager = documentManager;
            this.outputPortProviders = new ArrayList<MidiOutputPortProvider>();
            this.sequencerProviders = new ArrayList<MidiSequencerProvider>();
            this.tryOpenFistDevice = false;
            this.getSequencer();
            this.getMode();
            this.reset();
        }
        finally {
            this.unlock();
        }
    }

    public void reset() {
        try {
            this.lock();
            this.stop();
            this.tickPosition = 960L;
            this.setChangeTickPosition(false);
        }
        finally {
            this.unlock();
        }
    }

    public void close() {
        try {
            this.lock();
            this.closeSequencer();
            this.closeOutputPort();
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    public void stopSequencer() {
        try {
            this.lock();
            if (this.getSequencer().isRunning()) {
                this.getSequencer().stop();
            }
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    public void stop(boolean paused) {
        try {
            this.lock();
            this.setPaused(paused);
            this.stopSequencer();
            this.setRunning(false);
        }
        finally {
            this.unlock();
        }
    }

    public void stop() {
        try {
            this.lock();
            this.stop(false);
        }
        finally {
            this.unlock();
        }
    }

    public void pause() {
        try {
            this.lock();
            this.stop(true);
        }
        finally {
            this.unlock();
        }
    }

    public synchronized void play() throws MidiPlayerException {
        try {
            this.lock();
            final boolean notifyStarted = !this.isRunning();
            this.setRunning(true);
            this.stopSequencer();
            this.checkDevices();
            this.updateLoop(true);
            this.addSequence();
            this.updateTracks();
            this.updateChannels();
            this.setMetronomeEnabled(this.isMetronomeEnabled());
            this.getCountDown().setTempoPercent(this.getMode().getCurrentPercent());
            this.changeTickPosition();
            TGThreadManager.getInstance(this.context).start(new Runnable(){

                public void run() {
                    MidiPlayer.this.runPlayStartProcess(notifyStarted);
                }
            });
        }
        catch (Throwable throwable) {
            this.reset();
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
        finally {
            this.unlock();
        }
    }

    public void runPlayStartProcess(boolean notifyStarted) {
        try {
            if (notifyStarted) {
                this.notifyStarted();
            }
            if (this.getCountDown().isEnabled()) {
                this.notifyCountDownStarted();
                this.getCountDown().start();
                this.notifyCountDownStopped();
            }
            try {
                this.lock();
                if (this.isRunning()) {
                    if (this.isChangeTickPosition()) {
                        this.changeTickPosition();
                    }
                    this.getSequencer().start();
                }
                this.tickLength = this.getSequencer().getTickLength();
                this.tickPosition = this.getSequencer().getTickPosition();
            }
            finally {
                this.unlock();
            }
            this.runPlayLoop();
        }
        catch (Throwable throwable) {
            this.reset();
            throwable.printStackTrace();
        }
    }

    public void runPlayLoop() {
        TGThreadManager.getInstance(this.context).loop(new TGThreadLoop(){

            public Long process() {
                return MidiPlayer.this.runPlayLoopProcess() ? 10L : BREAK;
            }
        });
    }

    public boolean runPlayLoopProcess() {
        try {
            if (this.getSequencer().isRunning() && this.isRunning()) {
                try {
                    this.lock();
                    if (this.isChangeTickPosition()) {
                        this.changeTickPosition();
                    }
                    this.tickPosition = this.getSequencer().getTickPosition();
                }
                finally {
                    this.unlock();
                }
                return true;
            }
            this.runPlayEndProcess();
        }
        catch (Throwable throwable) {
            this.reset();
            throwable.printStackTrace();
        }
        return false;
    }

    public void runPlayEndProcess() {
        try {
            try {
                this.lock();
                if (this.isRunning()) {
                    if (this.tickPosition >= this.tickLength - 480L) {
                        this.finish();
                    } else {
                        this.stop(this.isPaused());
                    }
                }
                if (!this.isRunning()) {
                    this.notifyStopped();
                }
            }
            finally {
                this.unlock();
            }
        }
        catch (Throwable throwable) {
            this.reset();
            throwable.printStackTrace();
        }
    }

    private void finish() throws MidiPlayerException {
        try {
            this.lock();
            if (this.getMode().isLoop()) {
                this.stopSequencer();
                this.setTickPosition(960L);
                this.getMode().notifyLoop();
                this.notifyLoop();
                this.play();
                return;
            }
            this.reset();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLoop(boolean force) {
        try {
            this.lock();
            if (force || !this.isRunning()) {
                this.loopSHeader = -1;
                this.loopEHeader = -1;
                this.loopSPosition = 960L;
                if (this.getMode().isLoop()) {
                    TGMeasureHeader header;
                    int hCount = this.getSong().countMeasureHeaders();
                    this.loopSHeader = this.getMode().getLoopSHeader() <= hCount ? this.getMode().getLoopSHeader() : -1;
                    int n = this.loopEHeader = this.getMode().getLoopEHeader() <= hCount ? this.getMode().getLoopEHeader() : -1;
                    if (this.loopSHeader > 0 && this.loopSHeader <= hCount && (header = this.getSongManager().getMeasureHeader(this.getSong(), this.loopSHeader)) != null) {
                        this.loopSPosition = header.getStart();
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    public void checkDevices() throws Throwable {
        try {
            this.lock();
            this.getSequencer().check();
            if (this.getOutputPort() != null) {
                this.getOutputPort().check();
            }
        }
        finally {
            this.unlock();
        }
    }

    public int getVolume() {
        try {
            this.lock();
            int n = this.volume;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public void setVolume(int volume) {
        try {
            this.lock();
            this.volume = volume;
            if (this.isRunning()) {
                this.updateChannels();
            }
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    public void setRunning(boolean running) {
        try {
            this.lock();
            this.running = running;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isRunning() {
        try {
            this.lock();
            boolean bl = this.running || this.getSequencer().isRunning();
            return bl;
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
        return false;
    }

    public boolean isPaused() {
        try {
            this.lock();
            boolean bl = this.paused;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public void setPaused(boolean paused) {
        try {
            this.lock();
            this.paused = paused;
        }
        finally {
            this.unlock();
        }
    }

    protected boolean isChangeTickPosition() {
        try {
            this.lock();
            boolean bl = this.changeTickPosition;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    private void setChangeTickPosition(boolean changeTickPosition) {
        try {
            this.lock();
            this.changeTickPosition = changeTickPosition;
        }
        finally {
            this.unlock();
        }
    }

    public void setTickPosition(long position) {
        try {
            this.lock();
            this.tickPosition = position;
            this.setChangeTickPosition(true);
        }
        finally {
            this.unlock();
        }
    }

    public long getTickPosition() {
        try {
            this.lock();
            long l = this.tickPosition;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    protected void changeTickPosition() {
        try {
            this.lock();
            if (this.isRunning()) {
                if (this.tickPosition < this.getLoopSPosition()) {
                    this.tickPosition = this.getLoopSPosition();
                }
                this.getSequencer().setTickPosition(this.tickPosition);
            }
            this.setChangeTickPosition(false);
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    public void addSequence() {
        try {
            this.lock();
            MidiSequenceParser midiSequenceParser = new MidiSequenceParser(this.documentManager.getSong(), this.documentManager.getSongManager(), 4);
            midiSequenceParser.setTempoPercent(this.getMode().getCurrentPercent());
            midiSequenceParser.setSHeader(this.getLoopSHeader());
            midiSequenceParser.setEHeader(this.getLoopEHeader());
            midiSequenceParser.setMetronomeChannelId(this.getPercussionChannelId());
            midiSequenceParser.parse(this.getSequencer().createSequence(this.getSong().countTracks() + 2));
            this.infoTrack = midiSequenceParser.getInfoTrack();
            this.metronomeTrack = midiSequenceParser.getMetronomeTrack();
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    public void resetChannels() {
        try {
            this.lock();
            this.closeChannels();
            this.updateChannels();
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    public void closeChannels() throws MidiPlayerException {
        try {
            this.lock();
            for (int channelId : this.getChannelRouter().getMidiChannelIds()) {
                this.getSynthesizerProxy().closeChannel(this.getChannelRouter().getMidiChannel(channelId));
                this.getChannelRouter().removeMidiChannel(channelId);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChannels() throws MidiPlayerException {
        try {
            this.lock();
            List<Integer> oldChannelIds = this.getChannelRouter().getMidiChannelIds();
            for (int channelId : oldChannelIds) {
                MidiChannel midiChannel;
                boolean removableChannel;
                boolean bl = removableChannel = this.getSongManager().getChannel(this.getSong(), channelId) == null;
                if (!removableChannel && (midiChannel = this.getChannelRouter().getMidiChannel(channelId)) != null) {
                    boolean bl2 = removableChannel = !this.getSynthesizerProxy().isChannelOpen(midiChannel);
                }
                if (!removableChannel) continue;
                this.getSynthesizerProxy().closeChannel(this.getChannelRouter().getMidiChannel(channelId));
                this.getChannelRouter().removeMidiChannel(channelId);
            }
            List<Integer> newChannelIds = this.getChannelRouter().getMidiChannelIds();
            Iterator<TGChannel> tgChannels = this.getSong().getChannels();
            while (tgChannels.hasNext()) {
                MidiChannel midiChannel;
                TGChannel tgChannel = tgChannels.next();
                if (newChannelIds.contains(new Integer(tgChannel.getChannelId())) || (midiChannel = this.getSynthesizerProxy().openChannel(tgChannel.getChannelId())) == null) continue;
                this.getChannelRouter().addMidiChannel(tgChannel.getChannelId(), midiChannel);
            }
            tgChannels = this.getSong().getChannels();
            while (tgChannels.hasNext()) {
                this.updateChannel(tgChannels.next());
            }
        }
        finally {
            this.unlock();
        }
    }

    public void updateChannel(TGChannel channel) {
        try {
            this.lock();
            this.updateParameters(channel);
            this.updateProgram(channel);
            this.updateController(channel);
            this.updateDefaultControllers(channel);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateParameters(TGChannel tgChannel) {
        try {
            this.lock();
            this.updateParameter(tgChannel, "sendingParams", Boolean.TRUE.toString());
            Iterator<TGChannelParameter> parameters = tgChannel.getParameters();
            while (parameters.hasNext()) {
                TGChannelParameter tgChannelParameter = parameters.next();
                this.updateParameter(tgChannel, tgChannelParameter.getKey(), tgChannelParameter.getValue());
            }
            this.updateParameter(tgChannel, "sendingParams", Boolean.FALSE.toString());
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateParameter(TGChannel tgChannel, String key, String value) {
        try {
            this.lock();
            this.getOutputTransmitter().sendParameter(tgChannel.getChannelId(), key, value);
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    private void updateProgram(TGChannel channel) {
        try {
            this.lock();
            this.updateProgram(channel.getChannelId(), channel.getBank(), channel.getProgram());
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProgram(int channelId, int bank, int program) {
        try {
            this.lock();
            if (bank >= 0 && bank <= 128) {
                this.getOutputTransmitter().sendControlChange(channelId, 0, bank);
            }
            if (program >= 0 && program <= 127) {
                this.getOutputTransmitter().sendProgramChange(channelId, program);
            }
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateController(TGChannel channel) {
        try {
            this.lock();
            int volume = (int)((double)this.getVolume() / 10.0 * (double)channel.getVolume());
            short balance = channel.getBalance();
            short chorus = channel.getChorus();
            short reverb = channel.getReverb();
            short phaser = channel.getPhaser();
            short tremolo = channel.getTremolo();
            this.updateController(channel.getChannelId(), volume, balance, chorus, reverb, phaser, tremolo, 127);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateController(int channelId, int volume, int balance, int chorus, int reverb, int phaser, int tremolo, int expression) {
        try {
            this.lock();
            this.getOutputTransmitter().sendControlChange(channelId, 7, volume);
            this.getOutputTransmitter().sendControlChange(channelId, 10, balance);
            this.getOutputTransmitter().sendControlChange(channelId, 93, chorus);
            this.getOutputTransmitter().sendControlChange(channelId, 91, reverb);
            this.getOutputTransmitter().sendControlChange(channelId, 95, phaser);
            this.getOutputTransmitter().sendControlChange(channelId, 92, tremolo);
            this.getOutputTransmitter().sendControlChange(channelId, 11, expression);
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    private void updateDefaultControllers(TGChannel tgChannel) {
        try {
            this.lock();
            this.getOutputTransmitter().sendControlChange(tgChannel.getChannelId(), 101, 0);
            this.getOutputTransmitter().sendControlChange(tgChannel.getChannelId(), 100, 0);
            this.getOutputTransmitter().sendControlChange(tgChannel.getChannelId(), 6, 12);
            this.getOutputTransmitter().sendControlChange(tgChannel.getChannelId(), 38, 0);
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    public void updateTracks() {
        try {
            this.lock();
            this.anySolo = false;
            Iterator<TGTrack> tracksIt = this.getSong().getTracks();
            while (tracksIt.hasNext()) {
                TGTrack track = tracksIt.next();
                this.updateTrack(track);
                this.anySolo = !this.anySolo ? track.isSolo() : this.anySolo;
            }
            this.afterUpdate();
        }
        finally {
            this.unlock();
        }
    }

    private void updateTrack(TGTrack track) {
        try {
            this.lock();
            this.getSequencer().setMute(track.getNumber(), track.isMute());
            this.getSequencer().setSolo(track.getNumber(), track.isSolo());
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    private void afterUpdate() {
        try {
            this.lock();
            this.getSequencer().setSolo(this.infoTrack, this.anySolo);
            this.getSequencer().setSolo(this.metronomeTrack, this.isMetronomeEnabled() && this.anySolo);
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    public boolean isMetronomeEnabled() {
        return this.metronomeEnabled;
    }

    public void setMetronomeEnabled(boolean metronomeEnabled) {
        try {
            this.lock();
            this.metronomeEnabled = metronomeEnabled;
            this.getSequencer().setMute(this.metronomeTrack, !this.isMetronomeEnabled());
            this.getSequencer().setSolo(this.metronomeTrack, this.isMetronomeEnabled() && this.anySolo);
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playBeat(TGBeat beat) {
        try {
            this.lock();
            ArrayList<TGNote> notes = new ArrayList<TGNote>();
            for (int v = 0; v < beat.countVoices(); ++v) {
                notes.addAll(beat.getVoice(v).getNotes());
            }
            this.playBeat(beat.getMeasure().getTrack(), notes);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playBeat(TGTrack track, List<TGNote> notes) {
        try {
            this.lock();
            TGChannel tgChannel = this.getSongManager().getChannel(this.getSong(), track.getChannelId());
            if (tgChannel != null) {
                final int channelId = tgChannel.getChannelId();
                final short bank = tgChannel.getBank();
                final short program = tgChannel.getProgram();
                final int volume = (int)((double)this.getVolume() / 10.0 * (double)tgChannel.getVolume());
                final short balance = tgChannel.getBalance();
                final short chorus = tgChannel.getChorus();
                final short reverb = tgChannel.getReverb();
                final short phaser = tgChannel.getPhaser();
                final short tremolo = tgChannel.getTremolo();
                int size = notes.size();
                final int[][] beat = new int[size][2];
                for (int i = 0; i < size; ++i) {
                    TGNote note = notes.get(i);
                    beat[i][0] = track.getOffset() + (note.getValue() + track.getStrings().get(note.getString() - 1).getValue());
                    beat[i][1] = note.getVelocity();
                }
                TGThreadManager.getInstance(this.context).start(new Runnable(){

                    public void run() {
                        MidiPlayer.this.playBeat(channelId, bank, program, volume, balance, chorus, reverb, phaser, tremolo, beat);
                    }
                });
            }
        }
        finally {
            this.unlock();
        }
    }

    public void playBeat(int channelId, int bank, int program, int volume, int balance, int chorus, int reverb, int phaser, int tremolo, int[][] beat) {
        this.playBeat(channelId, bank, program, volume, balance, chorus, reverb, phaser, tremolo, beat, 500L, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playBeat(int channelId, int bank, int program, int volume, int balance, int chorus, int reverb, int phaser, int tremolo, int[][] beat, long duration, int interval) {
        try {
            this.updateChannels();
            Object sync = new Object();
            for (int i = 0; i < beat.length; ++i) {
                this.getOutputTransmitter().sendNoteOn(channelId, beat[i][0], beat[i][1], -1, false);
                if (interval <= 0) continue;
                Object object = sync;
                synchronized (object) {
                    sync.wait(interval);
                    continue;
                }
            }
            Object i = sync;
            synchronized (i) {
                sync.wait(duration);
            }
            for (int i2 = 0; i2 < beat.length; ++i2) {
                this.getOutputTransmitter().sendNoteOff(channelId, beat[i2][0], beat[i2][1], -1, false);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPercussionChannelId() {
        try {
            this.lock();
            Iterator<TGChannel> tgChannels = this.getSong().getChannels();
            while (tgChannels.hasNext()) {
                TGChannel tgChannel = tgChannels.next();
                if (!tgChannel.isPercussionChannel()) continue;
                int n = tgChannel.getChannelId();
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSequencer(MidiSequencer sequencer) {
        try {
            this.lock();
            this.closeSequencer();
            this.sequencer = sequencer;
            this.sequencer.open();
            this.sequencer.setTransmitter(this.getOutputTransmitter());
        }
        catch (Throwable throwable) {
            this.sequencer = null;
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadOutputPort(MidiOutputPort port) {
        try {
            this.lock();
            this.closeOutputPort();
            this.outputPort = port;
            this.outputPort.open();
            this.getSynthesizerProxy().setMidiSynthesizer(this.outputPort.getSynthesizer());
        }
        catch (Throwable throwable) {
            this.outputPort = null;
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
        return true;
    }

    public void openOutputPort(String key) {
        try {
            this.lock();
            this.openOutputPort(key, false);
        }
        finally {
            this.unlock();
        }
    }

    public void openOutputPort(String key, boolean tryFirst) {
        try {
            this.lock();
            this.outputPortKey = key;
            this.openOutputPort(this.listOutputPorts(), tryFirst);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openOutputPort(List<MidiOutputPort> ports, boolean tryFirst) {
        try {
            this.lock();
            if (this.outputPortKey != null && !this.isOutputPortOpen(this.outputPortKey)) {
                this.closeOutputPort();
                for (int i = 0; i < ports.size(); ++i) {
                    MidiOutputPort port = ports.get(i);
                    if (!port.getKey().equals(this.outputPortKey) || !this.loadOutputPort(port)) continue;
                    return;
                }
            }
            if (this.getOutputPort() == null && !ports.isEmpty() && tryFirst) {
                this.loadOutputPort(ports.get(0));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    public void openSequencer(String key) {
        try {
            this.lock();
            this.openSequencer(key, false);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSequencer(String key, boolean tryFirst) {
        try {
            this.lock();
            this.sequencerKey = key;
            this.openSequencer(this.listSequencers(), tryFirst);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    public void openSequencer(List<MidiSequencer> sequencers, boolean tryFirst) throws MidiPlayerException {
        try {
            this.lock();
            if (this.sequencerKey != null && !this.isSequencerOpen(this.sequencerKey)) {
                this.closeSequencer();
                for (int i = 0; i < sequencers.size(); ++i) {
                    MidiSequencer sequencer = sequencers.get(i);
                    if (!sequencer.getKey().equals(this.sequencerKey) || !this.loadSequencer(sequencer)) continue;
                    return;
                }
            }
            if (this.getSequencer() instanceof MidiSequencerEmpty && !sequencers.isEmpty() && tryFirst) {
                this.loadSequencer(sequencers.get(0));
            }
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MidiOutputPort> listOutputPorts() {
        try {
            this.lock();
            ArrayList<MidiOutputPort> ports = new ArrayList<MidiOutputPort>();
            Iterator<MidiOutputPortProvider> it = this.outputPortProviders.iterator();
            while (it.hasNext()) {
                try {
                    MidiOutputPortProvider provider = it.next();
                    ports.addAll(provider.listPorts());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            ArrayList<MidiOutputPort> arrayList = ports;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MidiSequencer> listSequencers() {
        try {
            this.lock();
            ArrayList<MidiSequencer> sequencers = new ArrayList<MidiSequencer>();
            Iterator<MidiSequencerProvider> it = this.sequencerProviders.iterator();
            while (it.hasNext()) {
                try {
                    MidiSequencerProvider provider = it.next();
                    sequencers.addAll(provider.listSequencers());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            ArrayList<MidiSequencer> arrayList = sequencers;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    public void closeSequencer() throws MidiPlayerException {
        try {
            this.lock();
            if (this.isRunning()) {
                this.stop();
            }
            if (this.sequencer != null) {
                this.sequencer.close();
                this.sequencer = null;
            }
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
        finally {
            this.unlock();
        }
    }

    public void closeOutputPort() {
        try {
            this.lock();
            if (this.isRunning()) {
                this.stop();
            }
            if (this.outputPort != null) {
                this.closeChannels();
                this.getSynthesizerProxy().setMidiSynthesizer(null);
                this.outputPort.close();
                this.outputPort = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSequencerOpen(String key) {
        try {
            this.lock();
            if (key != null) {
                String currentKey = this.getSequencer().getKey();
                if (currentKey == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = currentKey.equals(key);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutputPortOpen(String key) {
        try {
            this.lock();
            if (key != null && this.getOutputPort() != null) {
                String currentKey = this.getOutputPort().getKey();
                if (currentKey == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = currentKey.equals(key);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public void addOutputPortProvider(MidiOutputPortProvider provider) throws MidiPlayerException {
        try {
            this.lock();
            this.addOutputPortProvider(provider, this.isTryOpenFistDevice());
        }
        finally {
            this.unlock();
        }
    }

    public void addOutputPortProvider(MidiOutputPortProvider provider, boolean tryFirst) throws MidiPlayerException {
        try {
            this.lock();
            this.outputPortProviders.add(provider);
            this.openOutputPort(provider.listPorts(), tryFirst);
        }
        finally {
            this.unlock();
        }
    }

    public void addSequencerProvider(MidiSequencerProvider provider) throws MidiPlayerException {
        try {
            this.lock();
            this.addSequencerProvider(provider, this.isTryOpenFistDevice());
        }
        finally {
            this.unlock();
        }
    }

    public void addSequencerProvider(MidiSequencerProvider provider, boolean tryFirst) throws MidiPlayerException {
        try {
            this.lock();
            this.sequencerProviders.add(provider);
            this.openSequencer(provider.listSequencers(), tryFirst);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputPortProvider(MidiOutputPortProvider provider) throws MidiPlayerException {
        block4: {
            try {
                this.lock();
                this.outputPortProviders.remove(provider);
                MidiOutputPort current = this.getOutputPort();
                if (current == null) break block4;
                for (MidiOutputPort port : provider.listPorts()) {
                    if (!port.getKey().equals(current.getKey())) continue;
                    this.closeOutputPort();
                    break;
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSequencerProvider(MidiSequencerProvider provider) throws MidiPlayerException {
        block4: {
            try {
                this.lock();
                this.sequencerProviders.remove(provider);
                MidiSequencer current = this.getSequencer();
                if (current instanceof MidiSequencerEmpty || current == null) break block4;
                for (MidiSequencer sequencer : provider.listSequencers()) {
                    if (!current.getKey().equals(sequencer.getKey())) continue;
                    this.closeSequencer();
                    break;
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    public void addListener(TGEventListener listener) {
        TGEventManager.getInstance(this.context).addListener("midi-player-notification", listener);
    }

    public void removeListener(TGEventListener listener) {
        TGEventManager.getInstance(this.context).removeListener("midi-player-notification", listener);
    }

    public void notifyStarted() {
        TGEventManager.getInstance(this.context).fireEvent(new MidiPlayerEvent(1));
    }

    public void notifyStopped() {
        TGEventManager.getInstance(this.context).fireEvent(new MidiPlayerEvent(2));
    }

    public void notifyCountDownStarted() {
        TGEventManager.getInstance(this.context).fireEvent(new MidiPlayerEvent(3));
    }

    public void notifyCountDownStopped() {
        TGEventManager.getInstance(this.context).fireEvent(new MidiPlayerEvent(4));
    }

    public void notifyLoop() {
        TGEventManager.getInstance(this.context).fireEvent(new MidiPlayerEvent(5));
    }

    public MidiInstrument[] getInstruments() {
        return MidiInstrument.INSTRUMENT_LIST;
    }

    public MidiPercussionKey[] getPercussionKeys() {
        return MidiPercussionKey.PERCUSSION_KEY_LIST;
    }

    public int getLoopSHeader() {
        return this.loopSHeader;
    }

    public int getLoopEHeader() {
        return this.loopEHeader;
    }

    public long getLoopSPosition() {
        return this.loopSPosition;
    }

    public boolean isTryOpenFistDevice() {
        return this.tryOpenFistDevice;
    }

    public void setTryOpenFistDevice(boolean tryOpenFistDevice) {
        this.tryOpenFistDevice = tryOpenFistDevice;
    }

    public TGSongManager getSongManager() {
        return this.documentManager.getSongManager();
    }

    public TGSong getSong() {
        return this.documentManager.getSong();
    }

    public MidiPlayerMode getMode() {
        if (this.mode == null) {
            this.mode = new MidiPlayerMode();
        }
        return this.mode;
    }

    public MidiPlayerCountDown getCountDown() {
        if (this.countDown == null) {
            this.countDown = new MidiPlayerCountDown(this);
        }
        return this.countDown;
    }

    public MidiTransmitter getOutputTransmitter() {
        if (this.outputTransmitter == null) {
            this.outputTransmitter = new MidiTransmitter();
            this.outputTransmitter.addReceiver(this.getChannelRouter().getId(), this.getChannelRouter());
        }
        return this.outputTransmitter;
    }

    public MidiOutputPort getOutputPort() {
        return this.outputPort;
    }

    public MidiChannelRouter getChannelRouter() {
        if (this.channelRouter == null) {
            this.channelRouter = new MidiChannelRouter();
        }
        return this.channelRouter;
    }

    public MidiSynthesizerProxy getSynthesizerProxy() {
        if (this.synthesizerProxy == null) {
            this.synthesizerProxy = new MidiSynthesizerProxy();
        }
        return this.synthesizerProxy;
    }

    public MidiSequencer getSequencer() {
        if (this.sequencer == null) {
            this.sequencer = new MidiSequencerEmpty();
        }
        return this.sequencer;
    }

    public static MidiPlayer getInstance(TGContext context) {
        return TGSingletonUtil.getInstance(context, MidiPlayer.class.getName(), new TGSingletonFactory<MidiPlayer>(){

            @Override
            public MidiPlayer createInstance(TGContext context) {
                return new MidiPlayer(context);
            }
        });
    }
}

