/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.sequencer;

import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.impl.sequencer.MidiEvent;
import org.herac.tuxguitar.player.impl.sequencer.MidiSequencerImpl;

public class MidiEventDispacher {
    private MidiSequencerImpl sequencer;

    public MidiEventDispacher(MidiSequencerImpl sequencer) {
        this.sequencer = sequencer;
    }

    public void dispatch(MidiEvent event) throws MidiPlayerException {
        if (event.getType() == 2) {
            this.sequencer.getTransmitter().sendNoteOn(event.getData()[0], event.getData()[1], event.getData()[2], event.getData()[3], event.getData()[4] == 1);
        } else if (event.getType() == 3) {
            this.sequencer.getTransmitter().sendNoteOff(event.getData()[0], event.getData()[1], event.getData()[2], event.getData()[3], event.getData()[4] == 1);
        } else if (event.getType() == 6) {
            this.sequencer.getTransmitter().sendPitchBend(event.getData()[0], event.getData()[1], event.getData()[2], event.getData()[3] == 1);
        } else if (event.getType() == 5) {
            this.sequencer.getTransmitter().sendControlChange(event.getData()[0], event.getData()[1], event.getData()[2]);
        } else if (event.getType() == 4) {
            this.sequencer.getTransmitter().sendProgramChange(event.getData()[0], event.getData()[1]);
        } else if (event.getType() == 1 && event.getData()[0] == 81) {
            int usq = event.getData()[1] & 0xFF | (event.getData()[2] & 0xFF) << 8 | (event.getData()[3] & 0xFF) << 16;
            this.sequencer.setTempo((int)(60000.0 / ((double)usq / 1000.0)));
        }
    }
}

