/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGDivisionType;

public abstract class TGDuration {
    public static final long QUARTER_TIME = 960L;
    public static final int WHOLE = 1;
    public static final int HALF = 2;
    public static final int QUARTER = 4;
    public static final int EIGHTH = 8;
    public static final int SIXTEENTH = 16;
    public static final int THIRTY_SECOND = 32;
    public static final int SIXTY_FOURTH = 64;
    private int value = 4;
    private boolean dotted = false;
    private boolean doubleDotted = false;
    private TGDivisionType divisionType;

    public TGDuration(TGFactory factory) {
        this.divisionType = factory.newDivisionType();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public boolean isDotted() {
        return this.dotted;
    }

    public void setDotted(boolean dotted) {
        this.dotted = dotted;
    }

    public boolean isDoubleDotted() {
        return this.doubleDotted;
    }

    public void setDoubleDotted(boolean doubleDotted) {
        this.doubleDotted = doubleDotted;
    }

    public TGDivisionType getDivision() {
        return this.divisionType;
    }

    public long getTime() {
        long time = (long)(960.0f * (4.0f / (float)this.value));
        if (this.dotted) {
            time += time / 2L;
        } else if (this.doubleDotted) {
            time += time / 4L * 3L;
        }
        return this.divisionType.convertTime(time);
    }

    public static TGDuration fromTime(TGFactory factory, long time) {
        TGDuration duration = factory.newDuration();
        duration.setValue(64);
        duration.setDotted(false);
        duration.setDoubleDotted(false);
        duration.getDivision().setEnters(3);
        duration.getDivision().setTimes(2);
        return TGDuration.fromTime(factory, time, duration);
    }

    public static TGDuration fromTime(TGFactory factory, long time, TGDuration minDuration) {
        return TGDuration.fromTime(factory, time, minDuration, 10);
    }

    public static TGDuration fromTime(TGFactory factory, long time, TGDuration minimum, int diff) {
        TGDuration duration = minimum.clone(factory);
        TGDuration tmpDuration = factory.newDuration();
        tmpDuration.setValue(1);
        tmpDuration.setDotted(true);
        boolean finish = false;
        while (!finish) {
            long tmpTime = tmpDuration.getTime();
            if (tmpTime - (long)diff <= time && Math.abs(tmpTime - time) < Math.abs(duration.getTime() - time)) {
                duration = tmpDuration.clone(factory);
            }
            if (tmpDuration.isDotted()) {
                tmpDuration.setDotted(false);
            } else if (tmpDuration.getDivision().isEqual(TGDivisionType.NORMAL)) {
                tmpDuration.getDivision().setEnters(3);
                tmpDuration.getDivision().setTimes(2);
            } else {
                tmpDuration.setValue(tmpDuration.getValue() * 2);
                tmpDuration.setDotted(true);
                tmpDuration.getDivision().setEnters(1);
                tmpDuration.getDivision().setTimes(1);
            }
            if (tmpDuration.getValue() <= 64) continue;
            finish = true;
        }
        return duration;
    }

    public int getIndex() {
        int index = 0;
        int value = this.value;
        while ((value >>= 1) > 0) {
            ++index;
        }
        return index;
    }

    public boolean isEqual(TGDuration d) {
        return this.getValue() == d.getValue() && this.isDotted() == d.isDotted() && this.isDoubleDotted() == d.isDoubleDotted() && this.getDivision().isEqual(d.getDivision());
    }

    public TGDuration clone(TGFactory factory) {
        TGDuration tgDuration = factory.newDuration();
        tgDuration.copyFrom(this);
        return tgDuration;
    }

    public void copyFrom(TGDuration duration) {
        this.setValue(duration.getValue());
        this.setDotted(duration.isDotted());
        this.setDoubleDotted(duration.isDoubleDotted());
        this.getDivision().copyFrom(duration.getDivision());
    }
}

