/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.thread;

import org.herac.tuxguitar.thread.TGThreadHandler;
import org.herac.tuxguitar.thread.TGThreadLoop;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGThreadManager
implements TGThreadHandler {
    private TGThreadHandler handler;

    private TGThreadManager() {
    }

    public void start(Runnable runnable) {
        if (this.handler != null) {
            this.handler.start(runnable);
        }
    }

    public void loop(TGThreadLoop loop) {
        if (this.handler != null) {
            this.handler.loop(loop);
        }
    }

    public void yield() {
        if (this.handler != null) {
            this.handler.yield();
        }
    }

    public Object getThreadId() {
        if (this.handler != null) {
            return this.handler.getThreadId();
        }
        return null;
    }

    public TGThreadHandler getThreadHandler() {
        return this.handler;
    }

    public void setThreadHandler(TGThreadHandler handler) {
        this.handler = handler;
    }

    public static TGThreadManager getInstance(TGContext context) {
        return TGSingletonUtil.getInstance(context, TGThreadManager.class.getName(), new TGSingletonFactory<TGThreadManager>(){

            @Override
            public TGThreadManager createInstance(TGContext context) {
                return new TGThreadManager();
            }
        });
    }
}

