/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.ExecuteListener;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.StatementType;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import java.sql.SQLException;
import java.util.List;

public class CachingStatement
implements MappedStatement {
    private MappedStatement statement;
    private CacheModel cacheModel;

    public CachingStatement(MappedStatement statement, CacheModel cacheModel) {
        this.statement = statement;
        this.cacheModel = cacheModel;
    }

    public String getId() {
        return this.statement.getId();
    }

    public StatementType getStatementType() {
        return this.statement.getStatementType();
    }

    public Integer getResultSetType() {
        return this.statement.getResultSetType();
    }

    public Integer getFetchSize() {
        return this.statement.getFetchSize();
    }

    public ParameterMap getParameterMap() {
        return this.statement.getParameterMap();
    }

    public ResultMap getResultMap() {
        return this.statement.getResultMap();
    }

    public int executeUpdate(RequestScope request, Transaction trans, Object parameterObject) throws SQLException {
        int n = this.statement.executeUpdate(request, trans, parameterObject);
        return n;
    }

    public Object executeQueryForObject(RequestScope request, Transaction trans, Object parameterObject, Object resultObject) throws SQLException {
        CacheKey cacheKey = this.getCacheKey(request, parameterObject);
        cacheKey.update("executeQueryForObject");
        Object object = this.cacheModel.getObject(cacheKey);
        if (object == CacheModel.NULL_OBJECT) {
            object = null;
        } else if (object == null) {
            object = this.statement.executeQueryForObject(request, trans, parameterObject, resultObject);
            this.cacheModel.putObject(cacheKey, object);
        }
        return object;
    }

    public List executeQueryForList(RequestScope request, Transaction trans, Object parameterObject, int skipResults, int maxResults) throws SQLException {
        List list;
        CacheKey cacheKey = this.getCacheKey(request, parameterObject);
        cacheKey.update("executeQueryForList");
        cacheKey.update(skipResults);
        cacheKey.update(maxResults);
        Object listAsObject = this.cacheModel.getObject(cacheKey);
        if (listAsObject == CacheModel.NULL_OBJECT) {
            list = null;
        } else if (listAsObject == null) {
            list = this.statement.executeQueryForList(request, trans, parameterObject, skipResults, maxResults);
            this.cacheModel.putObject(cacheKey, list);
        } else {
            list = (List)listAsObject;
        }
        return list;
    }

    public void executeQueryWithRowHandler(RequestScope request, Transaction trans, Object parameterObject, RowHandler rowHandler) throws SQLException {
        this.statement.executeQueryWithRowHandler(request, trans, parameterObject, rowHandler);
    }

    public CacheKey getCacheKey(RequestScope request, Object parameterObject) {
        CacheKey key = this.statement.getCacheKey(request, parameterObject);
        if (!this.cacheModel.isReadOnly() && !this.cacheModel.isSerialize()) {
            key.update(request.getSession());
        }
        return key;
    }

    public void setBaseCacheKey(int base) {
        this.statement.setBaseCacheKey(base);
    }

    public void addExecuteListener(ExecuteListener listener) {
        this.statement.addExecuteListener(listener);
    }

    public void notifyListeners() {
        this.statement.notifyListeners();
    }

    public void initRequest(RequestScope request) {
        this.statement.initRequest(request);
    }

    public Sql getSql() {
        return this.statement.getSql();
    }

    public Class getParameterClass() {
        return this.statement.getParameterClass();
    }

    public Integer getTimeout() {
        return this.statement.getTimeout();
    }

    public boolean hasMultipleResultMaps() {
        return this.statement.hasMultipleResultMaps();
    }

    public ResultMap[] getAdditionalResultMaps() {
        return this.statement.getAdditionalResultMaps();
    }
}

