/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springmodules.validation.bean.RuleBasedValidator;
import org.springmodules.validation.bean.conf.BeanValidationConfiguration;
import org.springmodules.validation.bean.conf.CascadeValidation;
import org.springmodules.validation.bean.conf.loader.BeanValidationConfigurationLoader;
import org.springmodules.validation.bean.conf.loader.xml.DefaultXmlBeanValidationConfigurationLoader;
import org.springmodules.validation.bean.converter.ErrorCodeConverter;
import org.springmodules.validation.bean.converter.ModelAwareErrorCodeConverter;
import org.springmodules.validation.bean.rule.ValidationRule;
import org.springmodules.validation.util.condition.Condition;

public class BeanValidator
extends RuleBasedValidator {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springmodules$validation$bean$BeanValidator == null ? (class$org$springmodules$validation$bean$BeanValidator = BeanValidator.class$("org.springmodules.validation.bean.BeanValidator")) : class$org$springmodules$validation$bean$BeanValidator));
    private static final String PROPERTY_KEY_PREFIX = "[";
    private static final String PROPERTY_KEY_SUFFIX = "]";
    private BeanValidationConfigurationLoader configurationLoader;
    private ErrorCodeConverter errorCodeConverter;
    static /* synthetic */ Class class$org$springmodules$validation$bean$BeanValidator;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Map;

    public BeanValidator() {
        this(new DefaultXmlBeanValidationConfigurationLoader());
    }

    public BeanValidator(BeanValidationConfigurationLoader configurationLoader) {
        this.configurationLoader = configurationLoader;
        this.errorCodeConverter = new ModelAwareErrorCodeConverter();
    }

    public boolean supports(Class clazz) {
        return this.configurationLoader.supports(clazz) || super.supports(clazz);
    }

    public void validate(Object obj, Errors errors) {
        this.validateObjectGraphConstraints(obj, obj, errors, new HashSet());
        super.validate(obj, errors);
    }

    public void setErrorCodeConverter(ErrorCodeConverter errorCodeConverter) {
        this.errorCodeConverter = errorCodeConverter;
    }

    public void setConfigurationLoader(BeanValidationConfigurationLoader configurationLoader) {
        this.configurationLoader = configurationLoader;
    }

    protected void validateObjectGraphConstraints(Object root, Object obj, Errors errors, Set validatedObjects) {
        Class<?> clazz;
        BeanValidationConfiguration configuration;
        if (obj == null) {
            return;
        }
        if (validatedObjects.contains(obj)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping validation of object in path '" + errors.getObjectName() + "' for it was already validated"));
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validating object in path '" + errors.getNestedPath() + "'"));
        }
        if ((configuration = this.configurationLoader.loadConfiguration(clazz = obj.getClass())) == null) {
            return;
        }
        this.applyBeanValidation(configuration, obj, errors);
        validatedObjects.add(obj);
        CascadeValidation[] cascadeValidations = configuration.getCascadeValidations();
        BeanWrapper wrapper = this.wrapBean(obj);
        for (int i = 0; i < cascadeValidations.length; ++i) {
            CascadeValidation cascadeValidation = cascadeValidations[i];
            Condition applicabilityCondition = cascadeValidation.getApplicabilityCondition();
            if (!applicabilityCondition.check(obj)) continue;
            String propertyName = cascadeValidation.getPropertyName();
            Class propertyType = wrapper.getPropertyType(propertyName);
            Object propertyValue = wrapper.getPropertyValue(propertyName);
            if (propertyValue == null) continue;
            if (propertyType.isArray()) {
                this.validateArrayProperty(root, propertyValue, propertyName, errors, validatedObjects);
                continue;
            }
            if ((class$java$util$List == null ? BeanValidator.class$("java.util.List") : class$java$util$List).isAssignableFrom(propertyType) || (class$java$util$Set == null ? BeanValidator.class$("java.util.Set") : class$java$util$Set).isAssignableFrom(propertyType)) {
                this.validateListOrSetProperty(root, (Collection)propertyValue, propertyName, errors, validatedObjects);
                continue;
            }
            if ((class$java$util$Map == null ? BeanValidator.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(propertyType)) {
                this.validateMapProperty(root, (Map)propertyValue, propertyName, errors, validatedObjects);
                continue;
            }
            this.validatedSubBean(root, propertyValue, propertyName, errors, validatedObjects);
        }
    }

    protected BeanWrapper wrapBean(Object bean) {
        return new BeanWrapperImpl(bean);
    }

    protected void validateArrayProperty(Object root, Object array, String propertyName, Errors errors, Set validatedObjects) {
        for (int i = 0; i < Array.getLength(array); ++i) {
            String nestedPath = propertyName + PROPERTY_KEY_PREFIX + i + PROPERTY_KEY_SUFFIX;
            errors.pushNestedPath(nestedPath);
            this.validateObjectGraphConstraints(root, Array.get(array, i), errors, validatedObjects);
            errors.popNestedPath();
        }
    }

    protected void validateListOrSetProperty(Object root, Collection collection, String propertyName, Errors errors, Set validatedObjects) {
        int i = 0;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            String nestedPath = propertyName + PROPERTY_KEY_PREFIX + i + PROPERTY_KEY_SUFFIX;
            errors.pushNestedPath(nestedPath);
            this.validateObjectGraphConstraints(root, element, errors, validatedObjects);
            errors.popNestedPath();
            ++i;
        }
    }

    protected void validateMapProperty(Object root, Map map, String propertyName, Errors errors, Set validatedObjects) {
        Iterator entries = map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object key = entry.getKey();
            if (!(key instanceof String)) continue;
            Object value = entry.getValue();
            String nestedPath = propertyName + PROPERTY_KEY_PREFIX + String.valueOf(key) + PROPERTY_KEY_SUFFIX;
            errors.pushNestedPath(nestedPath);
            this.validateObjectGraphConstraints(root, value, errors, validatedObjects);
            errors.popNestedPath();
        }
    }

    protected void validatedSubBean(Object root, Object subBean, String propertyName, Errors errors, Set validatedObjects) {
        errors.pushNestedPath(propertyName);
        this.validateObjectGraphConstraints(root, subBean, errors, validatedObjects);
        errors.popNestedPath();
    }

    protected void applyBeanValidation(BeanValidationConfiguration configuration, Object obj, Errors errors) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Validating global rules...");
        }
        this.applyGlobalValidationRules(configuration, obj, errors);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Validating properties rules...");
        }
        this.applyPropertiesValidationRules(configuration, obj, errors);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Executing custom validator...");
        }
        this.applyCustomValidator(configuration, obj, errors);
    }

    protected void applyGlobalValidationRules(BeanValidationConfiguration configuration, Object obj, Errors errors) {
        ValidationRule[] globalRules = configuration.getGlobalRules();
        for (int i = 0; i < globalRules.length; ++i) {
            ValidationRule rule = globalRules[i];
            if (!rule.isApplicable(obj) || rule.getCondition().check(obj)) continue;
            String errorCode = this.errorCodeConverter.convertGlobalErrorCode(rule.getErrorCode(), obj.getClass());
            if (StringUtils.hasLength((String)errors.getNestedPath())) {
                String nestedPath = errors.getNestedPath();
                String propertyName = nestedPath.substring(0, nestedPath.length() - 1);
                errors.popNestedPath();
                errors.rejectValue(propertyName, errorCode, rule.getErrorArguments(obj), rule.getDefaultErrorMessage());
                errors.pushNestedPath(propertyName);
                continue;
            }
            errors.reject(errorCode, rule.getErrorArguments(obj), rule.getDefaultErrorMessage());
        }
    }

    protected void applyPropertiesValidationRules(BeanValidationConfiguration configuration, Object obj, Errors errors) {
        String[] propertyNames = configuration.getValidatedProperties();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Validating property '" + propertyName + "' rules..."));
            }
            ValidationRule[] rules = configuration.getPropertyRules(propertyName);
            this.validateAndShortCircuitRules(rules, propertyName, obj, errors);
        }
    }

    protected void validateAndShortCircuitRules(ValidationRule[] rules, String propertyName, Object obj, Errors errors) {
        for (int i = 0; i < rules.length; ++i) {
            ValidationRule rule = rules[i];
            if (!rule.isApplicable(obj) || rule.getCondition().check(obj)) continue;
            String errorCode = this.errorCodeConverter.convertPropertyErrorCode(rule.getErrorCode(), obj.getClass(), propertyName);
            errors.rejectValue(propertyName, errorCode, rule.getErrorArguments(obj), rule.getDefaultErrorMessage());
            return;
        }
    }

    protected void applyCustomValidator(BeanValidationConfiguration configuration, Object obj, Errors errors) {
        Validator validator = configuration.getCustomValidator();
        if (validator != null && validator.supports(obj.getClass())) {
            validator.validate(obj, errors);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

