/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.annotation;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springmodules.validation.bean.conf.BeanValidationConfiguration;
import org.springmodules.validation.bean.conf.DefaultBeanValidationConfiguration;
import org.springmodules.validation.bean.conf.MutableBeanValidationConfiguration;
import org.springmodules.validation.bean.conf.loader.BeanValidationConfigurationLoader;
import org.springmodules.validation.bean.conf.loader.annotation.DefaultValidationAnnotationHandlerRegistry;
import org.springmodules.validation.bean.conf.loader.annotation.Validatable;
import org.springmodules.validation.bean.conf.loader.annotation.ValidationAnnotationHandlerRegistry;
import org.springmodules.validation.bean.conf.loader.annotation.handler.ClassValidationAnnotationHandler;
import org.springmodules.validation.bean.conf.loader.annotation.handler.MethodValidationAnnotationHandler;
import org.springmodules.validation.bean.conf.loader.annotation.handler.PropertyValidationAnnotationHandler;
import org.springmodules.validation.bean.conf.loader.annotation.handler.ValidationRule;
import org.springmodules.validation.util.lang.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationBeanValidationConfigurationLoader
implements BeanValidationConfigurationLoader,
ApplicationContextAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog(AnnotationBeanValidationConfigurationLoader.class);
    private boolean checkValidatableAnnotation;
    private Map<Class, BeanValidationConfiguration> configurationByClass;
    private ValidationAnnotationHandlerRegistry handlerRegistry;
    private ApplicationContext applicationContext;

    public AnnotationBeanValidationConfigurationLoader() {
        this(false);
    }

    public AnnotationBeanValidationConfigurationLoader(boolean checkValidatableAnnotation) {
        this.checkValidatableAnnotation = checkValidatableAnnotation;
        this.configurationByClass = new HashMap<Class, BeanValidationConfiguration>();
        this.handlerRegistry = new DefaultValidationAnnotationHandlerRegistry();
    }

    @Override
    public boolean supports(Class clazz) {
        return this.checkValidatableAnnotation ? clazz.isAnnotationPresent(Validatable.class) : true;
    }

    @Override
    public BeanValidationConfiguration loadConfiguration(Class clazz) {
        BeanValidationConfiguration configuration = this.configurationByClass.get(clazz);
        if (configuration == null) {
            configuration = this.createValidationConfiguration(clazz);
            this.configurationByClass.put(clazz, configuration);
        }
        return configuration;
    }

    public void afterPropertiesSet() throws Exception {
        this.initContext(this.handlerRegistry);
    }

    public void setCheckValidatableAnnotation(boolean checkValidatableAnnotation) {
        this.checkValidatableAnnotation = checkValidatableAnnotation;
    }

    public boolean isCheckValidatableAnnotation() {
        return this.checkValidatableAnnotation;
    }

    public void setHandlerRegistry(ValidationAnnotationHandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected BeanValidationConfiguration createValidationConfiguration(Class clazz) {
        DefaultBeanValidationConfiguration configuration = new DefaultBeanValidationConfiguration();
        this.handleClassAnnotations(clazz, configuration);
        this.handlePropertyAnnotations(clazz, configuration);
        this.handleMethodAnnotations(clazz, configuration);
        return configuration;
    }

    protected void handleClassAnnotations(Class clazz, MutableBeanValidationConfiguration configuration) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = clazz.getAnnotations()) {
            if (!this.isValidationAnnotation(annotation)) continue;
            ClassValidationAnnotationHandler handler = this.handlerRegistry.findClassHanlder(annotation, clazz);
            if (handler == null) {
                logger.warn((Object)("No hanlder is defined for annotation '" + annotation.annotationType().getName() + "'... Annotation will be ignored..."));
                continue;
            }
            handler.handleAnnotation(annotation, clazz, configuration);
        }
    }

    protected void handleMethodAnnotations(Class clazz, MutableBeanValidationConfiguration configuration) {
        Method[] methods;
        for (Method method : methods = ReflectionUtils.getAllMethods(clazz)) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = method.getAnnotations()) {
                if (!this.isValidationAnnotation(annotation)) continue;
                MethodValidationAnnotationHandler handler = this.handlerRegistry.findMethodHandler(annotation, clazz, method);
                if (handler == null) {
                    logger.warn((Object)("No hanlder is defined for annotation '" + annotation.annotationType().getName() + "'... Annotation will be ignored..."));
                    continue;
                }
                handler.handleAnnotation(annotation, clazz, method, configuration);
            }
        }
    }

    protected boolean isValidationAnnotation(Annotation annotation) {
        return annotation.annotationType().getAnnotation(ValidationRule.class) != null;
    }

    protected void handlePropertyAnnotations(Class clazz, MutableBeanValidationConfiguration configuration) {
        PropertyDescriptor[] descriptors;
        List<Field> fields = this.extractFieldFromClassHierarchy(clazz);
        for (Field field : fields) {
            String fieldName = field.getName();
            PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor((Class)clazz, (String)fieldName);
            if (descriptor == null) continue;
            Annotation[] annotations = field.getAnnotations();
            this.handleProprtyAnnotations(annotations, clazz, descriptor, configuration);
        }
        for (PropertyDescriptor descriptor : descriptors = BeanUtils.getPropertyDescriptors((Class)clazz)) {
            Method writeMethod = descriptor.getWriteMethod();
            if (writeMethod == null) continue;
            Annotation[] annotations = writeMethod.getAnnotations();
            this.handleProprtyAnnotations(annotations, clazz, descriptor, configuration);
        }
    }

    protected List<Field> extractFieldFromClassHierarchy(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            CollectionUtils.addAll(fields, (Object[])clazz.getDeclaredFields());
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    protected void handleProprtyAnnotations(Annotation[] annotations, Class validatedClass, PropertyDescriptor descriptor, MutableBeanValidationConfiguration configuration) {
        for (Annotation annotation : annotations) {
            PropertyValidationAnnotationHandler handler;
            if (!this.isValidationAnnotation(annotation) || (handler = this.handlerRegistry.findPropertyHanlder(annotation, validatedClass, descriptor)) == null) continue;
            handler.handleAnnotation(annotation, validatedClass, descriptor, configuration);
        }
    }

    protected void initContext(Object object) throws Exception {
        if (object instanceof ApplicationContextAware) {
            ((ApplicationContextAware)object).setApplicationContext(this.applicationContext);
        }
        if (object instanceof InitializingBean) {
            ((InitializingBean)object).afterPropertiesSet();
        }
    }
}

