/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.xml.handler;

import java.beans.PropertyDescriptor;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springmodules.validation.bean.conf.MutableBeanValidationConfiguration;
import org.springmodules.validation.bean.conf.loader.xml.handler.PropertyValidationElementHandler;
import org.springmodules.validation.bean.rule.AbstractValidationRule;
import org.springmodules.validation.bean.rule.PropertyValidationRule;
import org.springmodules.validation.bean.rule.resolver.ErrorArgumentsResolver;
import org.springmodules.validation.bean.rule.resolver.FunctionErrorArgumentsResolver;
import org.springmodules.validation.util.cel.ConditionExpressionBased;
import org.springmodules.validation.util.cel.ConditionExpressionParser;
import org.springmodules.validation.util.cel.valang.ValangConditionExpressionParser;
import org.springmodules.validation.util.condition.Condition;
import org.springmodules.validation.util.fel.FunctionExpressionBased;
import org.springmodules.validation.util.fel.FunctionExpressionParser;
import org.springmodules.validation.util.fel.parser.ValangFunctionExpressionParser;
import org.w3c.dom.Element;

public abstract class AbstractPropertyValidationElementHandler
implements PropertyValidationElementHandler,
ConditionExpressionBased,
FunctionExpressionBased {
    private static final String ERROR_CODE_ATTR = "code";
    private static final String MESSAGE_ATTR = "message";
    private static final String ARGS_ATTR = "args";
    private static final String APPLY_IF_ATTR = "apply-if";
    private static final String CONTEXTS_ATTR = "contexts";
    private String elementName;
    private String namespaceUri;
    private ConditionExpressionParser conditionExpressionParser;
    private FunctionExpressionParser functionExpressionParser;

    public AbstractPropertyValidationElementHandler(String elementName) {
        this(elementName, null);
    }

    public AbstractPropertyValidationElementHandler(String elementName, String namespace) {
        this(elementName, namespace, new ValangConditionExpressionParser(), new ValangFunctionExpressionParser());
    }

    public AbstractPropertyValidationElementHandler(String elementName, String namespace, ConditionExpressionParser conditionExpressionParser, FunctionExpressionParser functionExpressionParser) {
        this.elementName = elementName;
        this.namespaceUri = namespace;
        this.conditionExpressionParser = conditionExpressionParser;
        this.functionExpressionParser = functionExpressionParser;
    }

    public boolean supports(Element element, Class clazz, PropertyDescriptor descriptor) {
        String localName = element.getLocalName();
        if (!localName.equals(this.elementName)) {
            return false;
        }
        String ns = element.getNamespaceURI();
        return ObjectUtils.nullSafeEquals((Object)ns, (Object)this.namespaceUri);
    }

    public void handle(Element element, String propertyName, MutableBeanValidationConfiguration configuration) {
        String[] applicableContexts;
        Condition applicabilityCondition;
        ErrorArgumentsResolver argumentsResolver;
        String message;
        AbstractValidationRule rule = this.createValidationRule(element);
        String errorCode = this.extractErrorCode(element);
        if (errorCode != null) {
            rule.setErrorCode(errorCode);
        }
        if ((message = this.extractMessage(element)) != null) {
            rule.setDefaultErrorMessage(message);
        }
        if ((argumentsResolver = this.extractArgumentsResolver(element)) != null) {
            rule.setErrorArgumentsResolver(argumentsResolver);
        }
        if ((applicabilityCondition = this.extractApplicabilityCondition(element)) != null) {
            rule.setApplicabilityCondition(applicabilityCondition);
        }
        if ((applicableContexts = this.extractApplicableContexts(element)) != null) {
            rule.setContextTokens(applicableContexts);
        }
        if (this.isConditionGloballyScoped(element)) {
            configuration.addPropertyRule(propertyName, rule);
        } else {
            PropertyValidationRule propertyRule = new PropertyValidationRule(propertyName, rule);
            if (applicabilityCondition != null) {
                propertyRule.setApplicabilityCondition(applicabilityCondition);
            }
            if (applicableContexts != null) {
                propertyRule.setContextTokens(applicableContexts);
            }
            configuration.addPropertyRule(propertyName, propertyRule);
        }
    }

    public boolean isConditionGloballyScoped(Element element) {
        return false;
    }

    protected String extractErrorCode(Element element) {
        String code = element.getAttribute(ERROR_CODE_ATTR);
        return StringUtils.hasLength((String)code) ? code : null;
    }

    protected String extractMessage(Element element) {
        String message = element.getAttribute(MESSAGE_ATTR);
        return StringUtils.hasLength((String)message) ? message : null;
    }

    protected ErrorArgumentsResolver extractArgumentsResolver(Element element) {
        String[] expressions;
        String argsString = element.getAttribute(ARGS_ATTR);
        String[] stringArray = expressions = argsString == null ? new String[]{} : StringUtils.tokenizeToStringArray((String)argsString, (String)", ");
        if (expressions.length == 0) {
            return null;
        }
        return new FunctionErrorArgumentsResolver(expressions, this.functionExpressionParser);
    }

    protected Condition extractApplicabilityCondition(Element element) {
        String expression = element.getAttribute(APPLY_IF_ATTR);
        return StringUtils.hasText((String)expression) ? this.conditionExpressionParser.parse(expression) : null;
    }

    protected String[] extractApplicableContexts(Element element) {
        String contextString = element.getAttribute(CONTEXTS_ATTR);
        return StringUtils.hasText((String)contextString) ? StringUtils.commaDelimitedListToStringArray((String)contextString) : null;
    }

    public void setConditionExpressionParser(ConditionExpressionParser conditionExpressionParser) {
        this.conditionExpressionParser = conditionExpressionParser;
    }

    protected ConditionExpressionParser getConditionExpressionParser() {
        return this.conditionExpressionParser;
    }

    public void setFunctionExpressionParser(FunctionExpressionParser functionExpressionParser) {
        this.functionExpressionParser = functionExpressionParser;
    }

    protected FunctionExpressionParser getFunctionExpressionParser() {
        return this.functionExpressionParser;
    }

    protected abstract AbstractValidationRule createValidationRule(Element var1);
}

