/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.xml.handler;

import org.springframework.util.StringUtils;
import org.springmodules.validation.bean.conf.ValidationConfigurationException;
import org.springmodules.validation.bean.conf.loader.xml.handler.AbstractPropertyValidationElementHandler;
import org.springmodules.validation.bean.rule.AbstractValidationRule;
import org.springmodules.validation.bean.rule.ExpressionValidationRule;
import org.w3c.dom.Element;

public class ExpressionPropertyValidationElementHandler
extends AbstractPropertyValidationElementHandler {
    private static final String ELEMENT_NAME = "expression";
    private static final String CONDITION_ATTR = "condition";
    private static final String SCOPE_ATTR = "scope";
    private static final String PROPERTY_SCOPE_VALUE = "property";
    private static final String GLOBAL_SCOPE_VALUE = "global";

    public ExpressionPropertyValidationElementHandler(String namespaceUri) {
        super(ELEMENT_NAME, namespaceUri);
    }

    protected AbstractValidationRule createValidationRule(Element element) {
        String expression = element.getAttribute(CONDITION_ATTR);
        if (!StringUtils.hasText((String)expression)) {
            throw new ValidationConfigurationException("Element 'expression' must have a 'condition' attribute");
        }
        return new ExpressionValidationRule(this.getConditionExpressionParser(), expression);
    }

    public boolean isConditionGloballyScoped(Element element) {
        if (!element.hasAttribute(SCOPE_ATTR)) {
            return true;
        }
        String value = element.getAttribute(SCOPE_ATTR);
        if (GLOBAL_SCOPE_VALUE.equals(value)) {
            return true;
        }
        if (PROPERTY_SCOPE_VALUE.equals(value)) {
            return false;
        }
        throw new ValidationConfigurationException("Unknown value '" + value + "' for attribute '" + SCOPE_ATTR + "'");
    }
}

