/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.context;

import org.springframework.util.Assert;
import org.springmodules.validation.bean.context.ValidationContext;

public class ValidationContextHolder {
    private static ThreadLocal contextHolder = new ThreadLocal();

    public static ValidationContext getValidationContext() {
        return (ValidationContext)contextHolder.get();
    }

    public static void setValidationContext(ValidationContext context) {
        Assert.notNull((Object)context, (String)"Cannot set a null validation context. To clear this holder please call clearContext() instead");
        contextHolder.set(context);
    }

    public static void clearContext() {
        contextHolder.remove();
    }
}

