/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.string;

import org.springframework.util.Assert;
import org.springmodules.validation.util.condition.string.AbstractStringCondition;

public class MaxLengthStringCondition
extends AbstractStringCondition {
    private int maxLength;

    public MaxLengthStringCondition(int maxLength) {
        Assert.isTrue((maxLength >= 0 ? 1 : 0) != 0, (String)"Given maximum length must be a non-negative value");
        this.maxLength = maxLength;
    }

    protected boolean checkString(String text) {
        return text.length() <= this.maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }
}

