/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.string;

import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springmodules.validation.util.condition.string.AbstractStringCondition;

public class RegExpStringCondition
extends AbstractStringCondition {
    private final Pattern pattern;

    public RegExpStringCondition(String regexp) {
        Assert.notNull((Object)regexp, (String)"The given regular expression cannot be null");
        this.pattern = Pattern.compile(regexp);
    }

    public RegExpStringCondition(Pattern pattern) {
        Assert.notNull((Object)pattern, (String)"The given pattern cannot be null");
        this.pattern = pattern;
    }

    protected boolean checkString(String text) {
        return this.pattern.matcher(text).matches();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getRegExp() {
        return this.pattern.pattern();
    }
}

