/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.date;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.Predicate;
import org.springmodules.validation.util.date.DateParseException;
import org.springmodules.validation.util.date.DateParser;

public class DefaultDateParser
implements DateParser {
    private static DefaultDateParser instance = new DefaultDateParser();
    private Map registrations = new HashMap();

    public static DefaultDateParser getInstance() {
        return instance;
    }

    public DefaultDateParser() {
        this.register("^\\d{8}$", "yyyyMMdd");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}$", "yyyy-MM-dd");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}\\s+\\d{2}:\\d{2}:\\d{2}$", "yyyy-MM-dd HH:mm:ss");
        this.register("^\\d{8}\\s+\\d{6}$", "yyyyMMdd HHmmss");
        this.register("^\\d{8}\\s+\\d{2}:\\d{2}:\\d{2}$", "yyyyMMdd HH:mm:ss");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}\\s+\\d{6}$", "yyyy-MM-dd HHmmss");
        this.register("^T$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
            }
        });
        this.register("^T\\+(\\d+)S$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(14, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)S$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(14, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>s$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(13, 1);
                calendar.add(14, calendar.get(14) + -1);
            }
        });
        this.register("^T<s$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(14, calendar.get(14) * -1);
            }
        });
        this.register("^T\\+(\\d+)s$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(13, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)s$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(13, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>m$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(12, 1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) + -1);
            }
        });
        this.register("^T<m$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
            }
        });
        this.register("^T\\+(\\d+)m$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(12, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)m$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(12, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>H$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(11, 1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) + -1);
            }
        });
        this.register("^T<H$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
            }
        });
        this.register("^T\\+(\\d+)H$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(11, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)H$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(11, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>d$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(6, 1);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) + -1);
            }
        });
        this.register("^T<d$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
            }
        });
        this.register("^T\\+(\\d+)d$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(6, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)d$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(6, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>w$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                int thisWeek = calendar.get(3);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
                while (thisWeek == calendar.get(3)) {
                    calendar.add(6, 1);
                }
                calendar.add(14, -1);
            }
        });
        this.register("^T<w$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                int thisWeek = calendar.get(3);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
                while (thisWeek == calendar.get(3)) {
                    calendar.add(6, -1);
                }
                calendar.add(6, 1);
            }
        });
        this.register("^T\\+(\\d+)w$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(3, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)w$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(3, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>M$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                int thisMonth = calendar.get(2);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
                while (thisMonth == calendar.get(2)) {
                    calendar.add(6, 1);
                }
                calendar.add(14, -1);
            }
        });
        this.register("^T<M$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                int thisMonth = calendar.get(2);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
                while (thisMonth == calendar.get(2)) {
                    calendar.add(6, -1);
                }
                calendar.add(6, 1);
            }
        });
        this.register("^T\\+(\\d+)M$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(2, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)M$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(2, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>y$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                int thisYear = calendar.get(1);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
                while (thisYear == calendar.get(1)) {
                    calendar.add(6, 1);
                }
                calendar.add(14, -1);
            }
        });
        this.register("^T<y$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                int thisYear = calendar.get(1);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
                while (thisYear == calendar.get(1)) {
                    calendar.add(6, -1);
                }
                calendar.add(6, 1);
            }
        });
        this.register("^T\\+(\\d+)y$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(1, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)y$", new DateModifier(){

            public void modify(Calendar calendar, String value) {
                calendar.add(1, Integer.parseInt(value) * -1);
            }
        });
    }

    public Date parse(String str) throws DateParseException {
        Date t = null;
        String tmpStr = null;
        int parsedSoFar = 0;
        boolean firstPass = true;
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("Date string should not be null or blank!");
        }
        tmpStr = str;
        while (tmpStr.length() > 0) {
            Date tmpT = null;
            tmpT = this.simpleParse(tmpStr, t);
            if (tmpT != null) {
                t = tmpT;
                parsedSoFar = firstPass ? tmpStr.length() : (parsedSoFar += tmpStr.length() - 1);
                tmpStr = "T" + str.substring(parsedSoFar);
                firstPass = false;
            } else {
                tmpStr = tmpStr.substring(0, tmpStr.length() - 1);
            }
            if (!tmpStr.equals("T")) continue;
            if (parsedSoFar == str.length()) break;
            throw new DateParseException("Could not parse date string [" + str + "]!");
        }
        if (t == null) {
            throw new DateParseException("Could not parse date string [" + str + "]!");
        }
        return t;
    }

    private Date simpleParse(String str, Date t) throws DateParseException {
        Iterator iter = this.registrations.keySet().iterator();
        while (iter.hasNext()) {
            RegexpPredicate predicate = (RegexpPredicate)iter.next();
            if (!predicate.evaluate(str)) continue;
            Object dateParser = this.registrations.get(predicate);
            if (dateParser instanceof DateParser) {
                return ((DateParser)dateParser).parse(str);
            }
            if (!(dateParser instanceof DateModifier)) continue;
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setFirstDayOfWeek(2);
            if (t == null) {
                calendar.setTime(new Date());
            } else {
                calendar.setTime(t);
            }
            ((DateModifier)dateParser).modify(calendar, predicate.getGroup1(str));
            return calendar.getTime();
        }
        return null;
    }

    public void register(String regexp, String format) {
        this.registrations.put(new RegexpPredicate(regexp), new BasicDateParser(format));
    }

    public void register(String regexp, DateModifier dateParser) {
        this.registrations.put(new RegexpPredicate(regexp), dateParser);
    }

    private class BasicDateParser
    implements DateParser {
        private DateFormat dateFormat = null;

        public BasicDateParser(String format) {
            if (format == null || format.length() == 0) {
                throw new IllegalArgumentException("Format parameter should not be null or blank!");
            }
            this.dateFormat = new SimpleDateFormat(format);
        }

        public Date parse(String s) throws DateParseException {
            try {
                return this.dateFormat.parse(s);
            }
            catch (ParseException e) {
                return null;
            }
        }
    }

    private class RegexpPredicate
    implements Predicate {
        private Pattern pattern = null;

        public RegexpPredicate(String regexp) {
            if (regexp == null || regexp.length() == 0) {
                throw new IllegalArgumentException("Regular expression parameter should not be null or blank!");
            }
            this.pattern = Pattern.compile(regexp);
        }

        public boolean evaluate(Object o) {
            return this.pattern.matcher((String)o).matches();
        }

        public String getGroup1(Object o) {
            Matcher matcher = this.pattern.matcher((String)o);
            if (matcher.matches() && matcher.groupCount() > 0) {
                return matcher.group(1);
            }
            return null;
        }
    }

    public static interface DateModifier {
        public void modify(Calendar var1, String var2);
    }
}

