/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.util.Map;
import java.util.WeakHashMap;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.IntroductionInfoSupport;

public class DelegatePerTargetObjectIntroductionInterceptor
extends IntroductionInfoSupport
implements IntroductionInterceptor {
    private Map delegateMap = new WeakHashMap();
    private Class defaultImplType;
    private Class interfaceType;
    static /* synthetic */ Class class$org$springframework$aop$IntroductionInterceptor;
    static /* synthetic */ Class class$org$springframework$aop$DynamicIntroductionAdvice;

    public DelegatePerTargetObjectIntroductionInterceptor(Class defaultImplType, Class interfaceType) {
        this.defaultImplType = defaultImplType;
        this.interfaceType = interfaceType;
        Object delegate = this.createNewDelegate();
        this.implementInterfacesOnObject(delegate);
        this.suppressInterface(class$org$springframework$aop$IntroductionInterceptor == null ? (class$org$springframework$aop$IntroductionInterceptor = DelegatePerTargetObjectIntroductionInterceptor.class$("org.springframework.aop.IntroductionInterceptor")) : class$org$springframework$aop$IntroductionInterceptor);
        this.suppressInterface(class$org$springframework$aop$DynamicIntroductionAdvice == null ? (class$org$springframework$aop$DynamicIntroductionAdvice = DelegatePerTargetObjectIntroductionInterceptor.class$("org.springframework.aop.DynamicIntroductionAdvice")) : class$org$springframework$aop$DynamicIntroductionAdvice);
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        if (this.isMethodOnIntroducedInterface(mi)) {
            Object delegate = this.getIntroductionDelegateFor(mi.getThis());
            Object retVal = AopUtils.invokeJoinpointUsingReflection(delegate, mi.getMethod(), mi.getArguments());
            if (retVal == delegate && mi instanceof ProxyMethodInvocation) {
                retVal = ((ProxyMethodInvocation)mi).getProxy();
            }
            return retVal;
        }
        return this.doProceed(mi);
    }

    protected Object doProceed(MethodInvocation mi) throws Throwable {
        return mi.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getIntroductionDelegateFor(Object targetObject) {
        Map map = this.delegateMap;
        synchronized (map) {
            if (this.delegateMap.containsKey(targetObject)) {
                return this.delegateMap.get(targetObject);
            }
            Object delegate = this.createNewDelegate();
            this.delegateMap.put(targetObject, delegate);
            return delegate;
        }
    }

    private Object createNewDelegate() {
        try {
            return this.defaultImplType.newInstance();
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Cannot create default implementation for '" + this.interfaceType.getName() + "' mixin (" + this.defaultImplType.getName() + "): " + ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

