/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.commonj;

import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import commonj.work.WorkRejectedException;
import java.util.LinkedHashMap;
import jp.terasoluna.fw.batch.commonj.WorkerExecutorService;
import jp.terasoluna.fw.batch.commonj.listener.WorkMapListener;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.standard.QueueProcessor;
import jp.terasoluna.fw.batch.standard.RunnableQueueProcessor;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;
import org.springframework.scheduling.commonj.DelegatingWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkManagerExecutorService
implements WorkerExecutorService {
    private WorkManager workManager = null;
    private WorkMapListener workMapListener = null;
    private LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap = null;
    private JobExceptionHandler defaultJobExceptionHandler = null;
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler();

    @Override
    public WorkItem submit(QueueProcessor queueProcessor, WorkQueue workQueue, JobStatus jobStatus) {
        try {
            DelegatingWork work = new DelegatingWork((Runnable)new RunnableQueueProcessor(queueProcessor, workQueue, jobStatus, this.exceptionHandlerMap, this.defaultJobExceptionHandler, this.throwableHandler));
            if (this.workMapListener == null) {
                return this.workManager.schedule((Work)work);
            }
            WorkItem workItem = this.workManager.schedule((Work)work, (WorkListener)this.workMapListener);
            this.workMapListener.addWork(workItem, (Work)work);
            return workItem;
        }
        catch (IllegalArgumentException e) {
            throw new JobException(e);
        }
        catch (WorkRejectedException e) {
            throw new JobException((Exception)((Object)e));
        }
        catch (WorkException e) {
            throw new JobException((Exception)((Object)e));
        }
    }

    @Override
    public JobExceptionHandler getDefaultJobExceptionHandler() {
        return this.defaultJobExceptionHandler;
    }

    public void setDefaultJobExceptionHandler(JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }

    @Override
    public LinkedHashMap<JobException, JobExceptionHandler> getExceptionHandlerMap() {
        return this.exceptionHandlerMap;
    }

    public void setExceptionHandlerMap(LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }

    @Override
    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    @Override
    public WorkMapListener getWorkMapListener() {
        return this.workMapListener;
    }

    public void setWorkMapListener(WorkMapListener workMapListener) {
        this.workMapListener = workMapListener;
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }
}

