/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.ibatissupport;

import com.ibatis.sqlmap.client.event.RowHandler;
import jp.terasoluna.fw.batch.core.AbstractCollector;
import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.QueueingException;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import org.springframework.orm.ibatis.SqlMapClientTemplate;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBatisDbCollectorImpl
extends AbstractCollector<JobContext> {
    private String sql = null;
    private SqlMapClientDaoSupport queryDAO = null;

    @Override
    protected CollectorResult doCollect(JobContext jobContext, CollectedDataHandler collectedDataHandler, JobStatus jobStatus) {
        SqlMapClientTemplate sqlMapClientTemplate = this.queryDAO.getSqlMapClientTemplate();
        QueuePutRowHandler handler = new QueuePutRowHandler(collectedDataHandler, jobStatus);
        try {
            sqlMapClientTemplate.queryWithRowHandler(this.sql, (Object)jobContext, (RowHandler)handler);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof QueueingException && !jobStatus.isExecuting()) {
                throw new QueueingException(e);
            }
            throw e;
        }
        return new CollectorResult(ReturnCode.NORMAL_END, handler.getCollected());
    }

    public void setQueryDAO(SqlMapClientDaoSupport queryDAO) {
        this.queryDAO = queryDAO;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    private static class QueuePutRowHandler
    implements RowHandler {
        private int collected = 0;
        private CollectedDataHandler collectedDataHandler = null;
        private JobStatus jobStatus = null;

        public QueuePutRowHandler(CollectedDataHandler collectedDataHandler, JobStatus jobStatus) {
            this.collectedDataHandler = collectedDataHandler;
            this.jobStatus = jobStatus;
        }

        public void handleRow(Object row) {
            this.collectedDataHandler.handle(row, this.collected++);
            this.jobStatus.incrementCollected();
        }

        public int getCollected() {
            return this.collected;
        }
    }
}

