/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.springsupport.transaction;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.JobContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class TransactionalJobStatus
extends JobStatus {
    private static Log log = LogFactory.getLog(TransactionalJobStatus.class);
    private Object savepoint = null;
    private PlatformTransactionManager transactionManager = null;
    private TransactionStatus transactionStatus = null;
    private boolean useSavepoint = false;

    public void beginTransaction() {
        this.transactionStatus = this.transactionManager.getTransaction(null);
    }

    public void commit() {
        if (!this.transactionStatus.isCompleted()) {
            this.transactionManager.commit(this.transactionStatus);
            this.savepoint = null;
            this.incrementCommitCount();
        }
    }

    public JobStatus getChild(JobContext jobContext) {
        TransactionalJobStatus childJobStatus = new TransactionalJobStatus();
        childJobStatus.setTransactionManager(this.transactionManager);
        childJobStatus.setUseSavepoint(this.useSavepoint);
        this.resetChildData(childJobStatus, jobContext);
        return childJobStatus;
    }

    protected PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void releaseAndCreateSavepoint() {
        block4: {
            if (!this.useSavepoint) {
                return;
            }
            if (this.savepoint != null) {
                try {
                    this.transactionStatus.releaseSavepoint(this.savepoint);
                }
                catch (TransactionException ex) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"Could not explicitly release JDBC savepoint", (Throwable)ex);
                }
            }
        }
        this.savepoint = this.transactionStatus.createSavepoint();
    }

    public void rollback() {
        if (!this.transactionStatus.isCompleted()) {
            this.transactionManager.rollback(this.transactionStatus);
        }
    }

    public void rollbackToSavepoint() {
        if (!this.useSavepoint) {
            return;
        }
        if (!this.transactionStatus.isCompleted() && this.savepoint != null) {
            this.transactionStatus.rollbackToSavepoint(this.savepoint);
            this.releaseAndCreateSavepoint();
        }
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setUseSavepoint(boolean useSavepoint) {
        this.useSavepoint = useSavepoint;
    }

    public boolean useSavepoint() {
        return this.useSavepoint;
    }
}

