/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import java.util.LinkedHashMap;
import jp.terasoluna.fw.batch.core.ExceptionHandlerUtil;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.standard.QueueProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunnableQueueProcessor
implements Runnable {
    private static final Log log = LogFactory.getLog(RunnableQueueProcessor.class);
    private QueueProcessor queueProcessor = null;
    private WorkQueue workQueue = null;
    private JobStatus jobStatus = null;
    private LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap;
    private JobExceptionHandler defaultJobExceptionHandler;
    private ThrowableHandler throwableHandler = null;

    public RunnableQueueProcessor(QueueProcessor queueProcessor, WorkQueue workQueue, JobStatus jobStatus, LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap, JobExceptionHandler defaultJobExceptionHandler, ThrowableHandler throwableHandler) {
        this.queueProcessor = queueProcessor;
        this.workQueue = workQueue;
        this.jobStatus = jobStatus;
        this.exceptionHandlerMap = exceptionHandlerMap;
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
        this.throwableHandler = throwableHandler;
    }

    @Override
    public void run() {
        try {
            try {
                this.queueProcessor.process(this.workQueue, this.jobStatus);
            }
            catch (Exception e) {
                try {
                    JobException jobException = new JobException(e);
                    JobExceptionHandler handler = ExceptionHandlerUtil.getJobExceptionHandler(jobException, this.exceptionHandlerMap, this.defaultJobExceptionHandler);
                    handler.handlException(null, jobException, this.jobStatus);
                }
                catch (RuntimeException handlerException) {
                    log.error((Object)("[Exception in ExceptionHandler] Error JobID: " + this.jobStatus.getJobId()), (Throwable)handlerException);
                    this.jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
                }
            }
        }
        catch (Throwable throwable) {
            this.throwableHandler.handle(null, throwable, this.jobStatus);
        }
    }
}

