/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.validation;

import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.validation.ValidationResultHandler;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class ValidationExecutor
implements CollectedDataHandler {
    private Validator validator = null;
    private ValidationResultHandler validationResultHandler = null;
    private CollectedDataHandler collectedDataHandler = null;

    public ValidationExecutor(CollectedDataHandler collectedDataHandler, Validator validator, ValidationResultHandler validationResultHandler) {
        this.collectedDataHandler = collectedDataHandler;
        this.validator = validator;
        this.validationResultHandler = validationResultHandler;
    }

    public void handle(Object collectedData, int index) {
        BindException bindException = new BindException(collectedData, collectedData.getClass().getName());
        this.validator.validate(collectedData, (Errors)bindException);
        if (this.validationResultHandler.handle(bindException, collectedData)) {
            this.collectedDataHandler.handle(collectedData, index);
        }
    }

    public void close() {
        this.collectedDataHandler.close();
    }
}

