/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.util.Map;
import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.OutputFileColumn;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.standard.AbstractFileLineWriter;
import jp.terasoluna.fw.file.dao.standard.ColumnFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedFileLineWriter<T>
extends AbstractFileLineWriter<T> {
    private static final char DELIMITER = '\u0000';
    private static final char ENCLOSE_CHAR = '\u0000';

    public FixedFileLineWriter(String fileName, Class<T> clazz, Map<String, ColumnFormatter> columnFormatterrMap) {
        super(fileName, clazz, columnFormatterrMap);
        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);
        if (fileFormat.delimiter() != ',') {
            throw new FileException("Delimiter can not change.", new IllegalStateException(), fileName);
        }
        if (fileFormat.encloseChar() != '\u0000') {
            throw new FileException("EncloseChar can not change.", new IllegalStateException(), fileName);
        }
        super.init();
    }

    @Override
    protected boolean isCheckByte(OutputFileColumn outputFileColumn) {
        return true;
    }

    @Override
    public char getDelimiter() {
        return '\u0000';
    }

    @Override
    public char getEncloseChar() {
        return '\u0000';
    }
}

