/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.List;
import jp.terasoluna.fw.file.dao.FileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtility {
    private static boolean checkFileExist = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(String srcFile, String newFile) {
        FileUtility.checkAbsolutePath(srcFile);
        FileUtility.checkAbsolutePath(newFile);
        File srcFileObject = new File(srcFile);
        if (!srcFileObject.exists()) {
            throw new FileException(srcFile + " is not exist.", srcFile);
        }
        File newFileObject = new File(newFile);
        if (newFileObject.exists() && checkFileExist) {
            boolean result = newFileObject.delete();
            if (!result) {
                throw new FileException("File control operation was failed.", newFile);
            }
        } else if (newFileObject.exists() && !checkFileExist) {
            throw new FileException(newFile + " is exist.", newFile);
        }
        FileOutputStream fos = null;
        FileChannel outputFileChannel = null;
        FileInputStream ios = null;
        FileChannel inputFileChannel = null;
        FileLock inputFileLock = null;
        FileLock outputFileLock = null;
        try {
            try {
                fos = new FileOutputStream(newFileObject, true);
                outputFileChannel = fos.getChannel();
                ios = new FileInputStream(srcFileObject);
                inputFileChannel = ios.getChannel();
                ByteBuffer buffer = ByteBuffer.allocate(1024);
                inputFileLock = inputFileChannel.lock(0L, Long.MAX_VALUE, true);
                outputFileLock = outputFileChannel.lock(0L, Long.MAX_VALUE, false);
                while (inputFileChannel.position() < inputFileChannel.size()) {
                    buffer.clear();
                    inputFileChannel.read(buffer);
                    buffer.flip();
                    outputFileChannel.write(buffer);
                }
                Object var12_14 = null;
            }
            catch (FileNotFoundException e) {
                throw new FileException("File control operation was failed.", e);
            }
            catch (IOException e) {
                throw new FileException("File control operation was failed.", e);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            try {
                if (inputFileLock != null) {
                    inputFileLock.release();
                }
                if (outputFileLock != null) {
                    outputFileLock.release();
                }
                if (ios != null) {
                    ios.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (outputFileChannel != null) {
                    outputFileChannel.close();
                }
                if (inputFileChannel == null) throw throwable;
                inputFileChannel.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (inputFileLock != null) {
            inputFileLock.release();
        }
        if (outputFileLock != null) {
            outputFileLock.release();
        }
        if (ios != null) {
            ios.close();
        }
        if (fos != null) {
            fos.close();
        }
        if (outputFileChannel != null) {
            outputFileChannel.close();
        }
        if (inputFileChannel == null) return;
        inputFileChannel.close();
        return;
    }

    public static void deleteFile(String srcFile) {
        FileUtility.checkAbsolutePath(srcFile);
        File srcFileObject = new File(srcFile);
        if (!srcFileObject.exists()) {
            throw new FileException(srcFile + " is not exist.", srcFile);
        }
        boolean result = srcFileObject.delete();
        if (!result) {
            throw new FileException("File control operation was failed.", srcFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void mergeFile(List<String> fileList, String newFile) {
        FileUtility.checkAbsolutePath(newFile);
        File newFileObject = new File(newFile);
        if (newFileObject.exists() && checkFileExist) {
            boolean result = newFileObject.delete();
            if (!result) {
                throw new FileException("File control operation was failed.", newFile);
            }
        } else if (newFileObject.exists() && !checkFileExist) {
            throw new FileException(newFile + " is exist.", newFile);
        }
        FileOutputStream fos = null;
        FileChannel outputFileChannel = null;
        FileLock outputFileLock = null;
        try {
            try {
                fos = new FileOutputStream(newFileObject, true);
                outputFileChannel = fos.getChannel();
                outputFileLock = outputFileChannel.lock(0L, Long.MAX_VALUE, false);
                File srcFileObject = null;
                for (String srcFile : fileList) {
                    FileChannel inputFileChannel;
                    FileInputStream fis;
                    block25: {
                        Object var14_16;
                        FileUtility.checkAbsolutePath(srcFile);
                        srcFileObject = new File(srcFile);
                        if (!srcFileObject.exists()) {
                            throw new FileException(srcFile + " is not exist.", srcFile);
                        }
                        fis = null;
                        inputFileChannel = null;
                        FileLock inputFileLock = null;
                        try {
                            fis = new FileInputStream(srcFileObject);
                            inputFileChannel = fis.getChannel();
                            ByteBuffer buffer = ByteBuffer.allocate(1024);
                            inputFileLock = inputFileChannel.lock(0L, Long.MAX_VALUE, true);
                            while (inputFileChannel.position() < inputFileChannel.size()) {
                                buffer.clear();
                                inputFileChannel.read(buffer);
                                buffer.flip();
                                outputFileChannel.write(buffer);
                            }
                            var14_16 = null;
                            if (inputFileLock == null) break block25;
                        }
                        catch (Throwable throwable) {
                            var14_16 = null;
                            if (inputFileLock != null) {
                                inputFileLock.release();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            if (inputFileChannel == null) throw throwable;
                            inputFileChannel.close();
                            throw throwable;
                        }
                        inputFileLock.release();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    if (inputFileChannel == null) continue;
                    inputFileChannel.close();
                }
                Object var16_18 = null;
            }
            catch (FileNotFoundException e) {
                throw new FileException("File control operation was failed.", e);
            }
            catch (IOException e) {
                throw new FileException("File control operation was failed.", e);
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            try {
                if (outputFileLock != null) {
                    outputFileLock.release();
                }
                if (fos != null) {
                    fos.close();
                }
                if (outputFileChannel == null) throw throwable;
                outputFileChannel.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (outputFileLock != null) {
            outputFileLock.release();
        }
        if (fos != null) {
            fos.close();
        }
        if (outputFileChannel == null) return;
        outputFileChannel.close();
        return;
    }

    public static void renameFile(String srcFile, String newFile) {
        boolean result;
        FileUtility.checkAbsolutePath(srcFile);
        FileUtility.checkAbsolutePath(newFile);
        File srcFileObject = new File(srcFile);
        File newFileObject = new File(newFile);
        if (!srcFileObject.exists()) {
            throw new FileException(srcFile + " is not exist.", srcFile);
        }
        if (newFileObject.exists() && checkFileExist) {
            result = newFileObject.delete();
            if (!result) {
                throw new FileException("File control operation was failed.", newFile);
            }
        } else if (newFileObject.exists() && !checkFileExist) {
            throw new FileException(newFile + " is exist.", newFile);
        }
        result = true;
        result = srcFileObject.renameTo(newFileObject);
        if (!result) {
            throw new FileException("File control operation was failed.");
        }
    }

    public static boolean isCheckFileExist() {
        return checkFileExist;
    }

    public static void setCheckFileExist(boolean checkFileExist) {
        FileUtility.checkFileExist = checkFileExist;
    }

    private static void checkAbsolutePath(String filePath) {
        if (filePath == null) {
            throw new FileException("File path is not set.", filePath);
        }
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            throw new FileException("File path is not absolute.", filePath);
        }
    }
}

